/**
 * This class file was automatically generated by jASN1 v1.8.2 (http://www.openmuc.org)
 */

package org.onosproject.xran.asn1lib.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.onosproject.xran.asn1lib.ber.BerByteArrayOutputStream;
import org.onosproject.xran.asn1lib.ber.BerTag;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;


public class ThresholdEUTRA implements Serializable {

    private static final long serialVersionUID = 1L;

    @JsonIgnore
    public byte[] code = null;
    private RSRPRange thresholdRSRP = null;
    private RSRQRange thresholdRSRQ = null;

    public ThresholdEUTRA() {
    }

    public ThresholdEUTRA(byte[] code) {
        this.code = code;
    }

    public RSRPRange getThresholdRSRP() {
        return thresholdRSRP;
    }

    public void setThresholdRSRP(RSRPRange thresholdRSRP) {
        this.thresholdRSRP = thresholdRSRP;
    }

    public RSRQRange getThresholdRSRQ() {
        return thresholdRSRQ;
    }

    public void setThresholdRSRQ(RSRQRange thresholdRSRQ) {
        this.thresholdRSRQ = thresholdRSRQ;
    }

    public int encode(BerByteArrayOutputStream os) throws IOException {

        if (code != null) {
            for (int i = code.length - 1; i >= 0; i--) {
                os.write(code[i]);
            }
            return code.length;
        }

        int codeLength = 0;
        if (thresholdRSRQ != null) {
            codeLength += thresholdRSRQ.encode(os, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 1
            os.write(0x81);
            codeLength += 1;
            return codeLength;
        }

        if (thresholdRSRP != null) {
            codeLength += thresholdRSRP.encode(os, false);
            // write tag: CONTEXT_CLASS, PRIMITIVE, 0
            os.write(0x80);
            codeLength += 1;
            return codeLength;
        }

        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {

        int codeLength = 0;
        BerTag passedTag = berTag;

        if (berTag == null) {
            berTag = new BerTag();
            codeLength += berTag.decode(is);
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
            thresholdRSRP = new RSRPRange();
            codeLength += thresholdRSRP.decode(is, false);
            return codeLength;
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
            thresholdRSRQ = new RSRQRange();
            codeLength += thresholdRSRQ.decode(is, false);
            return codeLength;
        }

        if (passedTag != null) {
            return 0;
        }

        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        BerByteArrayOutputStream os = new BerByteArrayOutputStream(encodingSizeGuess);
        encode(os);
        code = os.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

        if (thresholdRSRP != null) {
            sb.append("thresholdRSRP: ").append(thresholdRSRP);
            return;
        }

        if (thresholdRSRQ != null) {
            sb.append("thresholdRSRQ: ").append(thresholdRSRQ);
            return;
        }

        sb.append("<none>");
    }

}

