/**
 * This class file was automatically generated by jASN1 v1.8.2 (http://www.openmuc.org)
 */

package org.onosproject.xran.asn1lib.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.onosproject.xran.asn1lib.ber.BerByteArrayOutputStream;
import org.onosproject.xran.asn1lib.ber.BerLength;
import org.onosproject.xran.asn1lib.ber.BerTag;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;


public class L2ReportInterval implements Serializable {

    public static final BerTag tag = new BerTag(BerTag.UNIVERSAL_CLASS, BerTag.CONSTRUCTED, 16);
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    public byte[] code = null;
    private L2MeasReportInterval tRadioMeasReportPerUe = null;
    private L2MeasReportInterval tRadioMeasReportPerCell = null;
    private L2MeasReportInterval tRadioSchedReportPerUe = null;
    private L2MeasReportInterval tRadioSchedReportPerCell = null;
    private L2MeasReportInterval tPdcpMeasReportPerUe = null;

    public L2ReportInterval() {
    }

    public L2ReportInterval(byte[] code) {
        this.code = code;
    }

    public L2MeasReportInterval getTRadioMeasReportPerUe() {
        return tRadioMeasReportPerUe;
    }

    public void setTRadioMeasReportPerUe(L2MeasReportInterval tRadioMeasReportPerUe) {
        this.tRadioMeasReportPerUe = tRadioMeasReportPerUe;
    }

    public L2MeasReportInterval getTRadioMeasReportPerCell() {
        return tRadioMeasReportPerCell;
    }

    public void setTRadioMeasReportPerCell(L2MeasReportInterval tRadioMeasReportPerCell) {
        this.tRadioMeasReportPerCell = tRadioMeasReportPerCell;
    }

    public L2MeasReportInterval getTRadioSchedReportPerUe() {
        return tRadioSchedReportPerUe;
    }

    public void setTRadioSchedReportPerUe(L2MeasReportInterval tRadioSchedReportPerUe) {
        this.tRadioSchedReportPerUe = tRadioSchedReportPerUe;
    }

    public L2MeasReportInterval getTRadioSchedReportPerCell() {
        return tRadioSchedReportPerCell;
    }

    public void setTRadioSchedReportPerCell(L2MeasReportInterval tRadioSchedReportPerCell) {
        this.tRadioSchedReportPerCell = tRadioSchedReportPerCell;
    }

    public L2MeasReportInterval getTPdcpMeasReportPerUe() {
        return tPdcpMeasReportPerUe;
    }

    public void setTPdcpMeasReportPerUe(L2MeasReportInterval tPdcpMeasReportPerUe) {
        this.tPdcpMeasReportPerUe = tPdcpMeasReportPerUe;
    }

    public int encode(BerByteArrayOutputStream os) throws IOException {
        return encode(os, true);
    }

    public int encode(BerByteArrayOutputStream os, boolean withTag) throws IOException {

        if (code != null) {
            for (int i = code.length - 1; i >= 0; i--) {
                os.write(code[i]);
            }
            if (withTag) {
                return tag.encode(os) + code.length;
            }
            return code.length;
        }

        int codeLength = 0;
        codeLength += tPdcpMeasReportPerUe.encode(os, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 4
        os.write(0x84);
        codeLength += 1;

        codeLength += tRadioSchedReportPerCell.encode(os, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 3
        os.write(0x83);
        codeLength += 1;

        codeLength += tRadioSchedReportPerUe.encode(os, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 2
        os.write(0x82);
        codeLength += 1;

        codeLength += tRadioMeasReportPerCell.encode(os, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 1
        os.write(0x81);
        codeLength += 1;

        codeLength += tRadioMeasReportPerUe.encode(os, false);
        // write tag: CONTEXT_CLASS, PRIMITIVE, 0
        os.write(0x80);
        codeLength += 1;

        codeLength += BerLength.encodeLength(os, codeLength);

        if (withTag) {
            codeLength += tag.encode(os);
        }

        return codeLength;

    }

    public int decode(InputStream is) throws IOException {
        return decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();

        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }

        BerLength length = new BerLength();
        codeLength += length.decode(is);

        int totalLength = length.val;
        codeLength += totalLength;

        subCodeLength += berTag.decode(is);
        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 0)) {
            tRadioMeasReportPerUe = new L2MeasReportInterval();
            subCodeLength += tRadioMeasReportPerUe.decode(is, false);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 1)) {
            tRadioMeasReportPerCell = new L2MeasReportInterval();
            subCodeLength += tRadioMeasReportPerCell.decode(is, false);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 2)) {
            tRadioSchedReportPerUe = new L2MeasReportInterval();
            subCodeLength += tRadioSchedReportPerUe.decode(is, false);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 3)) {
            tRadioSchedReportPerCell = new L2MeasReportInterval();
            subCodeLength += tRadioSchedReportPerCell.decode(is, false);
            subCodeLength += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match the mandatory sequence element tag.");
        }

        if (berTag.equals(BerTag.CONTEXT_CLASS, BerTag.PRIMITIVE, 4)) {
            tPdcpMeasReportPerUe = new L2MeasReportInterval();
            subCodeLength += tPdcpMeasReportPerUe.decode(is, false);
            if (subCodeLength == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);


    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        BerByteArrayOutputStream os = new BerByteArrayOutputStream(encodingSizeGuess);
        encode(os, false);
        code = os.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {

        sb.append("{");
        sb.append("\n");
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (tRadioMeasReportPerUe != null) {
            sb.append("tRadioMeasReportPerUe: ").append(tRadioMeasReportPerUe);
        } else {
            sb.append("tRadioMeasReportPerUe: <empty-required-field>");
        }

        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (tRadioMeasReportPerCell != null) {
            sb.append("tRadioMeasReportPerCell: ").append(tRadioMeasReportPerCell);
        } else {
            sb.append("tRadioMeasReportPerCell: <empty-required-field>");
        }

        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (tRadioSchedReportPerUe != null) {
            sb.append("tRadioSchedReportPerUe: ").append(tRadioSchedReportPerUe);
        } else {
            sb.append("tRadioSchedReportPerUe: <empty-required-field>");
        }

        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (tRadioSchedReportPerCell != null) {
            sb.append("tRadioSchedReportPerCell: ").append(tRadioSchedReportPerCell);
        } else {
            sb.append("tRadioSchedReportPerCell: <empty-required-field>");
        }

        sb.append(",\n");
        for (int i = 0; i < indentLevel + 1; i++) {
            sb.append("\t");
        }
        if (tPdcpMeasReportPerUe != null) {
            sb.append("tPdcpMeasReportPerUe: ").append(tPdcpMeasReportPerUe);
        } else {
            sb.append("tPdcpMeasReportPerUe: <empty-required-field>");
        }

        sb.append("\n");
        for (int i = 0; i < indentLevel; i++) {
            sb.append("\t");
        }
        sb.append("}");
    }

}

