#!/bin/sh

cat <<EOF
tosca_definitions_version: tosca_simple_yaml_1_0

imports:
   - custom_types/xos.yaml

description: autogenerated nodes file

topology_template:
  node_templates:
    MyDeployment:
        type: tosca.nodes.Deployment
    mysite:
        type: tosca.nodes.Site
EOF

NODES=$( bash -c "source ./setup/admin-openrc.sh ; nova hypervisor-list" |grep enabled|awk '{print $4}' )
I=0
for NODE in $NODES; do
    # echo $NODE
    cat <<EOF
    $NODE:
      type: tosca.nodes.Node
      requirements:
        - site:
            node: mysite
            relationship: tosca.relationships.MemberOfSite
        - deployment:
            node: MyDeployment
            relationship: tosca.relationships.MemberOfDeployment
EOF
done
