"use strict";angular.module("xos.dashboardManager",["ngResource","ngCookies","ui.router","xos.helpers","dndLists"]).config(["$stateProvider",function(e){e.state("manage-user-dashboards",{url:"/",template:"<user-dashboards></user-dashboards>"}).state("add-dashboards",{url:"/add",template:"<dashboard-form></dashboard-form>"}).state("edit-dashboards",{url:"/dashboards/:id",template:"<dashboard-form></dashboard-form>"})}]).config(["$httpProvider",function(e){e.interceptors.push("NoHyperlinks")}]).service("UserDashboards",["$http","$q",function(e,s){this.query=function(){var n=s.defer();return e.get("/api/utility/dashboards").then(function(e){n.resolve(e.data)})["catch"](function(e){n.reject(e)}),{$promise:n.promise}},this.update=function(n){var a=s.defer();return e.post("/api/utility/dashboards/",n).then(function(e){a.resolve(e.data)})["catch"](function(e){a.reject(e)}),{$promise:a.promise}}}]);var _slicedToArray=function(){function e(e,s){var n=[],a=!0,r=!1,i=void 0;try{for(var d,o=e[Symbol.iterator]();!(a=(d=o.next()).done)&&(n.push(d.value),!s||n.length!==s);a=!0);}catch(t){r=!0,i=t}finally{try{!a&&o["return"]&&o["return"]()}finally{if(r)throw i}}return n}return function(s,n){if(Array.isArray(s))return s;if(Symbol.iterator in Object(s))return e(s,n);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();!function(){angular.module("xos.dashboardManager").directive("userDashboards",function(){return{restrict:"E",scope:{},bindToController:!0,controllerAs:"vm",templateUrl:"templates/user-dashboards.tpl.html",controller:["$q","_","UserDashboards","Dashboards",function(e,s,n,a){var r=this;e.all([n.query().$promise,a.query({enabled:"False"}).$promise]).then(function(e){var n=_slicedToArray(e,2),a=n[0],i=n[1];r.disabled=i,r.list={enabled:s.filter(a,{shown:!0}),disabled:s.filter(a,{shown:!1})}})["catch"](function(e){throw new Error(e)}),this.removeFromList=function(e,n){s.remove(r.list[e],{id:n})},this.addToList=function(e,s){r.list[e].push(s)},this.isInList=function(e,n){return s.find(r.list[e],n)},this.reorderList=function(e,n,a,r){var i=s.filter(e,function(e){return e.id!==r.id&&(e.order<a||e.order>=n)});i=i.map(function(e){return e.order++,e})},this.addedToList=function(e,s,a,i,d){var o=void 0,t=r.isInList(d,a);t?(o=a.order,t.order=s,a.order=s):(a.order=r.list[d].length,a.shown=!a.shown);var l="enabled"===d?"disabled":"enabled";n.update(a).$promise.then(function(e){t?r.reorderList(r.list[d],s,o,e):(r.addToList(d,e),r.removeFromList(l,e.id))})}}]}})}(),angular.module("xos.dashboardManager").run(["$templateCache",function(e){e.put("templates/dashboard-form.tpl.html",'<div class="row">\n  <div class="col-xs-10">\n    <h1>Manage Dashboard</h1>\n  </div>\n  <div class="col-xs-2 text-right">\n    <a ui-sref="manage-user-dashboards" class="btn btn-success">Back</a>\n  </div>\n</div>\n<div class="row">\n  <div class="col-xs-12">\n    <xos-form ng-model="vm.dashboard" config="vm.formConfig"></xos-form>\n  </div>\n</div>\n<div class="row" ng-show="vm.tosca">\n  <div class="col-sm-6">\n    <div class="row">\n      <div class="col-xs-12">\n        <xos-alert show="true" config="{type: \'info\'}">\n          Include this lines in a TOSCA recipe to load the {{vm.dashboard.name}} dashboard in the system.\n        </xos-alert>\n      </div>\n      <div class="col-xs-12">\n        <pre>{{vm.tosca}}</pre>\n      </div>\n    </div>\n  </div>\n  <div class="col-sm-6">\n    <div class="row">\n      <div class="col-xs-12">\n        <xos-alert show="true" config="{type: \'info\'}">\n          Add this lines as a requirement for the user in a TOSCA recipe to assign the {{vm.dashboard.name}} to the user.\n        </xos-alert>\n      </div>\n      <div class="col-xs-12">\n        <pre>{{vm.toscaRequirements}}</pre>\n      </div>\n    </div>\n  </div>\n</div>'),e.put("templates/user-dashboards.tpl.html",'<div class="row">\n  <div class="col-xs-10">\n    <h1>Manage Your Dashboards</h1>\n  </div>\n  <div class="col-xs-2 text-right">\n    <a ui-sref="add-dashboards" class="btn btn-success">Add</a>\n  </div>\n</div>\n\n<div class="row">\n  <div class="col-xs-6">\n    <div class="panel panel-primary">\n      <div class="panel-heading">\n        <h3 class="panel-title">\n          Available Dashboards\n        </h3>\n      </div>\n      <div class="panel-body">\n        <ul dnd-list="vm.list.disabled"\n          dnd-drop="vm.addedToList(event, index, item, external, \'disabled\')">\n          <li ng-repeat="item in vm.list.disabled"\n            dnd-moved="vm.removeFromList(\'disabled\', item.id)"\n            dnd-draggable="item">\n            {{item.name}}\n            <a ui-sref="edit-dashboards({id: item.id,})"><i class="glyphicon glyphicon-pencil"></i></a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n  <div class="col-xs-6">\n    <div class="panel panel-primary">\n      <div class="panel-heading">\n        <h3 class="panel-title">\n          Enabled Dashboards\n        </h3>\n      </div>\n      <div class="panel-body">\n        <ul dnd-list="vm.list.enabled"\n          dnd-drop="vm.addedToList(event, index, item, external, \'enabled\')">\n          <li ng-repeat="item in vm.list.enabled | orderBy : \'order\'"\n            dnd-moved="vm.removeFromList(\'enabled\', item.id)"\n            dnd-draggable="item">\n            {{item.name}}\n            <a ui-sref="edit-dashboards({id: item.id,})"><i class="glyphicon glyphicon-pencil"></i></a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n</div>\n<div class="row" ng-show="vm.disabled.length > 0">\n  <div class="col-xs-12">\n    <h1>Disabled Dashboard</h1>\n  </div>\n  <div class="col-xs-12">\n    <div class="row">\n      <div class="col-sm-2" ng-repeat="item in vm.disabled | orderBy : \'id\'">\n        <span class="dashboard-container">\n          {{item.name}}\n          <a ui-sref="edit-dashboards({id: item.id,})"><i class="glyphicon glyphicon-pencil"></i></a>\n        </span>\n      </div>\n    </div>\n  </div>\n</div>\n')}]),function(){angular.module("xos.dashboardManager").directive("dashboardForm",function(){return{restrict:"E",scope:{},bindToController:!0,controllerAs:"vm",templateUrl:"templates/dashboard-form.tpl.html",controller:["$stateParams","$log","Dashboards",function(e,s,n){var a=this;this.dashboard={enabled:!0},e.id&&n.get({id:e.id}).$promise.then(function(e){a.dashboard=e})["catch"](function(e){console.log(e)}),this.formConfig={exclude:["backend_register","controllers","deployments","enacted","humanReadableName","lazy_blocked","no_policy","no_sync","policed","write_protect"],actions:[{label:"Save",icon:"ok",cb:function(e){a.createOrUpdateDashboard(e)},"class":"success"},{label:"Esport to TOSCA",icon:"export",cb:function(e){a.toTosca(e)},"class":"primary"}],formName:"dashboardForm",feedback:{show:!1,message:"Form submitted successfully !!!",type:"success"},fields:{name:{type:"string",validators:{required:!0}},url:{type:"string",validators:{required:!0}},enabled:{type:"boolean"}}},this.createOrUpdateDashboard=function(e){var r=void 0;e.id?(delete e.controllers,delete e.deployments,r=e.$save()):r=n.save(e).$promise,r.then(function(e){a.formConfig.feedback.show=!0})["catch"](function(e){s.info(e),a.formConfig.feedback.show=!0,a.formConfig.feedback.message=e,a.formConfig.feedback.type="error"})},this.toTosca=function(e){var s={};s[e.name]={type:"tosca.nodes.DashboardView",properties:{url:e.url}},a.tosca=jsyaml.dump(s).replace(/'/g,"");var n={requirements:[]},r={};r[e.name.toLowerCase()+"_dashboard"]={node:e.name,relationship:"tosca.relationships.UsesDashboard"},n.requirements.push(r),a.toscaRequirements=jsyaml.dump(n).replace(/'/g,"")}}]}})}(),angular.module("xos.dashboardManager").run(["$location",function(e){e.path("/")}]);