
/*
 * Copyright 2017-present Open Networking Foundation

 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at

 * http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


"use strict";angular.module("xos.dashboardManager",["ngResource","ngCookies","ui.router","xos.helpers","dndLists"]).config(["$stateProvider",function(e){e.state("manage-user-dashboards",{url:"/",template:"<user-dashboards></user-dashboards>"}).state("add-dashboards",{url:"/add",template:"<dashboard-form></dashboard-form>"}).state("edit-dashboards",{url:"/dashboards/:id",template:"<dashboard-form></dashboard-form>"})}]).config(["$httpProvider",function(e){e.interceptors.push("NoHyperlinks")}]).service("UserDashboards",["$http","$q",function(e,n){this.query=function(){var s=n.defer();return e.get("/api/utility/dashboards").then(function(e){s.resolve(e.data)})["catch"](function(e){s.reject(e)}),{$promise:s.promise}},this.update=function(s){var a=n.defer();return e.post("/api/utility/dashboards/",s).then(function(e){a.resolve(e.data)})["catch"](function(e){a.reject(e)}),{$promise:a.promise}}}]);var _slicedToArray=function(){function e(e,n){var s=[],a=!0,i=!1,o=void 0;try{for(var r,t=e[Symbol.iterator]();!(a=(r=t.next()).done)&&(s.push(r.value),!n||s.length!==n);a=!0);}catch(d){i=!0,o=d}finally{try{!a&&t["return"]&&t["return"]()}finally{if(i)throw o}}return s}return function(n,s){if(Array.isArray(n))return n;if(Symbol.iterator in Object(n))return e(n,s);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();!function(){angular.module("xos.dashboardManager").directive("userDashboards",function(){return{restrict:"E",scope:{},bindToController:!0,controllerAs:"vm",templateUrl:"templates/user-dashboards.tpl.html",controller:["$q","_","UserDashboards","Dashboards",function(e,n,s,a){var i=this;e.all([s.query().$promise,a.query({enabled:"False"}).$promise]).then(function(e){var s=_slicedToArray(e,2),a=s[0],o=s[1];i.disabled=o,i.list={enabled:n.filter(a,{shown:!0}),disabled:n.filter(a,{shown:!1})}})["catch"](function(e){throw new Error(e)}),this.removeFromList=function(e,s){n.remove(i.list[e],{id:s})},this.addToList=function(e,n){i.list[e].push(n),location.reload()},this.isInList=function(e,s){return n.find(i.list[e],s)},this.reorderList=function(e,s,a,i){var o=n.filter(e,function(e){return e.id!==i.id&&(e.order<a||e.order>=s)});o=o.map(function(e){return e.order++,e})},this.addedToList=function(e,n,a,o,r){var t=void 0,d=i.isInList(r,a);d?(t=a.order,d.order=n,a.order=n):(a.order=i.list[r].length,a.shown=!a.shown);var l="enabled"===r?"disabled":"enabled";s.update(a).$promise.then(function(e){d?i.reorderList(i.list[r],n,t,e):(i.addToList(r,e),i.removeFromList(l,e.id))})}}]}})}(),angular.module("xos.dashboardManager").run(["$templateCache",function(e){e.put("templates/dashboard-form.tpl.html",'<div class="row">\n  <div class="col-xs-10">\n    <h1>Manage Dashboard</h1>\n  </div>\n  <div class="col-xs-2 text-right">\n    <a ui-sref="manage-user-dashboards" class="btn btn-success">Back</a>\n  </div>\n</div>\n<div class="row">\n  <div class="col-xs-12">\n    <xos-form ng-model="vm.dashboard" config="vm.formConfig"></xos-form>\n  </div>\n</div>\n<div class="row" ng-show="vm.tosca">\n  <div class="col-sm-6">\n    <div class="row">\n      <div class="col-xs-12">\n        <xos-alert show="true" config="{type: \'info\'}">\n          Include this lines in a TOSCA recipe to load the {{vm.dashboard.name}} dashboard in the system.\n        </xos-alert>\n      </div>\n      <div class="col-xs-12">\n        <pre>{{vm.tosca}}</pre>\n      </div>\n    </div>\n  </div>\n  <div class="col-sm-6">\n    <div class="row">\n      <div class="col-xs-12">\n        <xos-alert show="true" config="{type: \'info\'}">\n          Add this lines as a requirement for the user in a TOSCA recipe to assign the {{vm.dashboard.name}} to the user.\n        </xos-alert>\n      </div>\n      <div class="col-xs-12">\n        <pre>{{vm.toscaRequirements}}</pre>\n      </div>\n    </div>\n  </div>\n</div>'),e.put("templates/user-dashboards.tpl.html",'<div class="row">\n  <div class="col-xs-10">\n    <h1>Manage Your Dashboards</h1>\n  </div>\n  <div class="col-xs-2 text-right">\n    <a ui-sref="add-dashboards" class="btn btn-success">Add</a>\n  </div>\n</div>\n\n<div class="row">\n  <div class="col-xs-6">\n    <div class="panel panel-primary">\n      <div class="panel-heading">\n        <h3 class="panel-title">\n          Available Dashboards\n        </h3>\n      </div>\n      <div class="panel-body">\n        <ul dnd-list="vm.list.disabled"\n          dnd-drop="vm.addedToList(event, index, item, external, \'disabled\')">\n          <li ng-repeat="item in vm.list.disabled"\n            dnd-moved="vm.removeFromList(\'disabled\', item.id)"\n            dnd-draggable="item">\n            <a ui-sref="edit-dashboards({id: item.id,})">\n              <img src="/static/images/{{item.icon}}"></img>\n              {{item.name}}\n              <i class="glyphicon glyphicon-pencil"></i>\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n  <div class="col-xs-6">\n    <div class="panel panel-primary">\n      <div class="panel-heading">\n        <h3 class="panel-title">\n          Enabled Dashboards\n        </h3>\n      </div>\n      <div class="panel-body">\n        <ul dnd-list="vm.list.enabled"\n          dnd-drop="vm.addedToList(event, index, item, external, \'enabled\')">\n          <li ng-repeat="item in vm.list.enabled | orderBy : \'order\'"\n            dnd-moved="vm.removeFromList(\'enabled\', item.id)"\n            dnd-draggable="item">\n            <a ui-sref="edit-dashboards({id: item.id,})">\n              <img src="/static/images/{{item.icon}}"></img>\n              {{item.name}}\n              <i class="glyphicon glyphicon-pencil"></i>\n            </a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n</div>\n<div class="row" ng-show="vm.disabled.length > 0">\n  <div class="col-xs-12">\n    <h1>Disabled Dashboard</h1>\n  </div>\n  <div class="col-xs-12">\n    <div class="row">\n      <div class="col-sm-2" ng-repeat="item in vm.disabled | orderBy : \'id\'">\n        <span class="dashboard-container">\n          <a ui-sref="edit-dashboards({id: item.id,})">\n            <img src="/static/images/{{item.icon}}"></img>\n            {{item.name}}\n            <i class="glyphicon glyphicon-pencil"></i>\n          </a>\n        </span>\n      </div>\n    </div>\n  </div>\n</div>\n'),e.put("templates/users-list.tpl.html",'<xos-table config="vm.tableConfig" data="vm.users"></xos-table>')}]),function(){angular.module("xos.dashboardManager").directive("dashboardForm",function(){return{restrict:"E",scope:{},bindToController:!0,controllerAs:"vm",templateUrl:"templates/dashboard-form.tpl.html",controller:["$stateParams","$log","Dashboards",function(e,n,s){var a=this;this.dashboard={enabled:!0},e.id&&s.get({id:e.id}).$promise.then(function(e){a.dashboard=e})["catch"](function(e){console.log(e)}),this.formConfig={exclude:["backend_register","controllers","deployments","enacted","humanReadableName","lazy_blocked","no_policy","no_sync","policed","write_protect","icon","icon_active"],actions:[{label:"Save",icon:"ok",cb:function(e,n){if(n.$valid){if(e.name&&e.url&&e.custom_icon){var s=e.url.indexOf("xos");if(s>=0){var i=e.url.slice(s+3,e.url.length).toLowerCase();e.icon=i.concat("-icon.png"),e.icon_active=i.concat("-icon-active.png")}else e.icon="default-icon.png",e.icon_active="default-icon-active.png"}else e.icon="default-icon.png",e.icon_active="default-icon-active.png";a.createOrUpdateDashboard(e)}},"class":"success"},{label:"Esport to TOSCA",icon:"export",cb:function(e){a.toTosca(e)},"class":"primary"}],formName:"dashboardForm",feedback:{show:!1,message:"Form submitted successfully !!!",type:"success"},fields:{name:{type:"string",validators:{required:!0}},url:{type:"string",validators:{required:!0}},enabled:{type:"boolean"},custom_icon:{type:"boolean"}}},this.createOrUpdateDashboard=function(e){var i=void 0;e.id?(delete e.controllers,delete e.deployments,i=e.$save()):i=s.save(e).$promise,i.then(function(e){a.formConfig.feedback.show=!0})["catch"](function(e){n.info(e),a.formConfig.feedback.show=!0,a.formConfig.feedback.message=e,a.formConfig.feedback.type="danger"})},this.toTosca=function(e){var n={};n[e.name]={type:"tosca.nodes.DashboardView",properties:{url:e.url}},a.tosca=jsyaml.dump(n).replace(/'/g,"");var s={requirements:[]},i={};i[e.name.toLowerCase()+"_dashboard"]={node:e.name,relationship:"tosca.relationships.UsesDashboard"},s.requirements.push(i),a.toscaRequirements=jsyaml.dump(s).replace(/'/g,"")}}]}})}(),angular.module("xos.dashboardManager").run(["$location",function(e){e.path("/")}]);