"use strict";angular.module("xos.dashboardManager",["ngResource","ngCookies","ui.router","xos.helpers","dndLists"]).config(["$stateProvider",function(e){e.state("manage-user-dashboards",{url:"/",template:"<user-dashboards></user-dashboards>"}).state("add-dashboards",{url:"/add",template:"<dashboard-form></dashboard-form>"}).state("edit-dashboards",{url:"/dashboards/:id",template:"<dashboard-form></dashboard-form>"})}]).config(["$httpProvider",function(e){e.interceptors.push("NoHyperlinks")}]).service("UserDashboards",["$http","$q",function(e,n){this.query=function(){var a=n.defer();return e.get("/api/utility/dashboards").then(function(e){a.resolve(e.data)})["catch"](function(e){a.reject(e)}),{$promise:a.promise}},this.update=function(a){var s=n.defer();return e.post("/api/utility/dashboards/",a).then(function(e){s.resolve(e.data)})["catch"](function(e){s.reject(e)}),{$promise:s.promise}}}]);var _slicedToArray=function(){function e(e,n){var a=[],s=!0,i=!1,r=void 0;try{for(var o,t=e[Symbol.iterator]();!(s=(o=t.next()).done)&&(a.push(o.value),!n||a.length!==n);s=!0);}catch(d){i=!0,r=d}finally{try{!s&&t["return"]&&t["return"]()}finally{if(i)throw r}}return a}return function(n,a){if(Array.isArray(n))return n;if(Symbol.iterator in Object(n))return e(n,a);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}();!function(){angular.module("xos.dashboardManager").directive("userDashboards",function(){return{restrict:"E",scope:{},bindToController:!0,controllerAs:"vm",templateUrl:"templates/user-dashboards.tpl.html",controller:["$q","_","UserDashboards","Dashboards",function(e,n,a,s){var i=this;e.all([a.query().$promise,s.query({enabled:"False"}).$promise]).then(function(e){var a=_slicedToArray(e,2),s=a[0],r=a[1];i.disabled=r,i.list={enabled:n.filter(s,{shown:!0}),disabled:n.filter(s,{shown:!1})}})["catch"](function(e){throw new Error(e)}),this.removeFromList=function(e,a){n.remove(i.list[e],{id:a})},this.addToList=function(e,n){i.list[e].push(n)},this.isInList=function(e,a){return n.find(i.list[e],a)},this.reorderList=function(e,a,s,i){var r=n.filter(e,function(e){return e.id!==i.id&&(e.order<s||e.order>=a)});r=r.map(function(e){return e.order++,e})},this.addedToList=function(e,n,s,r,o){var t=void 0,d=i.isInList(o,s);d?(t=s.order,d.order=n,s.order=n):(s.order=i.list[o].length,s.shown=!s.shown);var l="enabled"===o?"disabled":"enabled";a.update(s).$promise.then(function(e){d?i.reorderList(i.list[o],n,t,e):(i.addToList(o,e),i.removeFromList(l,e.id))})}}]}})}(),angular.module("xos.dashboardManager").run(["$templateCache",function(e){e.put("templates/dashboard-form.tpl.html",'<div class="row">\n  <div class="col-xs-10">\n    <h1>Manage Dashboard</h1>\n  </div>\n  <div class="col-xs-2 text-right">\n    <a ui-sref="manage-user-dashboards" class="btn btn-success">Back</a>\n  </div>\n</div>\n<div class="row">\n  <div class="col-xs-12">\n    <xos-form ng-model="vm.dashboard" config="vm.formConfig"></xos-form>\n  </div>\n</div>\n<div class="row" ng-show="vm.tosca">\n  <div class="col-sm-6">\n    <div class="row">\n      <div class="col-xs-12">\n        <xos-alert show="true" config="{type: \'info\'}">\n          Include this lines in a TOSCA recipe to load the {{vm.dashboard.name}} dashboard in the system.\n        </xos-alert>\n      </div>\n      <div class="col-xs-12">\n        <pre>{{vm.tosca}}</pre>\n      </div>\n    </div>\n  </div>\n  <div class="col-sm-6">\n    <div class="row">\n      <div class="col-xs-12">\n        <xos-alert show="true" config="{type: \'info\'}">\n          Add this lines as a requirement for the user in a TOSCA recipe to assign the {{vm.dashboard.name}} to the user.\n        </xos-alert>\n      </div>\n      <div class="col-xs-12">\n        <pre>{{vm.toscaRequirements}}</pre>\n      </div>\n    </div>\n  </div>\n</div>'),e.put("templates/user-dashboards.tpl.html",'<div class="row">\n  <div class="col-xs-10">\n    <h1>Manage Your Dashboards</h1>\n  </div>\n  <div class="col-xs-2 text-right">\n    <a ui-sref="add-dashboards" class="btn btn-success">Add</a>\n  </div>\n</div>\n\n<div class="row">\n  <div class="col-xs-6">\n    <div class="panel panel-primary">\n      <div class="panel-heading">\n        <h3 class="panel-title">\n          Available Dashboards\n        </h3>\n      </div>\n      <div class="panel-body">\n        <ul dnd-list="vm.list.disabled"\n          dnd-drop="vm.addedToList(event, index, item, external, \'disabled\')">\n          <li ng-repeat="item in vm.list.disabled"\n            dnd-moved="vm.removeFromList(\'disabled\', item.id)"\n            dnd-draggable="item">\n            {{item.name}}\n            <a ui-sref="edit-dashboards({id: item.id,})"><i class="glyphicon glyphicon-pencil"></i></a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n  <div class="col-xs-6">\n    <div class="panel panel-primary">\n      <div class="panel-heading">\n        <h3 class="panel-title">\n          Enabled Dashboards\n        </h3>\n      </div>\n      <div class="panel-body">\n        <ul dnd-list="vm.list.enabled"\n          dnd-drop="vm.addedToList(event, index, item, external, \'enabled\')">\n          <li ng-repeat="item in vm.list.enabled | orderBy : \'order\'"\n            dnd-moved="vm.removeFromList(\'enabled\', item.id)"\n            dnd-draggable="item">\n            {{item.name}}\n            <a ui-sref="edit-dashboards({id: item.id,})"><i class="glyphicon glyphicon-pencil"></i></a>\n          </li>\n        </ul>\n      </div>\n    </div>\n  </div>\n</div>\n<div class="row" ng-show="vm.disabled.length > 0">\n  <div class="col-xs-12">\n    <h1>Disabled Dashboard</h1>\n  </div>\n  <div class="col-xs-12">\n    <div class="row">\n      <div class="col-sm-2" ng-repeat="item in vm.disabled | orderBy : \'id\'">\n        <span class="dashboard-container">\n          {{item.name}}\n          <a ui-sref="edit-dashboards({id: item.id,})"><i class="glyphicon glyphicon-pencil"></i></a>\n        </span>\n      </div>\n    </div>\n  </div>\n</div>\n')}]),function(){angular.module("xos.dashboardManager").directive("dashboardForm",function(){return{restrict:"E",scope:{},bindToController:!0,controllerAs:"vm",templateUrl:"templates/dashboard-form.tpl.html",controller:["$stateParams","$log","Dashboards",function(e,n,a){var s=this;this.dashboard={enabled:!0},e.id&&a.get({id:e.id}).$promise.then(function(e){s.dashboard=e})["catch"](function(e){console.log(e)}),this.formConfig={exclude:["backend_register","controllers","deployments","enacted","humanReadableName","lazy_blocked","no_policy","no_sync","policed","write_protect"],actions:[{label:"Save",icon:"ok",cb:function(e,n){if(n.$valid){if(e.name&&e.url&&e.custom_icon){var a=e.url.indexOf("xos");if(a>=0){var i=e.url.slice(a+3,e.url.length).toLowerCase();e.icon=i.concat("-icon.png"),e.icon_active=i.concat("-icon-active.png")}else e.icon="default-icon.png",e.icon_active="default-icon-active.png"}else e.icon="default-icon.png",e.icon_active="default-icon-active.png";s.createOrUpdateDashboard(e)}},"class":"success"},{label:"Esport to TOSCA",icon:"export",cb:function(e){s.toTosca(e)},"class":"primary"}],formName:"dashboardForm",feedback:{show:!1,message:"Form submitted successfully !!!",type:"success"},fields:{name:{type:"string",validators:{required:!0}},url:{type:"string",validators:{required:!0}},enabled:{type:"boolean"},custom_icon:{type:"boolean"}}},this.createOrUpdateDashboard=function(e){var i=void 0;e.id?(delete e.controllers,delete e.deployments,i=e.$save()):i=a.save(e).$promise,i.then(function(e){s.formConfig.feedback.show=!0})["catch"](function(e){n.info(e),s.formConfig.feedback.show=!0,s.formConfig.feedback.message=e,s.formConfig.feedback.type="danger"})},this.toTosca=function(e){var n={};n[e.name]={type:"tosca.nodes.DashboardView",properties:{url:e.url}},s.tosca=jsyaml.dump(n).replace(/'/g,"");var a={requirements:[]},i={};i[e.name.toLowerCase()+"_dashboard"]={node:e.name,relationship:"tosca.relationships.UsesDashboard"},a.requirements.push(i),s.toscaRequirements=jsyaml.dump(a).replace(/'/g,"")}}]}})}(),angular.module("xos.dashboardManager").run(["$location",function(e){e.path("/")}]);