(function(){"use strict";var t=this,e=t.Chart,i=function(t){this.canvas=t.canvas,this.ctx=t;var e=function(t,e){return t["offset"+e]?t["offset"+e]:document.defaultView.getComputedStyle(t).getPropertyValue(e)},i=this.width=e(t.canvas,"Width"),s=this.height=e(t.canvas,"Height");t.canvas.width=i,t.canvas.height=s;var i=this.width=t.canvas.width,s=this.height=t.canvas.height;return this.aspectRatio=this.width/this.height,n.retinaScale(this),this};i.defaults={global:{animation:!0,animationSteps:60,animationEasing:"easeOutQuart",showScale:!0,scaleOverride:!1,scaleSteps:null,scaleStepWidth:null,scaleStartValue:null,scaleLineColor:"rgba(0,0,0,.1)",scaleLineWidth:1,scaleShowLabels:!0,scaleLabel:"<%=value%>",scaleIntegersOnly:!0,scaleBeginAtZero:!1,scaleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",scaleFontSize:12,scaleFontStyle:"normal",scaleFontColor:"#666",responsive:!1,maintainAspectRatio:!0,showTooltips:!0,customTooltips:!1,tooltipEvents:["mousemove","touchstart","touchmove","mouseout"],tooltipFillColor:"rgba(0,0,0,0.8)",tooltipFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipFontSize:14,tooltipFontStyle:"normal",tooltipFontColor:"#fff",tooltipTitleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipTitleFontSize:14,tooltipTitleFontStyle:"bold",tooltipTitleFontColor:"#fff",tooltipYPadding:6,tooltipXPadding:6,tooltipCaretSize:8,tooltipCornerRadius:6,tooltipXOffset:10,tooltipTemplate:"<%if (label){%><%=label%>: <%}%><%= value %>",multiTooltipTemplate:"<%= value %>",multiTooltipKeyBackground:"#fff",onAnimationProgress:function(){},onAnimationComplete:function(){}}},i.types={};var n=i.helpers={},s=n.each=function(t,e,i){var n=Array.prototype.slice.call(arguments,3);if(t)if(t.length===+t.length){var s;for(s=0;s<t.length;s++)e.apply(i,[t[s],s].concat(n))}else for(var o in t)e.apply(i,[t[o],o].concat(n))},o=n.clone=function(t){var e={};return s(t,function(i,n){t.hasOwnProperty(n)&&(e[n]=i)}),e},a=n.extend=function(t){return s(Array.prototype.slice.call(arguments,1),function(e){s(e,function(i,n){e.hasOwnProperty(n)&&(t[n]=i)})}),t},r=n.merge=function(t,e){var i=Array.prototype.slice.call(arguments,0);return i.unshift({}),a.apply(null,i)},l=n.indexOf=function(t,e){if(Array.prototype.indexOf)return t.indexOf(e);for(var i=0;i<t.length;i++)if(t[i]===e)return i;return-1},h=(n.where=function(t,e){var i=[];return n.each(t,function(t){e(t)&&i.push(t)}),i},n.findNextWhere=function(t,e,i){i||(i=-1);for(var n=i+1;n<t.length;n++){var s=t[n];if(e(s))return s}},n.findPreviousWhere=function(t,e,i){i||(i=t.length);for(var n=i-1;n>=0;n--){var s=t[n];if(e(s))return s}},n.inherits=function(t){var e=this,i=t&&t.hasOwnProperty("constructor")?t.constructor:function(){return e.apply(this,arguments)},n=function(){this.constructor=i};return n.prototype=e.prototype,i.prototype=new n,i.extend=h,t&&a(i.prototype,t),i.__super__=e.prototype,i}),c=n.noop=function(){},u=n.uid=function(){var t=0;return function(){return"chart-"+t++}}(),d=n.warn=function(t){window.console&&"function"==typeof window.console.warn&&console.warn(t)},f=n.amd="function"==typeof define&&define.amd,p=n.isNumber=function(t){return!isNaN(parseFloat(t))&&isFinite(t)},g=n.max=function(t){return Math.max.apply(Math,t)},v=n.min=function(t){return Math.min.apply(Math,t)},m=(n.cap=function(t,e,i){if(p(e)){if(t>e)return e}else if(p(i)&&i>t)return i;return t},n.getDecimalPlaces=function(t){return t%1!==0&&p(t)?t.toString().split(".")[1].length:0}),C=n.radians=function(t){return t*(Math.PI/180)},y=(n.getAngleFromPoint=function(t,e){var i=e.x-t.x,n=e.y-t.y,s=Math.sqrt(i*i+n*n),o=2*Math.PI+Math.atan2(n,i);return 0>i&&0>n&&(o+=2*Math.PI),{angle:o,distance:s}},n.aliasPixel=function(t){return t%2===0?0:.5}),b=(n.splineCurve=function(t,e,i,n){var s=Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2)),o=Math.sqrt(Math.pow(i.x-e.x,2)+Math.pow(i.y-e.y,2)),a=n*s/(s+o),r=n*o/(s+o);return{inner:{x:e.x-a*(i.x-t.x),y:e.y-a*(i.y-t.y)},outer:{x:e.x+r*(i.x-t.x),y:e.y+r*(i.y-t.y)}}},n.calculateOrderOfMagnitude=function(t){return Math.floor(Math.log(t)/Math.LN10)}),w=(n.calculateScaleRange=function(t,e,i,n,s){var o=2,a=Math.floor(e/(1.5*i)),r=o>=a,l=g(t),h=v(t);l===h&&(l+=.5,h>=.5&&!n?h-=.5:l+=.5);for(var c=Math.abs(l-h),u=b(c),d=Math.ceil(l/(1*Math.pow(10,u)))*Math.pow(10,u),f=n?0:Math.floor(h/(1*Math.pow(10,u)))*Math.pow(10,u),p=d-f,m=Math.pow(10,u),C=Math.round(p/m);(C>a||a>2*C)&&!r;)if(C>a)m*=2,C=Math.round(p/m),C%1!==0&&(r=!0);else if(s&&u>=0){if(m/2%1!==0)break;m/=2,C=Math.round(p/m)}else m/=2,C=Math.round(p/m);return r&&(C=o,m=p/C),{steps:C,stepValue:m,min:f,max:f+C*m}},n.template=function(t,e){function i(t,e){var i=/\W/.test(t)?new Function("obj","var p=[],print=function(){p.push.apply(p,arguments);};with(obj){p.push('"+t.replace(/[\r\t\n]/g," ").split("<%").join("	").replace(/((^|%>)[^\t]*)'/g,"$1\r").replace(/\t=(.*?)%>/g,"',$1,'").split("	").join("');").split("%>").join("p.push('").split("\r").join("\\'")+"');}return p.join('');"):n[t]=n[t];return e?i(e):i}if(t instanceof Function)return t(e);var n={};return i(t,e)}),x=(n.generateLabels=function(t,e,i,n){var o=new Array(e);return labelTemplateString&&s(o,function(e,s){o[s]=w(t,{value:i+n*(s+1)})}),o},n.easingEffects={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-1*t*(t-2)},easeInOutQuad:function(t){return(t/=.5)<1?.5*t*t:-0.5*(--t*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return 1*((t=t/1-1)*t*t+1)},easeInOutCubic:function(t){return(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-1*((t=t/1-1)*t*t*t-1)},easeInOutQuart:function(t){return(t/=.5)<1?.5*t*t*t*t:-0.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return 1*(t/=1)*t*t*t*t},easeOutQuint:function(t){return 1*((t=t/1-1)*t*t*t*t+1)},easeInOutQuint:function(t){return(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return-1*Math.cos(t/1*(Math.PI/2))+1},easeOutSine:function(t){return 1*Math.sin(t/1*(Math.PI/2))},easeInOutSine:function(t){return-0.5*(Math.cos(Math.PI*t/1)-1)},easeInExpo:function(t){return 0===t?1:1*Math.pow(2,10*(t/1-1))},easeOutExpo:function(t){return 1===t?1:1*(-Math.pow(2,-10*t/1)+1)},easeInOutExpo:function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(-Math.pow(2,-10*--t)+2)},easeInCirc:function(t){return t>=1?t:-1*(Math.sqrt(1-(t/=1)*t)-1)},easeOutCirc:function(t){return 1*Math.sqrt(1-(t=t/1-1)*t)},easeInOutCirc:function(t){return(t/=.5)<1?-0.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var e=1.70158,i=0,n=1;return 0===t?0:1==(t/=1)?1:(i||(i=.3),n<Math.abs(1)?(n=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/n),-(n*Math.pow(2,10*(t-=1))*Math.sin((1*t-e)*(2*Math.PI)/i)))},easeOutElastic:function(t){var e=1.70158,i=0,n=1;return 0===t?0:1==(t/=1)?1:(i||(i=.3),n<Math.abs(1)?(n=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/n),n*Math.pow(2,-10*t)*Math.sin((1*t-e)*(2*Math.PI)/i)+1)},easeInOutElastic:function(t){var e=1.70158,i=0,n=1;return 0===t?0:2==(t/=.5)?1:(i||(i=1*(.3*1.5)),n<Math.abs(1)?(n=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/n),1>t?-.5*(n*Math.pow(2,10*(t-=1))*Math.sin((1*t-e)*(2*Math.PI)/i)):n*Math.pow(2,-10*(t-=1))*Math.sin((1*t-e)*(2*Math.PI)/i)*.5+1)},easeInBack:function(t){var e=1.70158;return 1*(t/=1)*t*((e+1)*t-e)},easeOutBack:function(t){var e=1.70158;return 1*((t=t/1-1)*t*((e+1)*t+e)+1)},easeInOutBack:function(t){var e=1.70158;return(t/=.5)<1?.5*(t*t*(((e*=1.525)+1)*t-e)):.5*((t-=2)*t*(((e*=1.525)+1)*t+e)+2)},easeInBounce:function(t){return 1-x.easeOutBounce(1-t)},easeOutBounce:function(t){return(t/=1)<1/2.75?1*(7.5625*t*t):2/2.75>t?1*(7.5625*(t-=1.5/2.75)*t+.75):2.5/2.75>t?1*(7.5625*(t-=2.25/2.75)*t+.9375):1*(7.5625*(t-=2.625/2.75)*t+.984375)},easeInOutBounce:function(t){return.5>t?.5*x.easeInBounce(2*t):.5*x.easeOutBounce(2*t-1)+.5}}),S=n.requestAnimFrame=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){return window.setTimeout(t,1e3/60)}}(),P=n.cancelAnimFrame=function(){return window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(t){return window.clearTimeout(t,1e3/60)}}(),k=(n.animationLoop=function(t,e,i,n,s,o){var a=0,r=x[i]||x.linear,l=function(){a++;var i=a/e,h=r(i);t.call(o,h,i,a),n.call(o,h,i),e>a?o.animationFrame=S(l):s.apply(o)};S(l)},n.getRelativePosition=function(t){var e,i,n=t.originalEvent||t,s=t.currentTarget||t.srcElement,o=s.getBoundingClientRect();return n.touches?(e=n.touches[0].clientX-o.left,i=n.touches[0].clientY-o.top):(e=n.clientX-o.left,i=n.clientY-o.top),{x:e,y:i}},n.addEvent=function(t,e,i){t.addEventListener?t.addEventListener(e,i):t.attachEvent?t.attachEvent("on"+e,i):t["on"+e]=i}),A=n.removeEvent=function(t,e,i){t.removeEventListener?t.removeEventListener(e,i,!1):t.detachEvent?t.detachEvent("on"+e,i):t["on"+e]=c},L=(n.bindEvents=function(t,e,i){t.events||(t.events={}),s(e,function(e){t.events[e]=function(){i.apply(t,arguments)},k(t.chart.canvas,e,t.events[e])})},n.unbindEvents=function(t,e){s(e,function(e,i){A(t.chart.canvas,i,e)})}),$=n.getMaximumWidth=function(t){var e=t.parentNode;return e.clientWidth},F=n.getMaximumHeight=function(t){var e=t.parentNode;return e.clientHeight},T=(n.getMaximumSize=n.getMaximumWidth,n.retinaScale=function(t){var e=t.ctx,i=t.canvas.width,n=t.canvas.height;window.devicePixelRatio&&(e.canvas.style.width=i+"px",e.canvas.style.height=n+"px",e.canvas.height=n*window.devicePixelRatio,e.canvas.width=i*window.devicePixelRatio,e.scale(window.devicePixelRatio,window.devicePixelRatio))}),R=n.clear=function(t){t.ctx.clearRect(0,0,t.width,t.height)},D=n.fontString=function(t,e,i){return e+" "+t+"px "+i},M=n.longestText=function(t,e,i){t.font=e;var n=0;return s(i,function(e){var i=t.measureText(e).width;n=i>n?i:n}),n},W=n.drawRoundedRectangle=function(t,e,i,n,s,o){t.beginPath(),t.moveTo(e+o,i),t.lineTo(e+n-o,i),t.quadraticCurveTo(e+n,i,e+n,i+o),t.lineTo(e+n,i+s-o),t.quadraticCurveTo(e+n,i+s,e+n-o,i+s),t.lineTo(e+o,i+s),t.quadraticCurveTo(e,i+s,e,i+s-o),t.lineTo(e,i+o),t.quadraticCurveTo(e,i,e+o,i),t.closePath()};i.instances={},i.Type=function(t,e,n){this.options=e,this.chart=n,this.id=u(),i.instances[this.id]=this,e.responsive&&this.resize(),this.initialize.call(this,t)},a(i.Type.prototype,{initialize:function(){return this},clear:function(){return R(this.chart),this},stop:function(){return P(this.animationFrame),this},resize:function(t){this.stop();var e=this.chart.canvas,i=$(this.chart.canvas),n=this.options.maintainAspectRatio?i/this.chart.aspectRatio:F(this.chart.canvas);return e.width=this.chart.width=i,e.height=this.chart.height=n,T(this.chart),"function"==typeof t&&t.apply(this,Array.prototype.slice.call(arguments,1)),this},reflow:c,render:function(t){return t&&this.reflow(),this.options.animation&&!t?n.animationLoop(this.draw,this.options.animationSteps,this.options.animationEasing,this.options.onAnimationProgress,this.options.onAnimationComplete,this):(this.draw(),this.options.onAnimationComplete.call(this)),this},generateLegend:function(){return w(this.options.legendTemplate,this)},destroy:function(){this.clear(),L(this,this.events);var t=this.chart.canvas;t.width=this.chart.width,t.height=this.chart.height,t.style.removeProperty?(t.style.removeProperty("width"),t.style.removeProperty("height")):(t.style.removeAttribute("width"),t.style.removeAttribute("height")),delete i.instances[this.id]},showTooltip:function(t,e){"undefined"==typeof this.activeElements&&(this.activeElements=[]);var o=function(t){var e=!1;return t.length!==this.activeElements.length?e=!0:(s(t,function(t,i){t!==this.activeElements[i]&&(e=!0)},this),e)}.call(this,t);if(o||e){if(this.activeElements=t,this.draw(),this.options.customTooltips&&this.options.customTooltips(!1),t.length>0)if(this.datasets&&this.datasets.length>1){for(var a,r,h=this.datasets.length-1;h>=0&&(a=this.datasets[h].points||this.datasets[h].bars||this.datasets[h].segments,r=l(a,t[0]),-1===r);h--);var c=[],u=[],d=function(t){var e,i,s,o,a,l=[],h=[],d=[];return n.each(this.datasets,function(t){e=t.points||t.bars||t.segments,e[r]&&e[r].hasValue()&&l.push(e[r])}),n.each(l,function(t){h.push(t.x),d.push(t.y),c.push(n.template(this.options.multiTooltipTemplate,t)),u.push({fill:t._saved.fillColor||t.fillColor,stroke:t._saved.strokeColor||t.strokeColor})},this),a=v(d),s=g(d),o=v(h),i=g(h),{x:o>this.chart.width/2?o:i,y:(a+s)/2}}.call(this,r);new i.MultiTooltip({x:d.x,y:d.y,xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,xOffset:this.options.tooltipXOffset,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,titleTextColor:this.options.tooltipTitleFontColor,titleFontFamily:this.options.tooltipTitleFontFamily,titleFontStyle:this.options.tooltipTitleFontStyle,titleFontSize:this.options.tooltipTitleFontSize,cornerRadius:this.options.tooltipCornerRadius,labels:c,legendColors:u,legendColorBackground:this.options.multiTooltipKeyBackground,title:t[0].label,chart:this.chart,ctx:this.chart.ctx,custom:this.options.customTooltips}).draw()}else s(t,function(t){var e=t.tooltipPosition();new i.Tooltip({x:Math.round(e.x),y:Math.round(e.y),xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,caretHeight:this.options.tooltipCaretSize,cornerRadius:this.options.tooltipCornerRadius,text:w(this.options.tooltipTemplate,t),chart:this.chart,custom:this.options.customTooltips}).draw()},this);return this}},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments)}}),i.Type.extend=function(t){var e=this,n=function(){return e.apply(this,arguments)};if(n.prototype=o(e.prototype),a(n.prototype,t),n.extend=i.Type.extend,t.name||e.prototype.name){var s=t.name||e.prototype.name,l=i.defaults[e.prototype.name]?o(i.defaults[e.prototype.name]):{};i.defaults[s]=a(l,t.defaults),i.types[s]=n,i.prototype[s]=function(t,e){var o=r(i.defaults.global,i.defaults[s],e||{});return new n(t,o,this)}}else d("Name not provided for this chart, so it hasn't been registered");return e},i.Element=function(t){a(this,t),this.initialize.apply(this,arguments),this.save()},a(i.Element.prototype,{initialize:function(){},restore:function(t){return t?s(t,function(t){this[t]=this._saved[t]},this):a(this,this._saved),this},save:function(){return this._saved=o(this),delete this._saved._saved,this},update:function(t){return s(t,function(t,e){this._saved[e]=this[e],this[e]=t},this),this},transition:function(t,e){return s(t,function(t,i){this[i]=(t-this._saved[i])*e+this._saved[i]},this),this},tooltipPosition:function(){return{x:this.x,y:this.y}},hasValue:function(){return p(this.value)}}),i.Element.extend=h,i.Point=i.Element.extend({display:!0,inRange:function(t,e){var i=this.hitDetectionRadius+this.radius;return Math.pow(t-this.x,2)+Math.pow(e-this.y,2)<Math.pow(i,2)},draw:function(){if(this.display){var t=this.ctx;t.beginPath(),t.arc(this.x,this.y,this.radius,0,2*Math.PI),t.closePath(),t.strokeStyle=this.strokeColor,t.lineWidth=this.strokeWidth,t.fillStyle=this.fillColor,t.fill(),t.stroke()}}}),i.Arc=i.Element.extend({inRange:function(t,e){var i=n.getAngleFromPoint(this,{x:t,y:e}),s=i.angle>=this.startAngle&&i.angle<=this.endAngle,o=i.distance>=this.innerRadius&&i.distance<=this.outerRadius;return s&&o},tooltipPosition:function(){var t=this.startAngle+(this.endAngle-this.startAngle)/2,e=(this.outerRadius-this.innerRadius)/2+this.innerRadius;return{x:this.x+Math.cos(t)*e,y:this.y+Math.sin(t)*e}},draw:function(t){var e=this.ctx;e.beginPath(),e.arc(this.x,this.y,this.outerRadius,this.startAngle,this.endAngle),e.arc(this.x,this.y,this.innerRadius,this.endAngle,this.startAngle,!0),e.closePath(),e.strokeStyle=this.strokeColor,e.lineWidth=this.strokeWidth,e.fillStyle=this.fillColor,e.fill(),e.lineJoin="bevel",this.showStroke&&e.stroke()}}),i.Rectangle=i.Element.extend({draw:function(){var t=this.ctx,e=this.width/2,i=this.x-e,n=this.x+e,s=this.base-(this.base-this.y),o=this.strokeWidth/2;this.showStroke&&(i+=o,n-=o,s+=o),t.beginPath(),t.fillStyle=this.fillColor,t.strokeStyle=this.strokeColor,t.lineWidth=this.strokeWidth,t.moveTo(i,this.base),t.lineTo(i,s),t.lineTo(n,s),t.lineTo(n,this.base),t.fill(),this.showStroke&&t.stroke()},height:function(){return this.base-this.y},inRange:function(t,e){return t>=this.x-this.width/2&&t<=this.x+this.width/2&&e>=this.y&&e<=this.base}}),i.Tooltip=i.Element.extend({draw:function(){var t=this.chart.ctx;t.font=D(this.fontSize,this.fontStyle,this.fontFamily),this.xAlign="center",this.yAlign="above";var e=this.caretPadding=2,i=t.measureText(this.text).width+2*this.xPadding,n=this.fontSize+2*this.yPadding,s=n+this.caretHeight+e;this.x+i/2>this.chart.width?this.xAlign="left":this.x-i/2<0&&(this.xAlign="right"),this.y-s<0&&(this.yAlign="below");var o=this.x-i/2,a=this.y-s;if(t.fillStyle=this.fillColor,this.custom)this.custom(this);else{switch(this.yAlign){case"above":t.beginPath(),t.moveTo(this.x,this.y-e),t.lineTo(this.x+this.caretHeight,this.y-(e+this.caretHeight)),t.lineTo(this.x-this.caretHeight,this.y-(e+this.caretHeight)),t.closePath(),t.fill();break;case"below":a=this.y+e+this.caretHeight,t.beginPath(),t.moveTo(this.x,this.y+e),t.lineTo(this.x+this.caretHeight,this.y+e+this.caretHeight),t.lineTo(this.x-this.caretHeight,this.y+e+this.caretHeight),t.closePath(),t.fill()}switch(this.xAlign){case"left":o=this.x-i+(this.cornerRadius+this.caretHeight);break;case"right":o=this.x-(this.cornerRadius+this.caretHeight)}W(t,o,a,i,n,this.cornerRadius),t.fill(),t.fillStyle=this.textColor,t.textAlign="center",t.textBaseline="middle",t.fillText(this.text,o+i/2,a+n/2)}}}),i.MultiTooltip=i.Element.extend({initialize:function(){this.font=D(this.fontSize,this.fontStyle,this.fontFamily),this.titleFont=D(this.titleFontSize,this.titleFontStyle,this.titleFontFamily),this.height=this.labels.length*this.fontSize+(this.labels.length-1)*(this.fontSize/2)+2*this.yPadding+1.5*this.titleFontSize,this.ctx.font=this.titleFont;var t=this.ctx.measureText(this.title).width,e=M(this.ctx,this.font,this.labels)+this.fontSize+3,i=g([e,t]);this.width=i+2*this.xPadding;var n=this.height/2;this.y-n<0?this.y=n:this.y+n>this.chart.height&&(this.y=this.chart.height-n),this.x>this.chart.width/2?this.x-=this.xOffset+this.width:this.x+=this.xOffset},getLineHeight:function(t){var e=this.y-this.height/2+this.yPadding,i=t-1;return 0===t?e+this.titleFontSize/2:e+(1.5*this.fontSize*i+this.fontSize/2)+1.5*this.titleFontSize},draw:function(){if(this.custom)this.custom(this);else{W(this.ctx,this.x,this.y-this.height/2,this.width,this.height,this.cornerRadius);var t=this.ctx;t.fillStyle=this.fillColor,t.fill(),t.closePath(),t.textAlign="left",t.textBaseline="middle",t.fillStyle=this.titleTextColor,t.font=this.titleFont,t.fillText(this.title,this.x+this.xPadding,this.getLineHeight(0)),t.font=this.font,n.each(this.labels,function(e,i){t.fillStyle=this.textColor,t.fillText(e,this.x+this.xPadding+this.fontSize+3,this.getLineHeight(i+1)),t.fillStyle=this.legendColorBackground,t.fillRect(this.x+this.xPadding,this.getLineHeight(i+1)-this.fontSize/2,this.fontSize,this.fontSize),t.fillStyle=this.legendColors[i].fill,t.fillRect(this.x+this.xPadding,this.getLineHeight(i+1)-this.fontSize/2,this.fontSize,this.fontSize)},this)}}}),i.Scale=i.Element.extend({initialize:function(){this.fit()},buildYLabels:function(){this.yLabels=[];for(var t=m(this.stepValue),e=0;e<=this.steps;e++)this.yLabels.push(w(this.templateString,{value:(this.min+e*this.stepValue).toFixed(t)}));this.yLabelWidth=this.display&&this.showLabels?M(this.ctx,this.font,this.yLabels):0},addXLabel:function(t){this.xLabels.push(t),this.valuesCount++,this.fit()},removeXLabel:function(){this.xLabels.shift(),this.valuesCount--,this.fit()},fit:function(){this.startPoint=this.display?this.fontSize:0,this.endPoint=this.display?this.height-1.5*this.fontSize-5:this.height,this.startPoint+=this.padding,this.endPoint-=this.padding;var t,e=this.endPoint-this.startPoint;for(this.calculateYRange(e),this.buildYLabels(),this.calculateXLabelRotation();e>this.endPoint-this.startPoint;)e=this.endPoint-this.startPoint,t=this.yLabelWidth,this.calculateYRange(e),this.buildYLabels(),t<this.yLabelWidth&&this.calculateXLabelRotation()},calculateXLabelRotation:function(){this.ctx.font=this.font;var t,e,i=this.ctx.measureText(this.xLabels[0]).width,n=this.ctx.measureText(this.xLabels[this.xLabels.length-1]).width;if(this.xScalePaddingRight=n/2+3,this.xScalePaddingLeft=i/2>this.yLabelWidth+10?i/2:this.yLabelWidth+10,this.xLabelRotation=0,this.display){var s,o=M(this.ctx,this.font,this.xLabels);this.xLabelWidth=o;for(var a=Math.floor(this.calculateX(1)-this.calculateX(0))-6;this.xLabelWidth>a&&0===this.xLabelRotation||this.xLabelWidth>a&&this.xLabelRotation<=90&&this.xLabelRotation>0;)s=Math.cos(C(this.xLabelRotation)),t=s*i,e=s*n,t+this.fontSize/2>this.yLabelWidth+8&&(this.xScalePaddingLeft=t+this.fontSize/2),this.xScalePaddingRight=this.fontSize/2,this.xLabelRotation++,this.xLabelWidth=s*o;this.xLabelRotation>0&&(this.endPoint-=Math.sin(C(this.xLabelRotation))*o+3)}else this.xLabelWidth=0,this.xScalePaddingRight=this.padding,this.xScalePaddingLeft=this.padding},calculateYRange:c,drawingArea:function(){return this.startPoint-this.endPoint},calculateY:function(t){var e=this.drawingArea()/(this.min-this.max);return this.endPoint-e*(t-this.min)},calculateX:function(t){var e=(this.xLabelRotation>0,this.width-(this.xScalePaddingLeft+this.xScalePaddingRight)),i=e/Math.max(this.valuesCount-(this.offsetGridLines?0:1),1),n=i*t+this.xScalePaddingLeft;return this.offsetGridLines&&(n+=i/2),Math.round(n)},update:function(t){n.extend(this,t),this.fit()},draw:function(){var t=this.ctx,e=(this.endPoint-this.startPoint)/this.steps,i=Math.round(this.xScalePaddingLeft);this.display&&(t.fillStyle=this.textColor,t.font=this.font,s(this.yLabels,function(s,o){var a=this.endPoint-e*o,r=Math.round(a),l=this.showHorizontalLines;t.textAlign="right",t.textBaseline="middle",this.showLabels&&t.fillText(s,i-10,a),0!==o||l||(l=!0),l&&t.beginPath(),o>0?(t.lineWidth=this.gridLineWidth,t.strokeStyle=this.gridLineColor):(t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor),r+=n.aliasPixel(t.lineWidth),l&&(t.moveTo(i,r),t.lineTo(this.width,r),t.stroke(),t.closePath()),t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor,t.beginPath(),t.moveTo(i-5,r),t.lineTo(i,r),t.stroke(),t.closePath()},this),s(this.xLabels,function(e,i){var n=this.calculateX(i)+y(this.lineWidth),s=this.calculateX(i-(this.offsetGridLines?.5:0))+y(this.lineWidth),o=this.xLabelRotation>0,a=this.showVerticalLines;0!==i||a||(a=!0),a&&t.beginPath(),i>0?(t.lineWidth=this.gridLineWidth,t.strokeStyle=this.gridLineColor):(t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor),a&&(t.moveTo(s,this.endPoint),t.lineTo(s,this.startPoint-3),t.stroke(),t.closePath()),t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor,t.beginPath(),t.moveTo(s,this.endPoint),t.lineTo(s,this.endPoint+5),t.stroke(),t.closePath(),t.save(),t.translate(n,o?this.endPoint+12:this.endPoint+8),t.rotate(-1*C(this.xLabelRotation)),t.font=this.font,t.textAlign=o?"right":"center",t.textBaseline=o?"middle":"top",t.fillText(e,0,0),t.restore()},this))}}),i.RadialScale=i.Element.extend({initialize:function(){this.size=v([this.height,this.width]),this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2},calculateCenterOffset:function(t){var e=this.drawingArea/(this.max-this.min);return(t-this.min)*e},update:function(){this.lineArc?this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2:this.setScaleSize(),this.buildYLabels()},buildYLabels:function(){this.yLabels=[];for(var t=m(this.stepValue),e=0;e<=this.steps;e++)this.yLabels.push(w(this.templateString,{value:(this.min+e*this.stepValue).toFixed(t)}))},getCircumference:function(){return 2*Math.PI/this.valuesCount},setScaleSize:function(){var t,e,i,n,s,o,a,r,l,h,c,u,d=v([this.height/2-this.pointLabelFontSize-5,this.width/2]),f=this.width,g=0;for(this.ctx.font=D(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily),e=0;e<this.valuesCount;e++)t=this.getPointPosition(e,d),i=this.ctx.measureText(w(this.templateString,{value:this.labels[e]})).width+5,0===e||e===this.valuesCount/2?(n=i/2,t.x+n>f&&(f=t.x+n,s=e),t.x-n<g&&(g=t.x-n,a=e)):e<this.valuesCount/2?t.x+i>f&&(f=t.x+i,s=e):e>this.valuesCount/2&&t.x-i<g&&(g=t.x-i,a=e);l=g,h=Math.ceil(f-this.width),o=this.getIndexAngle(s),r=this.getIndexAngle(a),c=h/Math.sin(o+Math.PI/2),u=l/Math.sin(r+Math.PI/2),c=p(c)?c:0,u=p(u)?u:0,this.drawingArea=d-(u+c)/2,this.setCenterPoint(u,c)},setCenterPoint:function(t,e){var i=this.width-e-this.drawingArea,n=t+this.drawingArea;this.xCenter=(n+i)/2,this.yCenter=this.height/2},getIndexAngle:function(t){var e=2*Math.PI/this.valuesCount;return t*e-Math.PI/2},getPointPosition:function(t,e){var i=this.getIndexAngle(t);return{x:Math.cos(i)*e+this.xCenter,y:Math.sin(i)*e+this.yCenter}},draw:function(){if(this.display){var t=this.ctx;if(s(this.yLabels,function(e,i){if(i>0){var n,s=i*(this.drawingArea/this.steps),o=this.yCenter-s;if(this.lineWidth>0)if(t.strokeStyle=this.lineColor,t.lineWidth=this.lineWidth,this.lineArc)t.beginPath(),t.arc(this.xCenter,this.yCenter,s,0,2*Math.PI),t.closePath(),t.stroke();else{t.beginPath();for(var a=0;a<this.valuesCount;a++)n=this.getPointPosition(a,this.calculateCenterOffset(this.min+i*this.stepValue)),0===a?t.moveTo(n.x,n.y):t.lineTo(n.x,n.y);t.closePath(),t.stroke()}if(this.showLabels){if(t.font=D(this.fontSize,this.fontStyle,this.fontFamily),this.showLabelBackdrop){var r=t.measureText(e).width;t.fillStyle=this.backdropColor,t.fillRect(this.xCenter-r/2-this.backdropPaddingX,o-this.fontSize/2-this.backdropPaddingY,r+2*this.backdropPaddingX,this.fontSize+2*this.backdropPaddingY)}t.textAlign="center",t.textBaseline="middle",t.fillStyle=this.fontColor,t.fillText(e,this.xCenter,o)}}},this),!this.lineArc){t.lineWidth=this.angleLineWidth,t.strokeStyle=this.angleLineColor;for(var e=this.valuesCount-1;e>=0;e--){if(this.angleLineWidth>0){var i=this.getPointPosition(e,this.calculateCenterOffset(this.max));t.beginPath(),t.moveTo(this.xCenter,this.yCenter),t.lineTo(i.x,i.y),t.stroke(),t.closePath()}var n=this.getPointPosition(e,this.calculateCenterOffset(this.max)+5);t.font=D(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily),t.fillStyle=this.pointLabelFontColor;var o=this.labels.length,a=this.labels.length/2,r=a/2,l=r>e||e>o-r,h=e===r||e===o-r;0===e?t.textAlign="center":e===a?t.textAlign="center":a>e?t.textAlign="left":t.textAlign="right",h?t.textBaseline="middle":l?t.textBaseline="bottom":t.textBaseline="top",t.fillText(this.labels[e],n.x,n.y)}}}}}),n.addEvent(window,"resize",function(){var t;return function(){clearTimeout(t),t=setTimeout(function(){s(i.instances,function(t){t.options.responsive&&t.resize(t.render,!0)})},50)}}()),f?define(function(){return i}):"object"==typeof module&&module.exports&&(module.exports=i),t.Chart=i,i.noConflict=function(){return t.Chart=e,i}}).call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,n={scaleBeginAtZero:!0,scaleShowGridLines:!0,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:!0,scaleShowVerticalLines:!0,barShowStroke:!0,barStrokeWidth:2,barValueSpacing:5,barDatasetSpacing:1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].fillColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>'};e.Type.extend({name:"Bar",defaults:n,initialize:function(t){var n=this.options;this.ScaleClass=e.Scale.extend({offsetGridLines:!0,calculateBarX:function(t,e,i){var s=this.calculateBaseWidth(),o=this.calculateX(i)-s/2,a=this.calculateBarWidth(t);return o+a*e+e*n.barDatasetSpacing+a/2},calculateBaseWidth:function(){return this.calculateX(1)-this.calculateX(0)-2*n.barValueSpacing},calculateBarWidth:function(t){var e=this.calculateBaseWidth()-(t-1)*n.barDatasetSpacing;return e/t}}),this.datasets=[],this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getBarsAtEvent(t):[];this.eachBars(function(t){t.restore(["fillColor","strokeColor"])}),i.each(e,function(t){t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke}),this.showTooltip(e)}),this.BarClass=e.Rectangle.extend({strokeWidth:this.options.barStrokeWidth,showStroke:this.options.barShowStroke,ctx:this.chart.ctx}),i.each(t.datasets,function(e,n){var s={label:e.label||null,fillColor:e.fillColor,strokeColor:e.strokeColor,bars:[]};this.datasets.push(s),i.each(e.data,function(i,n){s.bars.push(new this.BarClass({value:i,label:t.labels[n],datasetLabel:e.label,strokeColor:e.strokeColor,fillColor:e.fillColor,highlightFill:e.highlightFill||e.fillColor,highlightStroke:e.highlightStroke||e.strokeColor}))},this)},this),this.buildScale(t.labels),this.BarClass.prototype.base=this.scale.endPoint,this.eachBars(function(t,e,n){i.extend(t,{width:this.scale.calculateBarWidth(this.datasets.length),x:this.scale.calculateBarX(this.datasets.length,n,e),y:this.scale.endPoint}),t.save()},this),this.render()},update:function(){this.scale.update(),i.each(this.activeElements,function(t){t.restore(["fillColor","strokeColor"])}),this.eachBars(function(t){t.save()}),this.render()},eachBars:function(t){i.each(this.datasets,function(e,n){i.each(e.bars,t,this,n)},this)},getBarsAtEvent:function(t){for(var e,n=[],s=i.getRelativePosition(t),o=function(t){n.push(t.bars[e])},a=0;a<this.datasets.length;a++)for(e=0;e<this.datasets[a].bars.length;e++)if(this.datasets[a].bars[e].inRange(s.x,s.y))return i.each(this.datasets,o),n;return n},buildScale:function(t){var e=this,n=function(){var t=[];return e.eachBars(function(e){t.push(e.value)}),t},s={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:t.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(t){var e=i.calculateScaleRange(n(),t,this.fontSize,this.beginAtZero,this.integersOnly);i.extend(this,e)},xLabels:t,font:i.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:this.options.scaleShowGridLines?this.options.scaleGridLineWidth:0,gridLineColor:this.options.scaleShowGridLines?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:this.options.showScale?0:this.options.barShowStroke?this.options.barStrokeWidth:0,showLabels:this.options.scaleShowLabels,display:this.options.showScale};this.options.scaleOverride&&i.extend(s,{calculateYRange:i.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}),this.scale=new this.ScaleClass(s)},addData:function(t,e){i.each(t,function(t,i){this.datasets[i].bars.push(new this.BarClass({value:t,label:e,x:this.scale.calculateBarX(this.datasets.length,i,this.scale.valuesCount+1),y:this.scale.endPoint,width:this.scale.calculateBarWidth(this.datasets.length),
base:this.scale.endPoint,strokeColor:this.datasets[i].strokeColor,fillColor:this.datasets[i].fillColor}))},this),this.scale.addXLabel(e),this.update()},removeData:function(){this.scale.removeXLabel(),i.each(this.datasets,function(t){t.bars.shift()},this),this.update()},reflow:function(){i.extend(this.BarClass.prototype,{y:this.scale.endPoint,base:this.scale.endPoint});var t=i.extend({height:this.chart.height,width:this.chart.width});this.scale.update(t)},draw:function(t){var e=t||1;this.clear();this.chart.ctx;this.scale.draw(e),i.each(this.datasets,function(t,n){i.each(t.bars,function(t,i){t.hasValue()&&(t.base=this.scale.endPoint,t.transition({x:this.scale.calculateBarX(this.datasets.length,n,i),y:this.scale.calculateY(t.value),width:this.scale.calculateBarWidth(this.datasets.length)},e).draw())},this)},this)}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,n={segmentShowStroke:!0,segmentStrokeColor:"#fff",segmentStrokeWidth:2,percentageInnerCutout:50,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:!0,animateScale:!1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>'};e.Type.extend({name:"Doughnut",defaults:n,initialize:function(t){this.segments=[],this.outerRadius=(i.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2,this.SegmentArc=e.Arc.extend({ctx:this.chart.ctx,x:this.chart.width/2,y:this.chart.height/2}),this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getSegmentsAtEvent(t):[];i.each(this.segments,function(t){t.restore(["fillColor"])}),i.each(e,function(t){t.fillColor=t.highlightColor}),this.showTooltip(e)}),this.calculateTotal(t),i.each(t,function(t,e){this.addData(t,e,!0)},this),this.render()},getSegmentsAtEvent:function(t){var e=[],n=i.getRelativePosition(t);return i.each(this.segments,function(t){t.inRange(n.x,n.y)&&e.push(t)},this),e},addData:function(t,e,i){var n=e||this.segments.length;this.segments.splice(n,0,new this.SegmentArc({value:t.value,outerRadius:this.options.animateScale?0:this.outerRadius,innerRadius:this.options.animateScale?0:this.outerRadius/100*this.options.percentageInnerCutout,fillColor:t.color,highlightColor:t.highlight||t.color,showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,startAngle:1.5*Math.PI,circumference:this.options.animateRotate?0:this.calculateCircumference(t.value),label:t.label})),i||(this.reflow(),this.update())},calculateCircumference:function(t){return 2*Math.PI*(Math.abs(t)/this.total)},calculateTotal:function(t){this.total=0,i.each(t,function(t){this.total+=Math.abs(t.value)},this)},update:function(){this.calculateTotal(this.segments),i.each(this.activeElements,function(t){t.restore(["fillColor"])}),i.each(this.segments,function(t){t.save()}),this.render()},removeData:function(t){var e=i.isNumber(t)?t:this.segments.length-1;this.segments.splice(e,1),this.reflow(),this.update()},reflow:function(){i.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2}),this.outerRadius=(i.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2,i.each(this.segments,function(t){t.update({outerRadius:this.outerRadius,innerRadius:this.outerRadius/100*this.options.percentageInnerCutout})},this)},draw:function(t){var e=t?t:1;this.clear(),i.each(this.segments,function(t,i){t.transition({circumference:this.calculateCircumference(t.value),outerRadius:this.outerRadius,innerRadius:this.outerRadius/100*this.options.percentageInnerCutout},e),t.endAngle=t.startAngle+t.circumference,t.draw(),0===i&&(t.startAngle=1.5*Math.PI),i<this.segments.length-1&&(this.segments[i+1].startAngle=t.endAngle)},this)}}),e.types.Doughnut.extend({name:"Pie",defaults:i.merge(n,{percentageInnerCutout:0})})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,n={scaleShowGridLines:!0,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:!0,scaleShowVerticalLines:!0,bezierCurve:!0,bezierCurveTension:.4,pointDot:!0,pointDotRadius:4,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:!0,datasetStrokeWidth:2,datasetFill:!0,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].strokeColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>'};e.Type.extend({name:"Line",defaults:n,initialize:function(t){this.PointClass=e.Point.extend({strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx,inRange:function(t){return Math.pow(t-this.x,2)<Math.pow(this.radius+this.hitDetectionRadius,2)}}),this.datasets=[],this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getPointsAtEvent(t):[];this.eachPoints(function(t){t.restore(["fillColor","strokeColor"])}),i.each(e,function(t){t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke}),this.showTooltip(e)}),i.each(t.datasets,function(e){var n={label:e.label||null,fillColor:e.fillColor,strokeColor:e.strokeColor,pointColor:e.pointColor,pointStrokeColor:e.pointStrokeColor,points:[]};this.datasets.push(n),i.each(e.data,function(i,s){n.points.push(new this.PointClass({value:i,label:t.labels[s],datasetLabel:e.label,strokeColor:e.pointStrokeColor,fillColor:e.pointColor,highlightFill:e.pointHighlightFill||e.pointColor,highlightStroke:e.pointHighlightStroke||e.pointStrokeColor}))},this),this.buildScale(t.labels),this.eachPoints(function(t,e){i.extend(t,{x:this.scale.calculateX(e),y:this.scale.endPoint}),t.save()},this)},this),this.render()},update:function(){this.scale.update(),i.each(this.activeElements,function(t){t.restore(["fillColor","strokeColor"])}),this.eachPoints(function(t){t.save()}),this.render()},eachPoints:function(t){i.each(this.datasets,function(e){i.each(e.points,t,this)},this)},getPointsAtEvent:function(t){var e=[],n=i.getRelativePosition(t);return i.each(this.datasets,function(t){i.each(t.points,function(t){t.inRange(n.x,n.y)&&e.push(t)})},this),e},buildScale:function(t){var n=this,s=function(){var t=[];return n.eachPoints(function(e){t.push(e.value)}),t},o={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:t.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(t){var e=i.calculateScaleRange(s(),t,this.fontSize,this.beginAtZero,this.integersOnly);i.extend(this,e)},xLabels:t,font:i.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:this.options.scaleShowGridLines?this.options.scaleGridLineWidth:0,gridLineColor:this.options.scaleShowGridLines?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:this.options.showScale?0:this.options.pointDotRadius+this.options.pointDotStrokeWidth,showLabels:this.options.scaleShowLabels,display:this.options.showScale};this.options.scaleOverride&&i.extend(o,{calculateYRange:i.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}),this.scale=new e.Scale(o)},addData:function(t,e){i.each(t,function(t,i){this.datasets[i].points.push(new this.PointClass({value:t,label:e,x:this.scale.calculateX(this.scale.valuesCount+1),y:this.scale.endPoint,strokeColor:this.datasets[i].pointStrokeColor,fillColor:this.datasets[i].pointColor}))},this),this.scale.addXLabel(e),this.update()},removeData:function(){this.scale.removeXLabel(),i.each(this.datasets,function(t){t.points.shift()},this),this.update()},reflow:function(){var t=i.extend({height:this.chart.height,width:this.chart.width});this.scale.update(t)},draw:function(t){var e=t||1;this.clear();var n=this.chart.ctx,s=function(t){return null!==t.value},o=function(t,e,n){return i.findNextWhere(e,s,n)||t},a=function(t,e,n){return i.findPreviousWhere(e,s,n)||t};this.scale.draw(e),i.each(this.datasets,function(t){var r=i.where(t.points,s);i.each(t.points,function(t,i){t.hasValue()&&t.transition({y:this.scale.calculateY(t.value),x:this.scale.calculateX(i)},e)},this),this.options.bezierCurve&&i.each(r,function(t,e){var n=e>0&&e<r.length-1?this.options.bezierCurveTension:0;t.controlPoints=i.splineCurve(a(t,r,e),t,o(t,r,e),n),t.controlPoints.outer.y>this.scale.endPoint?t.controlPoints.outer.y=this.scale.endPoint:t.controlPoints.outer.y<this.scale.startPoint&&(t.controlPoints.outer.y=this.scale.startPoint),t.controlPoints.inner.y>this.scale.endPoint?t.controlPoints.inner.y=this.scale.endPoint:t.controlPoints.inner.y<this.scale.startPoint&&(t.controlPoints.inner.y=this.scale.startPoint)},this),n.lineWidth=this.options.datasetStrokeWidth,n.strokeStyle=t.strokeColor,n.beginPath(),i.each(r,function(t,e){if(0===e)n.moveTo(t.x,t.y);else if(this.options.bezierCurve){var i=a(t,r,e);n.bezierCurveTo(i.controlPoints.outer.x,i.controlPoints.outer.y,t.controlPoints.inner.x,t.controlPoints.inner.y,t.x,t.y)}else n.lineTo(t.x,t.y)},this),n.stroke(),this.options.datasetFill&&r.length>0&&(n.lineTo(r[r.length-1].x,this.scale.endPoint),n.lineTo(r[0].x,this.scale.endPoint),n.fillStyle=t.fillColor,n.closePath(),n.fill()),i.each(r,function(t){t.draw()})},this)}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,n={scaleShowLabelBackdrop:!0,scaleBackdropColor:"rgba(255,255,255,0.75)",scaleBeginAtZero:!0,scaleBackdropPaddingY:2,scaleBackdropPaddingX:2,scaleShowLine:!0,segmentShowStroke:!0,segmentStrokeColor:"#fff",segmentStrokeWidth:2,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:!0,animateScale:!1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>'};e.Type.extend({name:"PolarArea",defaults:n,initialize:function(t){this.segments=[],this.SegmentArc=e.Arc.extend({showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,ctx:this.chart.ctx,innerRadius:0,x:this.chart.width/2,y:this.chart.height/2}),this.scale=new e.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:this.options.scaleShowLine?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,lineArc:!0,width:this.chart.width,height:this.chart.height,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,valuesCount:t.length}),this.updateScaleRange(t),this.scale.update(),i.each(t,function(t,e){this.addData(t,e,!0)},this),this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getSegmentsAtEvent(t):[];i.each(this.segments,function(t){t.restore(["fillColor"])}),i.each(e,function(t){t.fillColor=t.highlightColor}),this.showTooltip(e)}),this.render()},getSegmentsAtEvent:function(t){var e=[],n=i.getRelativePosition(t);return i.each(this.segments,function(t){t.inRange(n.x,n.y)&&e.push(t)},this),e},addData:function(t,e,i){var n=e||this.segments.length;this.segments.splice(n,0,new this.SegmentArc({fillColor:t.color,highlightColor:t.highlight||t.color,label:t.label,value:t.value,outerRadius:this.options.animateScale?0:this.scale.calculateCenterOffset(t.value),circumference:this.options.animateRotate?0:this.scale.getCircumference(),startAngle:1.5*Math.PI})),i||(this.reflow(),this.update())},removeData:function(t){var e=i.isNumber(t)?t:this.segments.length-1;this.segments.splice(e,1),this.reflow(),this.update()},calculateTotal:function(t){this.total=0,i.each(t,function(t){this.total+=t.value},this),this.scale.valuesCount=this.segments.length},updateScaleRange:function(t){var e=[];i.each(t,function(t){e.push(t.value)});var n=this.options.scaleOverride?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}:i.calculateScaleRange(e,i.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);i.extend(this.scale,n,{size:i.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2})},update:function(){this.calculateTotal(this.segments),i.each(this.segments,function(t){t.save()}),this.reflow(),this.render()},reflow:function(){i.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2}),this.updateScaleRange(this.segments),this.scale.update(),i.extend(this.scale,{xCenter:this.chart.width/2,yCenter:this.chart.height/2}),i.each(this.segments,function(t){t.update({outerRadius:this.scale.calculateCenterOffset(t.value)})},this)},draw:function(t){var e=t||1;this.clear(),i.each(this.segments,function(t,i){t.transition({circumference:this.scale.getCircumference(),outerRadius:this.scale.calculateCenterOffset(t.value)},e),t.endAngle=t.startAngle+t.circumference,0===i&&(t.startAngle=1.5*Math.PI),i<this.segments.length-1&&(this.segments[i+1].startAngle=t.endAngle),t.draw()},this),this.scale.draw()}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.Type.extend({name:"Radar",defaults:{scaleShowLine:!0,angleShowLineOut:!0,scaleShowLabels:!1,scaleBeginAtZero:!0,angleLineColor:"rgba(0,0,0,.1)",angleLineWidth:1,pointLabelFontFamily:"'Arial'",pointLabelFontStyle:"normal",pointLabelFontSize:10,pointLabelFontColor:"#666",pointDot:!0,pointDotRadius:3,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:!0,datasetStrokeWidth:2,datasetFill:!0,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].strokeColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>'},initialize:function(t){this.PointClass=e.Point.extend({strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx}),this.datasets=[],this.buildScale(t),this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getPointsAtEvent(t):[];this.eachPoints(function(t){t.restore(["fillColor","strokeColor"])}),i.each(e,function(t){t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke}),this.showTooltip(e)}),i.each(t.datasets,function(e){var n={label:e.label||null,fillColor:e.fillColor,strokeColor:e.strokeColor,pointColor:e.pointColor,pointStrokeColor:e.pointStrokeColor,points:[]};this.datasets.push(n),i.each(e.data,function(i,s){var o;this.scale.animation||(o=this.scale.getPointPosition(s,this.scale.calculateCenterOffset(i))),n.points.push(new this.PointClass({value:i,label:t.labels[s],datasetLabel:e.label,x:this.options.animation?this.scale.xCenter:o.x,y:this.options.animation?this.scale.yCenter:o.y,strokeColor:e.pointStrokeColor,fillColor:e.pointColor,highlightFill:e.pointHighlightFill||e.pointColor,highlightStroke:e.pointHighlightStroke||e.pointStrokeColor}))},this)},this),this.render()},eachPoints:function(t){i.each(this.datasets,function(e){i.each(e.points,t,this)},this)},getPointsAtEvent:function(t){var e=i.getRelativePosition(t),n=i.getAngleFromPoint({x:this.scale.xCenter,y:this.scale.yCenter},e),s=2*Math.PI/this.scale.valuesCount,o=Math.round((n.angle-1.5*Math.PI)/s),a=[];return(o>=this.scale.valuesCount||0>o)&&(o=0),n.distance<=this.scale.drawingArea&&i.each(this.datasets,function(t){a.push(t.points[o])}),a},buildScale:function(t){this.scale=new e.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:this.options.scaleShowLine?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,angleLineColor:this.options.angleLineColor,angleLineWidth:this.options.angleShowLineOut?this.options.angleLineWidth:0,pointLabelFontColor:this.options.pointLabelFontColor,pointLabelFontSize:this.options.pointLabelFontSize,pointLabelFontFamily:this.options.pointLabelFontFamily,pointLabelFontStyle:this.options.pointLabelFontStyle,height:this.chart.height,width:this.chart.width,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,labels:t.labels,valuesCount:t.datasets[0].data.length}),this.scale.setScaleSize(),this.updateScaleRange(t.datasets),this.scale.buildYLabels()},updateScaleRange:function(t){var e=function(){var e=[];return i.each(t,function(t){t.data?e=e.concat(t.data):i.each(t.points,function(t){e.push(t.value)})}),e}(),n=this.options.scaleOverride?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}:i.calculateScaleRange(e,i.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);i.extend(this.scale,n)},addData:function(t,e){this.scale.valuesCount++,i.each(t,function(t,i){var n=this.scale.getPointPosition(this.scale.valuesCount,this.scale.calculateCenterOffset(t));this.datasets[i].points.push(new this.PointClass({value:t,label:e,x:n.x,y:n.y,strokeColor:this.datasets[i].pointStrokeColor,fillColor:this.datasets[i].pointColor}))},this),this.scale.labels.push(e),this.reflow(),this.update()},removeData:function(){this.scale.valuesCount--,this.scale.labels.shift(),i.each(this.datasets,function(t){t.points.shift()},this),this.reflow(),this.update()},update:function(){this.eachPoints(function(t){t.save()}),this.reflow(),this.render()},reflow:function(){i.extend(this.scale,{width:this.chart.width,height:this.chart.height,size:i.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2}),this.updateScaleRange(this.datasets),this.scale.setScaleSize(),this.scale.buildYLabels()},draw:function(t){var e=t||1,n=this.chart.ctx;this.clear(),this.scale.draw(),i.each(this.datasets,function(t){i.each(t.points,function(t,i){t.hasValue()&&t.transition(this.scale.getPointPosition(i,this.scale.calculateCenterOffset(t.value)),e)},this),n.lineWidth=this.options.datasetStrokeWidth,n.strokeStyle=t.strokeColor,n.beginPath(),i.each(t.points,function(t,e){0===e?n.moveTo(t.x,t.y):n.lineTo(t.x,t.y)},this),n.closePath(),n.stroke(),n.fillStyle=t.fillColor,n.fill(),i.each(t.points,function(t){t.hasValue()&&t.draw()})},this)}})}.call(this),function(t){"use strict";"object"==typeof exports?module.exports=t(angular,Chart):"function"==typeof define&&define.amd?define(["angular","chart"],t):t(angular,Chart)}(function(t,e){"use strict";function i(){var i={},n={Chart:e,getOptions:function(e){var n=e&&i[e]||{};return t.extend({},i,n)}};this.setOptions=function(e,n){return n?void(i[e]=t.extend(i[e]||{},n)):(n=e,void(i=t.extend(i,n)))},this.$get=function(){return n}}function n(i,n){function o(t,e){return t&&e&&t.length&&e.length?Array.isArray(t[0])?t.length===e.length&&t.every(function(t,i){return t.length===e[i].length}):e.reduce(a,0)>0?t.length===e.length:!1:!1}function a(t,e){return t+e}function r(e,i,n,s){var o=null;return function(a){var r=i.getPointsAtEvent||i.getBarsAtEvent||i.getSegmentsAtEvent;if(r){var l=r.call(i,a);(s===!1||t.equals(o,l)===!1)&&(o=l,e[n](l,a),e.$apply())}}}function l(n,s){for(var o=t.copy(s.colours||i.getOptions(n).colours||e.defaults.global.colours);o.length<s.data.length;)o.push(s.getColour());return o.map(h)}function h(t){return"object"==typeof t&&null!==t?t:"string"==typeof t&&"#"===t[0]?u(p(t.substr(1))):c()}function c(){var t=[d(0,255),d(0,255),d(0,255)];return u(t)}function u(t){return{fillColor:f(t,.2),strokeColor:f(t,1),pointColor:f(t,1),pointStrokeColor:"#fff",pointHighlightFill:"#fff",pointHighlightStroke:f(t,.8)}}function d(t,e){return Math.floor(Math.random()*(e-t+1))+t}function f(t,e){return s?"rgb("+t.join(",")+")":"rgba("+t.concat(e).join(",")+")"}function p(t){var e=parseInt(t,16),i=e>>16&255,n=e>>8&255,s=255&e;return[i,n,s]}function g(e,i,n,s){return{labels:e,datasets:i.map(function(e,i){return t.extend({},s[i],{label:n[i],data:e})})}}function v(e,i,n){return e.map(function(e,s){return t.extend({},n[s],{label:e,value:i[s],color:n[s].strokeColor,highlight:n[s].pointHighlightStroke})})}function m(t,e){var i=t.parent(),n=i.find("chart-legend"),s="<chart-legend>"+e.generateLegend()+"</chart-legend>";n.length?n.replaceWith(s):i.append(s)}function C(t,e,i,n){Array.isArray(i.data[0])?t.datasets.forEach(function(t,i){(t.points||t.bars).forEach(function(t,n){t.value=e[i][n]})}):t.segments.forEach(function(t,i){t.value=e[i]}),t.update(),i.$emit("update",t),i.legend&&"false"!==i.legend&&m(n,t)}function y(t){return!t||Array.isArray(t)&&!t.length||"object"==typeof t&&!Object.keys(t).length}function b(n,s){var o=t.extend({},e.defaults.global,i.getOptions(n),s.options);return o.responsive}return function(e){return{restrict:"CA",scope:{data:"=?",labels:"=?",options:"=?",series:"=?",colours:"=?",getColour:"=?",chartType:"=",legend:"@",click:"=?",hover:"=?",chartData:"=?",chartLabels:"=?",chartOptions:"=?",chartSeries:"=?",chartColours:"=?",chartLegend:"@",chartClick:"=?",chartHover:"=?"},link:function(a,h){function u(t,e){a.$watch(t,function(t){"undefined"!=typeof t&&(a[e]=t)})}function d(i,n){if(!y(i)&&!t.equals(i,n)){var s=e||a.chartType;s&&(w&&w.destroy(),f(s))}}function f(e){if(b(e,a)&&0===h[0].clientHeight&&0===x.clientHeight)return n(function(){f(e)},50,!1);if(a.data&&a.data.length){a.getColour="function"==typeof a.getColour?a.getColour:c,a.colours=l(e,a);var s=h[0],o=s.getContext("2d"),u=Array.isArray(a.data[0])?g(a.labels,a.data,a.series||[],a.colours):v(a.labels,a.data,a.colours),d=t.extend({},i.getOptions(e),a.options);w=new i.Chart(o)[e](u,d),a.$emit("create",w),s.onclick=a.click?r(a,w,"click",!1):t.noop,s.onmousemove=a.hover?r(a,w,"hover",!0):t.noop,a.legend&&"false"!==a.legend&&m(h,w)}}function p(t){if("undefined"!=typeof console&&"test"!==i.getOptions().env){var e="function"==typeof console.warn?console.warn:console.log;a[t]&&e.call(console,'"%s" is deprecated and will be removed in a future version. Please use "chart-%s" instead.',t,t)}}var w,x=document.createElement("div");x.className="chart-container",h.replaceWith(x),x.appendChild(h[0]),s&&window.G_vmlCanvasManager.initElement(h[0]),["data","labels","options","series","colours","legend","click","hover"].forEach(p),u("chartData","data"),u("chartLabels","labels"),u("chartOptions","options"),u("chartSeries","series"),u("chartColours","colours"),u("chartLegend","legend"),u("chartClick","click"),u("chartHover","hover"),a.$watch("data",function(t,i){if(t&&t.length&&(!Array.isArray(t[0])||t[0].length)){var n=e||a.chartType;if(n){if(w){if(o(t,i))return C(w,t,a,h);w.destroy()}f(n)}}},!0),a.$watch("series",d,!0),a.$watch("labels",d,!0),a.$watch("options",d,!0),a.$watch("colours",d,!0),a.$watch("chartType",function(e,i){y(e)||t.equals(e,i)||(w&&w.destroy(),f(e))}),a.$on("$destroy",function(){w&&w.destroy()})}}}}e.defaults.global.responsive=!0,e.defaults.global.multiTooltipTemplate="<%if (datasetLabel){%><%=datasetLabel%>: <%}%><%= value %>",e.defaults.global.colours=["#97BBCD","#DCDCDC","#F7464A","#46BFBD","#FDB45C","#949FB1","#4D5360"];var s="object"==typeof window.G_vmlCanvasManager&&null!==window.G_vmlCanvasManager&&"function"==typeof window.G_vmlCanvasManager.initElement;return s&&(e.defaults.global.animation=!1),t.module("chart.js",[]).provider("ChartJs",i).factory("ChartJsFactory",["ChartJs","$timeout",n]).directive("chartBase",["ChartJsFactory",function(t){return new t}]).directive("chartLine",["ChartJsFactory",function(t){return new t("Line")}]).directive("chartBar",["ChartJsFactory",function(t){return new t("Bar")}]).directive("chartRadar",["ChartJsFactory",function(t){return new t("Radar")}]).directive("chartDoughnut",["ChartJsFactory",function(t){return new t("Doughnut")}]).directive("chartPie",["ChartJsFactory",function(t){return new t("Pie")}]).directive("chartPolarArea",["ChartJsFactory",function(t){return new t("PolarArea")}])}),function(t,e,i){"use strict";function n(t,e,i){if(!t)throw ngMinErr("areq","Argument '{0}' is {1}",e||"?",i||"required");return t}function s(t,e){return t||e?t?e?(q(t)&&(t=t.join(" ")),q(e)&&(e=e.join(" ")),t+" "+e):t:e:""}function o(t){var e={};return t&&(t.to||t.from)&&(e.to=t.to,e.from=t.from),e}function a(t,e,i){var n="";return t=q(t)?t:t&&X(t)&&t.length?t.split(/\s+/):[],j(t,function(t,s){t&&t.length>0&&(n+=s>0?" ":"",n+=i?e+t:t+e)}),n}function r(t,e){var i=t.indexOf(e);e>=0&&t.splice(i,1)}function l(t){if(t instanceof H)switch(t.length){case 0:return[];case 1:if(t[0].nodeType===U)return t;break;default:return H(h(t))}return t.nodeType===U?H(t):void 0}function h(t){if(!t[0])return t;for(var e=0;e<t.length;e++){var i=t[e];if(i.nodeType==U)return i}}function c(t,e,i){j(e,function(e){t.addClass(e,i)})}function u(t,e,i){j(e,function(e){t.removeClass(e,i)})}function d(t){return function(e,i){i.addClass&&(c(t,e,i.addClass),i.addClass=null),i.removeClass&&(u(t,e,i.removeClass),i.removeClass=null)}}function f(t){if(t=t||{},!t.$$prepared){var e=t.domOperation||B;t.domOperation=function(){t.$$domOperationFired=!0,e(),e=B},t.$$prepared=!0}return t}function p(t,e){g(t,e),v(t,e)}function g(t,e){e.from&&(t.css(e.from),e.from=null)}function v(t,e){e.to&&(t.css(e.to),e.to=null)}function m(t,e,i){var n=(e.addClass||"")+" "+(i.addClass||""),s=(e.removeClass||"")+" "+(i.removeClass||""),o=C(t.attr("class"),n,s);i.preparationClasses&&(e.preparationClasses=k(i.preparationClasses,e.preparationClasses),delete i.preparationClasses);var a=e.domOperation!==B?e.domOperation:null;return I(e,i),a&&(e.domOperation=a),o.addClass?e.addClass=o.addClass:e.addClass=null,o.removeClass?e.removeClass=o.removeClass:e.removeClass=null,e}function C(t,e,i){function n(t){X(t)&&(t=t.split(" "));var e={};return j(t,function(t){t.length&&(e[t]=!0)}),e}var s=1,o=-1,a={};t=n(t),e=n(e),j(e,function(t,e){a[e]=s}),i=n(i),j(i,function(t,e){a[e]=a[e]===s?null:o});var r={addClass:"",removeClass:""};return j(a,function(e,i){var n,a;e===s?(n="addClass",a=!t[i]):e===o&&(n="removeClass",a=t[i]),a&&(r[n].length&&(r[n]+=" "),r[n]+=i)}),r}function y(t){return t instanceof e.element?t[0]:t}function b(t,e,i){var n="";e&&(n=a(e,Z,!0)),i.addClass&&(n=k(n,a(i.addClass,J))),i.removeClass&&(n=k(n,a(i.removeClass,Q))),n.length&&(i.preparationClasses=n,t.addClass(n))}function w(t,e){e.preparationClasses&&(t.removeClass(e.preparationClasses),e.preparationClasses=null),e.activeClasses&&(t.removeClass(e.activeClasses),e.activeClasses=null)}function x(t,e){var i=e?"-"+e+"s":"";return P(t,[dt,i]),[dt,i]}function S(t,e){var i=e?"paused":"",n=z+lt;return P(t,[n,i]),[n,i]}function P(t,e){var i=e[0],n=e[1];t.style[i]=n}function k(t,e){return t?e?t+" "+e:t:e}function A(t){return[ut,t+"s"]}function L(t,e){var i=e?ct:dt;return[i,t+"s"]}function $(t,e,i){var n=Object.create(null),s=t.getComputedStyle(e)||{};return j(i,function(t,e){var i=s[t];if(i){var o=i.charAt(0);("-"===o||"+"===o||o>=0)&&(i=F(i)),0===i&&(i=null),n[e]=i}}),n}function F(t){var e=0,i=t.split(/\s*,\s*/);return j(i,function(t){"s"==t.charAt(t.length-1)&&(t=t.substring(0,t.length-1)),t=parseFloat(t)||0,e=e?Math.max(t,e):t}),e}function T(t){return 0===t||null!=t}function R(t,e){var i=W,n=t+"s";return e?i+=nt:n+=" linear all",[i,n]}function D(){var t=Object.create(null);return{flush:function(){t=Object.create(null)},count:function(e){var i=t[e];return i?i.total:0},get:function(e){var i=t[e];return i&&i.value},put:function(e,i){t[e]?t[e].total++:t[e]={total:1,value:i}}}}function M(t,e,i){j(i,function(i){t[i]=_(t[i])?t[i]:e.style.getPropertyValue(i)})}var W,O,z,E,B=e.noop,I=e.extend,H=e.element,j=e.forEach,q=e.isArray,X=e.isString,V=e.isObject,G=e.isUndefined,_=e.isDefined,N=e.isFunction,Y=e.isElement,U=1,J="-add",Q="-remove",Z="ng-",K="-active",tt="ng-animate",et="$$ngAnimateChildren",it="";G(t.ontransitionend)&&_(t.onwebkittransitionend)?(it="-webkit-",W="WebkitTransition",O="webkitTransitionEnd transitionend"):(W="transition",O="transitionend"),G(t.onanimationend)&&_(t.onwebkitanimationend)?(it="-webkit-",z="WebkitAnimation",E="webkitAnimationEnd animationend"):(z="animation",E="animationend");var nt="Duration",st="Property",ot="Delay",at="TimingFunction",rt="IterationCount",lt="PlayState",ht=9999,ct=z+ot,ut=z+nt,dt=W+ot,ft=W+nt,pt=["$$rAF",function(t){function e(t){n=n.concat(t),i()}function i(){if(n.length){for(var e=n.shift(),o=0;o<e.length;o++)e[o]();s||t(function(){s||i()})}}var n,s;return n=e.queue=[],e.waitUntilQuiet=function(e){s&&s(),s=t(function(){s=null,e(),i()})},e}],gt=[function(){return function(t,i,n){var s=n.ngAnimateChildren;e.isString(s)&&0===s.length?i.data(et,!0):n.$observe("ngAnimateChildren",function(t){t="on"===t||"true"===t,i.data(et,t)})}}],vt="$$animateCss",mt=1e3,Ct=3,yt=1.5,bt={transitionDuration:ft,transitionDelay:dt,transitionProperty:W+st,animationDuration:ut,animationDelay:ct,animationIterationCount:z+rt},wt={transitionDuration:ft,transitionDelay:dt,animationDuration:ut,animationDelay:ct},xt=["$animateProvider",function(t){var e=D(),i=D();this.$get=["$window","$$jqLite","$$AnimateRunner","$timeout","$$forceReflow","$sniffer","$$rAFScheduler","$animate",function(t,n,s,l,h,c,u,m){function C(t,e){var i="$$ngAnimateParentKey",n=t.parentNode,s=n[i]||(n[i]=++I);return s+"-"+t.getAttribute("class")+"-"+e}function b(i,n,s,o){var a=e.get(s);return a||(a=$(t,i,o),"infinite"===a.animationIterationCount&&(a.animationIterationCount=1)),e.put(s,a),a}function w(s,o,r,l){var h;if(e.count(r)>0&&(h=i.get(r),!h)){var c=a(o,"-stagger");n.addClass(s,c),h=$(t,s,l),h.animationDuration=Math.max(h.animationDuration,0),h.transitionDuration=Math.max(h.transitionDuration,0),n.removeClass(s,c),i.put(r,h)}return h||{}}function k(t){H.push(t),u.waitUntilQuiet(function(){e.flush(),i.flush();for(var t=h(),n=0;n<H.length;n++)H[n](t);H.length=0})}function F(t,e,i){var n=b(t,e,i,bt),s=n.animationDelay,o=n.transitionDelay;return n.maxDelay=s&&o?Math.max(s,o):s||o,n.maxDuration=Math.max(n.animationDuration*n.animationIterationCount,n.transitionDuration),n}var D=d(n),I=0,H=[];return function(t,i){function h(){d()}function u(){d(!0)}function d(e){V||_&&G||(V=!0,G=!1,i.$$skipPreparationClasses||n.removeClass(t,ft),n.removeClass(t,gt),S(X,!1),x(X,!1),j(nt,function(t){X.style[t[0]]=""}),D(t,i),p(t,i),Object.keys(H).length&&j(H,function(t,e){t?X.style.setProperty(e,t):X.style.removeProperty(e)}),i.onDone&&i.onDone(),N&&N.complete(!e));
}function b(t){Wt.blockTransition&&x(X,t),Wt.blockKeyframeAnimation&&S(X,!!t)}function $(){return N=new s({end:h,cancel:u}),k(B),d(),{$$willAnimate:!1,start:function(){return N},end:h}}function I(){function e(){if(!V){if(b(!1),j(nt,function(t){var e=t[0],i=t[1];X.style[e]=i}),D(t,i),n.addClass(t,gt),Wt.recalculateTimingStyles){if(pt=X.className+" "+ft,St=C(X,pt),Dt=F(X,pt,St),Mt=Dt.maxDelay,U=Math.max(Mt,0),et=Dt.maxDuration,0===et)return void d();Wt.hasTransitions=Dt.transitionDuration>0,Wt.hasAnimations=Dt.animationDuration>0}if(Wt.applyAnimationDelay&&(Mt="boolean"!=typeof i.delay&&T(i.delay)?parseFloat(i.delay):Mt,U=Math.max(Mt,0),Dt.animationDelay=Mt,Ot=L(Mt,!0),nt.push(Ot),X.style[Ot[0]]=Ot[1]),tt=U*mt,it=et*mt,i.easing){var e,r=i.easing;Wt.hasTransitions&&(e=W+at,nt.push([e,r]),X.style[e]=r),Wt.hasAnimations&&(e=z+at,nt.push([e,r]),X.style[e]=r)}Dt.transitionDuration&&h.push(O),Dt.animationDuration&&h.push(E),a=Date.now();var c=tt+yt*it,u=a+c,f=t.data(vt)||[],p=!0;if(f.length){var g=f[0];p=u>g.expectedEndTime,p?l.cancel(g.timer):f.push(d)}if(p){var m=l(s,c,!1);f[0]={timer:m,expectedEndTime:u},f.push(d),t.data(vt,f)}t.on(h.join(" "),o),i.to&&(i.cleanupStyles&&M(H,X,Object.keys(i.to)),v(t,i))}}function s(){var e=t.data(vt);if(e){for(var i=1;i<e.length;i++)e[i]();t.removeData(vt)}}function o(t){t.stopPropagation();var e=t.originalEvent||t,i=e.$manualTimeStamp||e.timeStamp||Date.now(),n=parseFloat(e.elapsedTime.toFixed(Ct));Math.max(i-a,0)>=tt&&n>=et&&(_=!0,d())}if(!V){if(!X.parentNode)return void d();var a,h=[],c=function(t){if(_)G&&t&&(G=!1,d());else if(G=!t,Dt.animationDuration){var e=S(X,G);G?nt.push(e):r(nt,e)}},u=Tt>0&&(Dt.transitionDuration&&0===Pt.transitionDuration||Dt.animationDuration&&0===Pt.animationDuration)&&Math.max(Pt.animationDelay,Pt.transitionDelay);u?l(e,Math.floor(u*Tt*mt),!1):e(),Y.resume=function(){c(!0)},Y.pause=function(){c(!1)}}}var H={},X=y(t);if(!X||!X.parentNode||!m.enabled())return $();i=f(i);var V,G,_,N,Y,U,tt,et,it,nt=[],ot=t.attr("class"),rt=o(i);if(0===i.duration||!c.animations&&!c.transitions)return $();var lt=i.event&&q(i.event)?i.event.join(" "):i.event,ct=lt&&i.structural,ut="",dt="";ct?ut=a(lt,Z,!0):lt&&(ut=lt),i.addClass&&(dt+=a(i.addClass,J)),i.removeClass&&(dt.length&&(dt+=" "),dt+=a(i.removeClass,Q)),i.applyClassesEarly&&dt.length&&D(t,i);var ft=[ut,dt].join(" ").trim(),pt=ot+" "+ft,gt=a(ft,K),bt=rt.to&&Object.keys(rt.to).length>0,xt=(i.keyframeStyle||"").length>0;if(!xt&&!bt&&!ft)return $();var St,Pt;if(i.stagger>0){var kt=parseFloat(i.stagger);Pt={transitionDelay:kt,animationDelay:kt,transitionDuration:0,animationDuration:0}}else St=C(X,pt),Pt=w(X,ft,St,wt);i.$$skipPreparationClasses||n.addClass(t,ft);var At;if(i.transitionStyle){var Lt=[W,i.transitionStyle];P(X,Lt),nt.push(Lt)}if(i.duration>=0){At=X.style[W].length>0;var $t=R(i.duration,At);P(X,$t),nt.push($t)}if(i.keyframeStyle){var Ft=[z,i.keyframeStyle];P(X,Ft),nt.push(Ft)}var Tt=Pt?i.staggerIndex>=0?i.staggerIndex:e.count(St):0,Rt=0===Tt;Rt&&!i.skipBlocking&&x(X,ht);var Dt=F(X,pt,St),Mt=Dt.maxDelay;U=Math.max(Mt,0),et=Dt.maxDuration;var Wt={};if(Wt.hasTransitions=Dt.transitionDuration>0,Wt.hasAnimations=Dt.animationDuration>0,Wt.hasTransitionAll=Wt.hasTransitions&&"all"==Dt.transitionProperty,Wt.applyTransitionDuration=bt&&(Wt.hasTransitions&&!Wt.hasTransitionAll||Wt.hasAnimations&&!Wt.hasTransitions),Wt.applyAnimationDuration=i.duration&&Wt.hasAnimations,Wt.applyTransitionDelay=T(i.delay)&&(Wt.applyTransitionDuration||Wt.hasTransitions),Wt.applyAnimationDelay=T(i.delay)&&Wt.hasAnimations,Wt.recalculateTimingStyles=dt.length>0,(Wt.applyTransitionDuration||Wt.applyAnimationDuration)&&(et=i.duration?parseFloat(i.duration):et,Wt.applyTransitionDuration&&(Wt.hasTransitions=!0,Dt.transitionDuration=et,At=X.style[W+st].length>0,nt.push(R(et,At))),Wt.applyAnimationDuration&&(Wt.hasAnimations=!0,Dt.animationDuration=et,nt.push(A(et)))),0===et&&!Wt.recalculateTimingStyles)return $();if(null!=i.delay){var Ot=parseFloat(i.delay);Wt.applyTransitionDelay&&nt.push(L(Ot)),Wt.applyAnimationDelay&&nt.push(L(Ot,!0))}return null==i.duration&&Dt.transitionDuration>0&&(Wt.recalculateTimingStyles=Wt.recalculateTimingStyles||Rt),tt=U*mt,it=et*mt,i.skipBlocking||(Wt.blockTransition=Dt.transitionDuration>0,Wt.blockKeyframeAnimation=Dt.animationDuration>0&&Pt.animationDelay>0&&0===Pt.animationDuration),i.from&&(i.cleanupStyles&&M(H,X,Object.keys(i.from)),g(t,i)),Wt.blockTransition||Wt.blockKeyframeAnimation?b(et):i.skipBlocking||x(X,!1),{$$willAnimate:!0,end:h,start:function(){return V?void 0:(Y={end:h,cancel:u,resume:null,pause:null},N=new s(Y),k(I),N)}}}}]}],St=["$$animationProvider",function(t){function e(t){return t.parentNode&&11===t.parentNode.nodeType}t.drivers.push("$$animateCssDriver");var i="ng-animate-shim",n="ng-anchor",s="ng-anchor-out",o="ng-anchor-in";this.$get=["$animateCss","$rootScope","$$AnimateRunner","$rootElement","$sniffer","$$jqLite","$document",function(t,a,r,l,h,c,u){function f(t){return t.replace(/\bng-\S+\b/g,"")}function p(t,e){return X(t)&&(t=t.split(" ")),X(e)&&(e=e.split(" ")),t.filter(function(t){return-1===e.indexOf(t)}).join(" ")}function g(e,a,l){function h(t){var e={},i=y(t).getBoundingClientRect();return j(["width","height","top","left"],function(t){var n=i[t];switch(t){case"top":n+=C.scrollTop;break;case"left":n+=C.scrollLeft}e[t]=Math.floor(n)+"px"}),e}function c(){var e=t(v,{addClass:s,delay:!0,from:h(a)});return e.$$willAnimate?e:null}function u(t){return t.attr("class")||""}function d(){var e=f(u(l)),i=p(e,m),n=p(m,e),a=t(v,{to:h(l),addClass:o+" "+i,removeClass:s+" "+n,delay:!0});return a.$$willAnimate?a:null}function g(){v.remove(),a.removeClass(i),l.removeClass(i)}var v=H(y(a).cloneNode(!0)),m=f(u(v));a.addClass(i),l.addClass(i),v.addClass(n),w.append(v);var b,x=c();if(!x&&(b=d(),!b))return g();var S=x||b;return{start:function(){function t(){i&&i.end()}var e,i=S.start();return i.done(function(){return i=null,!b&&(b=d())?(i=b.start(),i.done(function(){i=null,g(),e.complete()}),i):(g(),void e.complete())}),e=new r({end:t,cancel:t})}}}function v(t,e,i,n){var s=m(t,B),o=m(e,B),a=[];return j(n,function(t){var e=t.out,n=t["in"],s=g(i,e,n);s&&a.push(s)}),s||o||0!==a.length?{start:function(){function t(){j(e,function(t){t.end()})}var e=[];s&&e.push(s.start()),o&&e.push(o.start()),j(a,function(t){e.push(t.start())});var i=new r({end:t,cancel:t});return r.all(e,function(t){i.complete(t)}),i}}:void 0}function m(e){var i=e.element,n=e.options||{};e.structural&&(n.event=e.event,n.structural=!0,n.applyClassesEarly=!0,"leave"===e.event&&(n.onDone=n.domOperation)),n.preparationClasses&&(n.event=k(n.event,n.preparationClasses));var s=t(i,n);return s.$$willAnimate?s:null}if(!h.animations&&!h.transitions)return B;var C=u[0].body,b=y(l),w=H(e(b)||C.contains(b)?b:C);d(c);return function(t){return t.from&&t.to?v(t.from,t.to,t.classes,t.anchors):m(t)}}]}],Pt=["$animateProvider",function(t){this.$get=["$injector","$$AnimateRunner","$$jqLite",function(e,i,n){function s(i){i=q(i)?i:i.split(" ");for(var n=[],s={},o=0;o<i.length;o++){var a=i[o],r=t.$$registeredAnimations[a];r&&!s[a]&&(n.push(e.get(r)),s[a]=!0)}return n}var o=d(n);return function(t,e,n,a){function r(){a.domOperation(),o(t,a)}function l(t,e,n,s,o){var a;switch(n){case"animate":a=[e,s.from,s.to,o];break;case"setClass":a=[e,g,v,o];break;case"addClass":a=[e,g,o];break;case"removeClass":a=[e,v,o];break;default:a=[e,o]}a.push(s);var r=t.apply(t,a);if(r)if(N(r.start)&&(r=r.start()),r instanceof i)r.done(o);else if(N(r))return r;return B}function h(t,e,n,s,o){var a=[];return j(s,function(s){var r=s[o];r&&a.push(function(){var s,o,a=!1,h=function(t){a||(a=!0,(o||B)(t),s.complete(!t))};return s=new i({end:function(){h()},cancel:function(){h(!0)}}),o=l(r,t,e,n,function(t){var e=t===!1;h(e)}),s})}),a}function c(t,e,n,s,o){var a=h(t,e,n,s,o);if(0===a.length){var r,l;"beforeSetClass"===o?(r=h(t,"removeClass",n,s,"beforeRemoveClass"),l=h(t,"addClass",n,s,"beforeAddClass")):"setClass"===o&&(r=h(t,"removeClass",n,s,"removeClass"),l=h(t,"addClass",n,s,"addClass")),r&&(a=a.concat(r)),l&&(a=a.concat(l))}if(0!==a.length)return function(t){var e=[];return a.length&&j(a,function(t){e.push(t())}),e.length?i.all(e,t):t(),function(t){j(e,function(e){t?e.cancel():e.end()})}}}3===arguments.length&&V(n)&&(a=n,n=null),a=f(a),n||(n=t.attr("class")||"",a.addClass&&(n+=" "+a.addClass),a.removeClass&&(n+=" "+a.removeClass));var u,d,g=a.addClass,v=a.removeClass,m=s(n);if(m.length){var C,y;"leave"==e?(y="leave",C="afterLeave"):(y="before"+e.charAt(0).toUpperCase()+e.substr(1),C=e),"enter"!==e&&"move"!==e&&(u=c(t,e,a,m,y)),d=c(t,e,a,m,C)}return u||d?{start:function(){function e(e){l=!0,r(),p(t,a),h.complete(e)}function n(t){l||((s||B)(t),e(t))}var s,o=[];u&&o.push(function(t){s=u(t)}),o.length?o.push(function(t){r(),t(!0)}):r(),d&&o.push(function(t){s=d(t)});var l=!1,h=new i({end:function(){n()},cancel:function(){n(!0)}});return i.chain(o,e),h}}:void 0}}]}],kt=["$$animationProvider",function(t){t.drivers.push("$$animateJsDriver"),this.$get=["$$animateJs","$$AnimateRunner",function(t,e){function i(e){var i=e.element,n=e.event,s=e.options,o=e.classes;return t(i,n,o,s)}return function(t){if(t.from&&t.to){var n=i(t.from),s=i(t.to);if(!n&&!s)return;return{start:function(){function t(){return function(){j(o,function(t){t.end()})}}function i(t){a.complete(t)}var o=[];n&&o.push(n.start()),s&&o.push(s.start()),e.all(o,i);var a=new e({end:t(),cancel:t()});return a}}}return i(t)}}]}],At="data-ng-animate",Lt="$ngAnimatePin",$t=["$animateProvider",function(t){function e(t,e,i,n){return a[t].some(function(t){return t(e,i,n)})}function i(t,e){t=t||{};var i=(t.addClass||"").length>0,n=(t.removeClass||"").length>0;return e?i&&n:i||n}var s=1,o=2,a=this.rules={skip:[],cancel:[],join:[]};a.join.push(function(t,e,n){return!e.structural&&i(e.options)}),a.skip.push(function(t,e,n){return!e.structural&&!i(e.options)}),a.skip.push(function(t,e,i){return"leave"==i.event&&e.structural}),a.skip.push(function(t,e,i){return i.structural&&i.state===o&&!e.structural}),a.cancel.push(function(t,e,i){return i.structural&&e.structural}),a.cancel.push(function(t,e,i){return i.state===o&&e.structural}),a.cancel.push(function(t,e,i){var n=e.options,s=i.options;return n.addClass&&n.addClass===s.removeClass||n.removeClass&&n.removeClass===s.addClass}),this.$get=["$$rAF","$rootScope","$rootElement","$document","$$HashMap","$$animation","$$AnimateRunner","$templateRequest","$$jqLite","$$forceReflow",function(a,r,c,u,g,v,C,x,S,P){function k(){var t=!1;return function(e){t?e():r.$$postDigest(function(){t=!0,e()})}}function A(t,e){return m(t,e,{})}function L(t,e){var i=y(t),n=[],s=B[e];return s&&j(s,function(t){t.node.contains(i)&&n.push(t.callback)}),n}function $(t,n,h){function c(e,i,n,s){S(function(){var e=L(t,i);e.length&&a(function(){j(e,function(e){e(t,n,s)})})}),e.progress(i,n,s)}function u(e){w(t,h),Q(t,h),p(t,h),h.domOperation(),x.complete(!e)}var d,g;t=l(t),t&&(d=y(t),g=t.parent()),h=f(h);var x=new C,S=k();if(q(h.addClass)&&(h.addClass=h.addClass.join(" ")),h.addClass&&!X(h.addClass)&&(h.addClass=null),q(h.removeClass)&&(h.removeClass=h.removeClass.join(" ")),h.removeClass&&!X(h.removeClass)&&(h.removeClass=null),h.from&&!V(h.from)&&(h.from=null),h.to&&!V(h.to)&&(h.to=null),!d)return u(),x;var P=[d.className,h.addClass,h.removeClass].join(" ");if(!J(P))return u(),x;var $=["enter","move","leave"].indexOf(n)>=0,R=!z||O.get(d),E=!R&&W.get(d)||{},B=!!E.state;if(R||B&&E.state==s||(R=!D(t,g,n)),R)return u(),x;$&&F(t);var I={structural:$,element:t,event:n,close:u,options:h,runner:x};if(B){var H=e("skip",t,I,E);if(H)return E.state===o?(u(),x):(m(t,E.options,h),E.runner);var G=e("cancel",t,I,E);if(G)if(E.state===o)E.runner.end();else{if(!E.structural)return m(t,E.options,I.options),E.runner;E.close()}else{var _=e("join",t,I,E);if(_){if(E.state!==o)return b(t,$?n:null,h),n=I.event=E.event,h=m(t,E.options,I.options),E.runner;A(t,h)}}}else A(t,h);var N=I.structural;if(N||(N="animate"===I.event&&Object.keys(I.options.to||{}).length>0||i(I.options)),!N)return u(),T(t),x;var Y=(E.counter||0)+1;return I.counter=Y,M(t,s,I),r.$$postDigest(function(){var e=W.get(d),s=!e;e=e||{};var a=t.parent()||[],r=a.length>0&&("animate"===e.event||e.structural||i(e.options));if(s||e.counter!==Y||!r)return s&&(Q(t,h),p(t,h)),(s||$&&e.event!==n)&&(h.domOperation(),x.end()),void(r||T(t));n=!e.structural&&i(e.options,!0)?"setClass":e.event,M(t,o);var l=v(t,n,e.options);l.done(function(e){u(!e);var i=W.get(d);i&&i.counter===Y&&T(y(t)),c(x,n,"close",{})}),x.setHost(l),c(x,n,"start",{})}),x}function F(t){var e=y(t),i=e.querySelectorAll("["+At+"]");j(i,function(t){var e=parseInt(t.getAttribute(At)),i=W.get(t);switch(e){case o:i.runner.end();case s:i&&W.remove(t)}})}function T(t){var e=y(t);e.removeAttribute(At),W.remove(e)}function R(t,e){return y(t)===y(e)}function D(t,e,i){var n,s=H(u[0].body),o=R(t,s)||"HTML"===t[0].nodeName,a=R(t,c),r=!1,l=t.data(Lt);for(l&&(e=l);e&&e.length;){a||(a=R(e,c));var h=e[0];if(h.nodeType!==U)break;var d=W.get(h)||{};if(r||(r=d.structural||O.get(h)),G(n)||n===!0){var f=e.data(et);_(f)&&(n=f)}if(r&&n===!1)break;a||(a=R(e,c),a||(l=e.data(Lt),l&&(e=l))),o||(o=R(e,s)),e=e.parent()}var p=!r||n;return p&&a&&o}function M(t,e,i){i=i||{},i.state=e;var n=y(t);n.setAttribute(At,e);var s=W.get(n),o=s?I(s,i):i;W.put(n,o)}var W=new g,O=new g,z=null,E=r.$watch(function(){return 0===x.totalPendingRequests},function(t){t&&(E(),r.$$postDigest(function(){r.$$postDigest(function(){null===z&&(z=!0)})}))}),B={},N=t.classNameFilter(),J=N?function(t){return N.test(t)}:function(){return!0},Q=d(S);return{on:function(t,e,i){var n=h(e);B[t]=B[t]||[],B[t].push({node:n,callback:i})},off:function(t,e,i){function n(t,e,i){var n=h(e);return t.filter(function(t){var e=t.node===n&&(!i||t.callback===i);return!e})}var s=B[t];s&&(B[t]=1===arguments.length?null:n(s,e,i))},pin:function(t,e){n(Y(t),"element","not an element"),n(Y(e),"parentElement","not an element"),t.data(Lt,e)},push:function(t,e,i,n){return i=i||{},i.domOperation=n,$(t,e,i)},enabled:function(t,e){var i=arguments.length;if(0===i)e=!!z;else{var n=Y(t);if(n){var s=y(t),o=O.get(s);1===i?e=!o:(e=!!e,e?o&&O.remove(s):O.put(s,!0))}else e=z=!!t}return e}}}]}],Ft=["$$rAF",function(t){function e(e){i.push(e),i.length>1||t(function(){for(var t=0;t<i.length;t++)i[t]();i=[]})}var i=[];return function(){var t=!1;return e(function(){t=!0}),function(i){t?i():e(i)}}}],Tt=["$q","$sniffer","$$animateAsyncRun",function(t,e,i){function n(t){this.setHost(t),this._doneCallbacks=[],this._runInAnimationFrame=i(),this._state=0}var s=0,o=1,a=2;return n.chain=function(t,e){function i(){return n===t.length?void e(!0):void t[n](function(t){return t===!1?void e(!1):(n++,void i())})}var n=0;i()},n.all=function(t,e){function i(i){s=s&&i,++n===t.length&&e(s)}var n=0,s=!0;j(t,function(t){t.done(i)})},n.prototype={setHost:function(t){this.host=t||{}},done:function(t){this._state===a?t():this._doneCallbacks.push(t)},progress:B,getPromise:function(){if(!this.promise){var e=this;this.promise=t(function(t,i){e.done(function(e){e===!1?i():t()})})}return this.promise},then:function(t,e){return this.getPromise().then(t,e)},"catch":function(t){return this.getPromise()["catch"](t)},"finally":function(t){return this.getPromise()["finally"](t)},pause:function(){this.host.pause&&this.host.pause()},resume:function(){this.host.resume&&this.host.resume()},end:function(){this.host.end&&this.host.end(),this._resolve(!0)},cancel:function(){this.host.cancel&&this.host.cancel(),this._resolve(!1)},complete:function(t){var e=this;e._state===s&&(e._state=o,e._runInAnimationFrame(function(){e._resolve(t)}))},_resolve:function(t){this._state!==a&&(j(this._doneCallbacks,function(e){e(t)}),this._doneCallbacks.length=0,this._state=a)}},n}],Rt=["$animateProvider",function(t){function e(t,e){t.data(r,e)}function i(t){t.removeData(r)}function n(t){return t.data(r)}var o="ng-animate-ref",a=this.drivers=[],r="$$animationRunner";this.$get=["$$jqLite","$rootScope","$injector","$$AnimateRunner","$$HashMap","$$rAFScheduler",function(t,r,l,h,c,u){function g(t){function e(t){if(t.processed)return t;t.processed=!0;var i=t.domNode,n=i.parentNode;o.put(i,t);for(var a;n;){if(a=o.get(n)){a.processed||(a=e(a));break}n=n.parentNode}return(a||s).children.push(t),t}function i(t){var e,i=[],n=[];for(e=0;e<t.children.length;e++)n.push(t.children[e]);var s=n.length,o=0,a=[];for(e=0;e<n.length;e++){var r=n[e];0>=s&&(s=o,o=0,i.push(a),a=[]),a.push(r.fn),r.children.forEach(function(t){o++,n.push(t)}),s--}return a.length&&i.push(a),i}var n,s={children:[]},o=new c;for(n=0;n<t.length;n++){var a=t[n];o.put(a.domNode,t[n]={domNode:a.domNode,fn:a.fn,children:[]})}for(n=0;n<t.length;n++)e(t[n]);return i(s)}var v=[],m=d(t);return function(c,d,C){function b(t){var e="["+o+"]",i=t.hasAttribute(o)?[t]:t.querySelectorAll(e),n=[];return j(i,function(t){var e=t.getAttribute(o);e&&e.length&&n.push(t)}),n}function w(t){var e=[],i={};j(t,function(t,n){var s=t.element,a=y(s),r=t.event,l=["enter","move"].indexOf(r)>=0,h=t.structural?b(a):[];if(h.length){var c=l?"to":"from";j(h,function(t){var e=t.getAttribute(o);i[e]=i[e]||{},i[e][c]={animationID:n,element:H(t)}})}else e.push(t)});var n={},s={};return j(i,function(i,o){var a=i.from,r=i.to;if(!a||!r){var l=a?a.animationID:r.animationID,h=l.toString();return void(n[h]||(n[h]=!0,e.push(t[l])))}var c=t[a.animationID],u=t[r.animationID],d=a.animationID.toString();if(!s[d]){var f=s[d]={structural:!0,beforeStart:function(){c.beforeStart(),u.beforeStart()},close:function(){c.close(),u.close()},classes:x(c.classes,u.classes),from:c,to:u,anchors:[]};f.classes.length?e.push(f):(e.push(c),e.push(u))}s[d].anchors.push({out:a.element,"in":r.element})}),e}function x(t,e){t=t.split(" "),e=e.split(" ");for(var i=[],n=0;n<t.length;n++){var s=t[n];if("ng-"!==s.substring(0,3))for(var o=0;o<e.length;o++)if(s===e[o]){i.push(s);break}}return i.join(" ")}function S(t){for(var e=a.length-1;e>=0;e--){var i=a[e];if(l.has(i)){var n=l.get(i),s=n(t);if(s)return s}}}function P(){c.addClass(tt),R&&t.addClass(c,R)}function k(t,e){function i(t){n(t).setHost(e)}t.from&&t.to?(i(t.from.element),i(t.to.element)):i(t.element)}function A(){var t=n(c);!t||"leave"===d&&C.$$domOperationFired||t.end()}function L(e){c.off("$destroy",A),i(c),m(c,C),p(c,C),C.domOperation(),R&&t.removeClass(c,R),c.removeClass(tt),F.complete(!e)}C=f(C);var $=["enter","move","leave"].indexOf(d)>=0,F=new h({end:function(){L()},cancel:function(){L(!0)}});if(!a.length)return L(),F;e(c,F);var T=s(c.attr("class"),s(C.addClass,C.removeClass)),R=C.tempClasses;return R&&(T+=" "+R,C.tempClasses=null),v.push({element:c,classes:T,event:d,structural:$,options:C,beforeStart:P,close:L}),c.on("$destroy",A),v.length>1?F:(r.$$postDigest(function(){var t=[];j(v,function(e){n(e.element)?t.push(e):e.close()}),v.length=0;var e=w(t),i=[];j(e,function(t){i.push({domNode:y(t.from?t.from.element:t.element),fn:function(){t.beforeStart();var e,i=t.close,s=t.anchors?t.from.element||t.to.element:t.element;if(n(s)){var o=S(t);o&&(e=o.start)}if(e){var a=e();a.done(function(t){i(!t)}),k(t,a)}else i()}})}),u(g(i))}),F)}}]}];e.module("ngAnimate",[]).directive("ngAnimateChildren",gt).factory("$$rAFScheduler",pt).factory("$$AnimateRunner",Tt).factory("$$animateAsyncRun",Ft).provider("$$animateQueue",$t).provider("$$animation",Rt).provider("$animateCss",xt).provider("$$animateCssDriver",St).provider("$$animateJs",Pt).provider("$$animateJsDriver",kt)}(window,window.angular),angular.module("ui.bootstrap.accordion",["ui.bootstrap.collapse"]).constant("uibAccordionConfig",{closeOthers:!0}).controller("UibAccordionController",["$scope","$attrs","uibAccordionConfig",function(t,e,i){this.groups=[],this.closeOthers=function(n){var s=angular.isDefined(e.closeOthers)?t.$eval(e.closeOthers):i.closeOthers;s&&angular.forEach(this.groups,function(t){t!==n&&(t.isOpen=!1)})},this.addGroup=function(t){var e=this;this.groups.push(t),t.$on("$destroy",function(i){e.removeGroup(t)})},this.removeGroup=function(t){var e=this.groups.indexOf(t);-1!==e&&this.groups.splice(e,1)}}]).directive("uibAccordion",function(){return{controller:"UibAccordionController",controllerAs:"accordion",transclude:!0,templateUrl:function(t,e){return e.templateUrl||"template/accordion/accordion.html"}}}).directive("uibAccordionGroup",function(){return{require:"^uibAccordion",transclude:!0,replace:!0,templateUrl:function(t,e){return e.templateUrl||"template/accordion/accordion-group.html"},scope:{heading:"@",isOpen:"=?",isDisabled:"=?"},controller:function(){this.setHeading=function(t){this.heading=t}},link:function(t,e,i,n){n.addGroup(t),t.openClass=i.openClass||"panel-open",t.panelClass=i.panelClass,t.$watch("isOpen",function(i){e.toggleClass(t.openClass,!!i),i&&n.closeOthers(t)}),t.toggleOpen=function(e){t.isDisabled||e&&32!==e.which||(t.isOpen=!t.isOpen)}}}}).directive("uibAccordionHeading",function(){return{transclude:!0,template:"",replace:!0,require:"^uibAccordionGroup",link:function(t,e,i,n,s){n.setHeading(s(t,angular.noop))}}}).directive("uibAccordionTransclude",function(){return{require:["?^uibAccordionGroup","?^accordionGroup"],link:function(t,e,i,n){n=n[0]?n[0]:n[1],t.$watch(function(){return n[i.uibAccordionTransclude]},function(t){t&&(e.find("span").html(""),e.find("span").append(t))})}}}),angular.module("ui.bootstrap.accordion").value("$accordionSuppressWarning",!1).controller("AccordionController",["$scope","$attrs","$controller","$log","$accordionSuppressWarning",function(t,e,i,n,s){s||n.warn("AccordionController is now deprecated. Use UibAccordionController instead."),angular.extend(this,i("UibAccordionController",{$scope:t,$attrs:e}))}]).directive("accordion",["$log","$accordionSuppressWarning",function(t,e){return{restrict:"EA",controller:"AccordionController",controllerAs:"accordion",transclude:!0,replace:!1,templateUrl:function(t,e){return e.templateUrl||"template/accordion/accordion.html"},link:function(){e||t.warn("accordion is now deprecated. Use uib-accordion instead.")}}}]).directive("accordionGroup",["$log","$accordionSuppressWarning",function(t,e){return{require:"^accordion",restrict:"EA",transclude:!0,replace:!0,templateUrl:function(t,e){return e.templateUrl||"template/accordion/accordion-group.html"},scope:{heading:"@",isOpen:"=?",isDisabled:"=?"},controller:function(){this.setHeading=function(t){this.heading=t}},link:function(i,n,s,o){e||t.warn("accordion-group is now deprecated. Use uib-accordion-group instead."),o.addGroup(i),i.openClass=s.openClass||"panel-open",i.panelClass=s.panelClass,i.$watch("isOpen",function(t){n.toggleClass(i.openClass,!!t),t&&o.closeOthers(i)}),i.toggleOpen=function(t){i.isDisabled||t&&32!==t.which||(i.isOpen=!i.isOpen)}}}}]).directive("accordionHeading",["$log","$accordionSuppressWarning",function(t,e){return{restrict:"EA",transclude:!0,template:"",replace:!0,require:"^accordionGroup",link:function(i,n,s,o,a){e||t.warn("accordion-heading is now deprecated. Use uib-accordion-heading instead."),o.setHeading(a(i,angular.noop))}}}]).directive("accordionTransclude",["$log","$accordionSuppressWarning",function(t,e){return{require:"^accordionGroup",link:function(i,n,s,o){e||t.warn("accordion-transclude is now deprecated. Use uib-accordion-transclude instead."),i.$watch(function(){return o[s.accordionTransclude]},function(t){t&&(n.find("span").html(""),n.find("span").append(t))})}}}]),angular.module("ui.bootstrap.collapse",[]).directive("uibCollapse",["$animate","$injector",function(t,e){var i=e.has("$animateCss")?e.get("$animateCss"):null;return{link:function(e,n,s){function o(){n.removeClass("collapse").addClass("collapsing").attr("aria-expanded",!0).attr("aria-hidden",!1),i?i(n,{addClass:"in",easing:"ease",to:{height:n[0].scrollHeight+"px"}}).start()["finally"](a):t.addClass(n,"in",{to:{height:n[0].scrollHeight+"px"}}).then(a)}function a(){n.removeClass("collapsing").addClass("collapse").css({height:"auto"})}function r(){return n.hasClass("collapse")||n.hasClass("in")?(n.css({height:n[0].scrollHeight+"px"}).removeClass("collapse").addClass("collapsing").attr("aria-expanded",!1).attr("aria-hidden",!0),void(i?i(n,{removeClass:"in",to:{height:"0"}}).start()["finally"](l):t.removeClass(n,"in",{to:{height:"0"}}).then(l))):l()}function l(){n.css({height:"0"}),n.removeClass("collapsing").addClass("collapse")}e.$watch(s.uibCollapse,function(t){t?r():o()})}}}]),angular.module("ui.bootstrap.collapse").value("$collapseSuppressWarning",!1).directive("collapse",["$animate","$injector","$log","$collapseSuppressWarning",function(t,e,i,n){var s=e.has("$animateCss")?e.get("$animateCss"):null;return{link:function(e,o,a){function r(){o.removeClass("collapse").addClass("collapsing").attr("aria-expanded",!0).attr("aria-hidden",!1),s?s(o,{easing:"ease",to:{height:o[0].scrollHeight+"px"}}).start().done(l):t.animate(o,{},{height:o[0].scrollHeight+"px"}).then(l)}function l(){o.removeClass("collapsing").addClass("collapse in").css({height:"auto"})}function h(){return o.hasClass("collapse")||o.hasClass("in")?(o.css({height:o[0].scrollHeight+"px"}).removeClass("collapse in").addClass("collapsing").attr("aria-expanded",!1).attr("aria-hidden",!0),void(s?s(o,{to:{height:"0"}}).start().done(c):t.animate(o,{},{height:"0"}).then(c))):c()}function c(){o.css({height:"0"}),o.removeClass("collapsing").addClass("collapse")}n||i.warn("collapse is now deprecated. Use uib-collapse instead."),e.$watch(a.collapse,function(t){t?h():r()})}}}]);