FN=$SETUPDIR/images.yaml

rm -f $FN

cat >> $FN <<EOF
tosca_definitions_version: tosca_simple_yaml_1_0

imports:
   - custom_types/xos.yaml

description: autogenerated nodes file

topology_template:
  node_templates:
    mysite:
        type: tosca.nodes.Site

EOF

IMAGES=$( bash -c "source $SETUPDIR/admin-openrc.sh ; glance image-list" |grep -v ID|grep -v +|awk '{print $4}' )
I=0
for IMAGE in $IMAGES; do
    echo $IMAGE
    cat >> $FN <<EOF
    $IMAGE:
      type: tosca.nodes.Image
      properties:
         disk_format: QCOW2
         container_format: BARE

EOF
done

cat >> $FN <<EOF
    MyDeployment:
      type: tosca.nodes.Deployment
      properties:
          flavors: m1.large, m1.medium, m1.small
      requirements:
EOF

for IMAGE in $IMAGES; do
    cat >> $FN <<EOF
          - image:
              node: $IMAGE
              relationship: tosca.relationships.SupportsImage
EOF
done
