# XOS UI Development

This configuration launches the XOS GUI and database in separate containers
using docker-compose.  The Synchronizer is not started and there is no openstack backend connected for XOS.  This configuration is intended for developing the XOS GUI.

## Getting Started

- Navigate to `/xos/configurations/frontend` folder
- Run `make` command

You'll be able to visit XOS at `0.0.0.0:9000` and the `xos/core/xoslib` folder is shared with the container. This means that any update to that folder is automatically reported in the container.

If you need to work on the Django application itself, comment out the "sleep" command
for the `xos` container in docker-compose.yml and run `make`.  Once the containers are
up then type `make enter` to enter the running container.

> _NOTE:
> Please be careful and do not commit migrations, private keys or other autogenerated files._

### Docker Helpers

Stop the containers: `make stop`

Restart the containers: `make stop; make`

Delete the containers and relaunch them: `make rm; make`

Build the containers from scratch using the local XOS source tree: `make containers`

View logs: `make showlogs`

See what containers are running: `make ps`

Open a shell on the XOS container: `make enter-xos`

## Docs

You can find a Swagger documentation for endpoint at: `http://0.0.0.0:9000/docs/`

## Populate the Data Model with custom data

Sometimes while developing the GUI is usefull to have control over the DataModel. Sample `tosca` recipes for different configuration are defined in the `mocks` folder, and corresponding `make` commands are provided.

- Bring up the **CORD** data model: `make mock-cord`
- - Bring up the **M-CORD** data model: `make mock-mcord`

## JS Styleguide

This project is following [Google JavaScript Style Guide](https://google.github.io/styleguide/javascriptguide.xml). To contribute please install [Eslint](http://eslint.org/) in your editor and run `npm run eslint` before commit.

> _NOTE_:
> Many of the already present file were not Style compliant. Linting for them has been disabled as it was to time consuming fix all of them. If **you are going to work** on that files, please **start fixing style issues**, and then **remove the `/* eslint-disable */`** comment
