"use strict";angular.module("xos.ceilometerDashboard",["ngResource","ngCookies","ngLodash","ui.router","xos.helpers","chart.js"]).config(["$stateProvider",function(e){e.state("ceilometerDashboard",{url:"/",template:"<ceilometer-dashboard></ceilometer-dashboard>"}).state("samples",{url:"/:name/:tenant/samples",template:"<ceilometer-samples></ceilometer-samples>"}).state("split",{url:"/split",controller:function(){console.log("split",Split),Split(["#one","#two","#three"],{})},templateUrl:"templates/split.html"})}]).config(["$httpProvider",function(e){e.interceptors.push("NoHyperlinks")}]).service("Ceilometer",["$http","$q",function(e,i){this.getMeters=function(){var t=i.defer();return e.get("xoslib/meters/",{cache:!0}).then(function(e){t.resolve(e.data)})["catch"](function(e){t.reject(e)}),t.promise},this.getSamples=function(t,a){var s=i.defer();return e.get("xoslib/metersamples/",{params:{meter:t,tenant:a}}).then(function(e){s.resolve(e.data)})["catch"](function(e){s.reject(e)}),s.promise}}]).directive("ceilometerDashboard",["lodash",function(e){return{restrict:"E",scope:{},bindToController:!0,controllerAs:"vm",templateUrl:"templates/ceilometer-dashboard.tpl.html",controller:["Ceilometer",function(i){var t=this;this.loadMeters=function(){t.loader=!0,i.getMeters().then(function(i){t.projects=e.groupBy(i,"project_name"),e.forEach(Object.keys(t.projects),function(i){t.projects[i]=e.groupBy(t.projects[i],"resource_id")})})["catch"](function(e){t.err=e})["finally"](function(){t.loader=!1})},this.loadMeters()}]}}]).directive("ceilometerSamples",["lodash","$stateParams",function(e,i){return{restrict:"E",scope:{name:"=name",tenant:"=tenant"},bindToController:!0,controllerAs:"vm",templateUrl:"templates/ceilometer-samples.tpl.html",controller:["Ceilometer",function(t){var a=this;i.name&&i.tenant&&(this.name=i.name,this.tenant=i.tenant),this.formatDateLabels=function(e){return e},this.formatSamplesData=function(i){var t=[];return e.forEach(i,function(e){t.push({x:a.formatDateLabels(e.timestamp),y:[e.volume]})}),e.sortBy(t,"timestamp")},this.getLabels=function(e){return e.reduce(function(e,i){var t=new Date(i.timestamp);return e.push(t.getHours()+":"+((t.getMinutes()<10?"0":"")+t.getMinutes())+":"+t.getSeconds()),e},[])},this.getData=function(e){return e.reduce(function(e,i){return e.push(i.volume),e},[])},this.showSamples=function(){a.loader=!0,t.getSamples(a.name,a.tenant).then(function(i){i=e.sortBy(i,"timestamp"),a.chart={series:[a.name],labels:a.getLabels(i),data:[a.getData(i)]}})["catch"](function(e){console.warn(e)})["finally"](function(){a.loader=!1})},this.showSamples()}]}}]),angular.module("xos.ceilometerDashboard").run(["$templateCache",function(e){e.put("templates/ceilometer-dashboard.tpl.html",'<div class="row">\n  <div class="col-sm-12">\n    <h1>Ceilometer Dashboard</h1>\n  </div>\n</div>\n\n<div class="row" ng-show="vm.loader">\n  <div class="col-xs-12">\n    <div class="loader">Loading</div>\n  </div>\n</div>\n\n<section ng-hide="vm.loader">\n  <div class="row">\n    <div class="col-xs-12">\n      <h2>Projects</h2>\n    </div>\n  </div>\n  <div class="well" ng-repeat="(project, resources) in vm.projects">\n    <div class="row">\n      <div class="col-xs-11">\n        <h3>{{project}}</h3>\n      </div>\n      <div class="col-xs-1">\n        <a ng-click="expandProject = !expandProject" class="btn btn-primary">\n          <i class="glyphicon glyphicon-plus"></i>\n        </a>\n      </div>\n    </div>\n    \n    <div class="row">\n      <div class="panel panel-default" ng-show="expandProject">\n        <div class="panel-heading">\n          <h4>Resources</h4>\n        </div>\n        <div class="panel-body" ng-repeat="(resource, meters) in resources">\n          <div class="row">\n            <div class="col-xs-11">\n              <b>{{resource}}</b>\n            </div>\n            <div class="col-xs-1">\n              <a ng-click="expandResource = !expandResource" class="btn btn-primary">\n                <i class="glyphicon glyphicon-plus"></i>\n              </a>\n            </div>\n          </div>\n          <div class="row" ng-show="expandResource">\n            <div class="col-xs-4">\n              <b>Meter:</b>\n            </div>\n            <div class="col-xs-4">\n              <b>Unit:</b>\n            </div>\n            <div class="col-xs-4">\n              <b>Actions:</b>\n            </div>\n          </div>\n          <div class="row" ng-repeat="meter in meters" ng-show="expandResource">\n            <div class="col-xs-4">\n              {{meter.name}}\n            </div>\n            <div class="col-xs-4">\n              {{meter.unit}}\n            </div>\n            <div class="col-xs-4">\n              <!-- <a ng-click="showMeter = !showMeter" class="btn btn-primary">\n                <i class="glyphicon glyphicon-search"></i> Details\n              </a> -->\n              <a ng-click="showChart = !showChart" class="btn btn-primary">\n                <i class="glyphicon glyphicon-search"></i> View chart\n              </a>\n            </div>\n            <!--   -->\n            <div class="col-xs-12" ng-show="showChart">\n              <ceilometer-samples name="meter.name" tenant="meter.project_id" ng-if="showChart"></ceilometer-samples>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n\n  </div>\n</section>'),e.put("templates/ceilometer-samples.tpl.html",'<div class="row">\n  <div class="col-xs-12" ng-show="vm.loader">\n    <div class="loader">Loading</div>\n  </div>\n\n  <div class="col-xs-12" ng-if="!vm.loader">\n    <!-- <div ac-chart="\'line\'" ac-data="vm.sampleChartData" ac-config="vm.sampleChartConfig" class="chart"></div> -->\n    <canvas id="line" class="chart chart-line" chart-data="vm.chart.data"\n      chart-labels="vm.chart.labels" chart-legend="true" chart-series="vm.chart.series">\n    </canvas> \n    <!-- <pre> {{ vm.chart | json }} </pre> -->\n  </div>\n</div>'),e.put("templates/split.html",'<div id="one" class="split split-horizontal">\n  Lorem ipsum dolor sit amet, consectetur adipisicing elit. Ut, eos debitis repellendus corrupti vel dolores asperiores, ipsam voluptatibus nesciunt ipsum architecto harum magnam similique doloremque rerum illum. Magnam, nesciunt magni.\n  Minus nostrum dolores perspiciatis dolorum eos? Sed, ad fugiat natus amet voluptas officiis, reiciendis tempora error quia repudiandae odit nisi distinctio atque ipsam iste officia ab porro et quo magni.\n  Voluptatem ab rem necessitatibus nam voluptas quo, velit nobis id ea temporibus illum corrupti sequi, aperiam reprehenderit cum! Placeat quas quod minima expedita beatae totam numquam veritatis adipisci doloremque, sit.\n  Suscipit doloremque voluptatum maiores architecto ipsa quis, nihil provident totam, quos qui. Ipsa quibusdam sit, cumque eum provident ratione molestiae quia in ex! Rem voluptates officiis aperiam ullam dignissimos sequi.\n  Ad sed quasi et, dolorem autem perferendis dolor. Cupiditate nemo delectus minus sint mollitia accusantium odio, explicabo nihil illum ut possimus ducimus! Recusandae excepturi, est deleniti accusamus aut quasi. Sit!\n</div>\n<div id="two" class="split split-horizontal">\n  Lorem ipsum dolor sit amet, consectetur adipisicing elit. Suscipit accusamus laboriosam, quo, ipsa quisquam, neque alias animi esse quia, doloremque nulla nihil. Id aliquid necessitatibus atque eum, fugit sed nobis!\n  Blanditiis ab earum placeat tenetur in eos, omnis quidem accusantium voluptate corporis, labore, cum voluptatibus totam sunt mollitia et rerum sit. Voluptatem fugiat eaque dolore explicabo ex veritatis deleniti delectus.\n  Nobis aliquam blanditiis cumque nesciunt repellendus voluptate ullam, eligendi dicta voluptates tenetur molestias omnis itaque eius voluptas dignissimos inventore repellat distinctio velit ducimus ipsam placeat. Quo amet aut, doloremque incidunt.\n  Asperiores sed cupiditate animi aliquam, facilis vitae nobis deserunt ipsa fugiat, at incidunt eum delectus error inventore itaque fuga sunt aspernatur beatae saepe maxime id. Fuga consequatur hic debitis ipsum.\n  Animi dolorum ullam, dolorem ut quibusdam tempora repellendus iste veritatis doloribus nam? Minima veritatis omnis deleniti illo? Vero, perferendis ipsum, ea dicta illum non reiciendis obcaecati sunt dolorem esse hic.\n</div>\n<div id="three" class="split split-horizontal">\n  Lorem ipsum dolor sit amet, consectetur adipisicing elit. Voluptatem quod expedita vero voluptatibus modi, dolores assumenda ex atque aliquam accusamus, deserunt quibusdam pariatur eaque optio ducimus minima. Commodi, odit. Nulla.\n  Rerum, nostrum, officiis! Nam vel in ea ut et nemo quae quis suscipit dolores voluptatum odio, qui ratione dolor vero perspiciatis enim incidunt error harum hic ad numquam nostrum magni.\n  Minus illo vel ipsa, ullam unde itaque cum mollitia nihil! Voluptatibus quaerat ab ut quo, repudiandae qui reprehenderit eligendi maiores harum labore sit, laudantium expedita reiciendis hic nostrum beatae id!\n  Laborum magni iusto sunt commodi dolor quis voluptatibus fugiat alias, aliquid fugit nisi facere. Eaque harum laudantium sint, veniam laborum illum beatae cumque quis reprehenderit tempore, animi perferendis officiis quos.\n  Quam iusto id necessitatibus nam asperiores quod inventore itaque ullam laborum quis. Excepturi, suscipit, autem! Pariatur commodi nisi quia, sit perspiciatis necessitatibus, tempore neque nulla nemo eum aspernatur placeat voluptate!\n</div>')}]),angular.module("xos.ceilometerDashboard").run(["$location",function(e){e.path("/")}]),angular.bootstrap(angular.element("#xosCeilometerDashboard"),["xos.ceilometerDashboard"]);