(function(){"use strict";var t=this,e=t.Chart,i=function(t){this.canvas=t.canvas,this.ctx=t;var e=function(t,e){return t["offset"+e]?t["offset"+e]:document.defaultView.getComputedStyle(t).getPropertyValue(e)},i=this.width=e(t.canvas,"Width"),s=this.height=e(t.canvas,"Height");t.canvas.width=i,t.canvas.height=s;var i=this.width=t.canvas.width,s=this.height=t.canvas.height;return this.aspectRatio=this.width/this.height,n.retinaScale(this),this};i.defaults={global:{animation:!0,animationSteps:60,animationEasing:"easeOutQuart",showScale:!0,scaleOverride:!1,scaleSteps:null,scaleStepWidth:null,scaleStartValue:null,scaleLineColor:"rgba(0,0,0,.1)",scaleLineWidth:1,scaleShowLabels:!0,scaleLabel:"<%=value%>",scaleIntegersOnly:!0,scaleBeginAtZero:!1,scaleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",scaleFontSize:12,scaleFontStyle:"normal",scaleFontColor:"#666",responsive:!1,maintainAspectRatio:!0,showTooltips:!0,customTooltips:!1,tooltipEvents:["mousemove","touchstart","touchmove","mouseout"],tooltipFillColor:"rgba(0,0,0,0.8)",tooltipFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipFontSize:14,tooltipFontStyle:"normal",tooltipFontColor:"#fff",tooltipTitleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",tooltipTitleFontSize:14,tooltipTitleFontStyle:"bold",tooltipTitleFontColor:"#fff",tooltipYPadding:6,tooltipXPadding:6,tooltipCaretSize:8,tooltipCornerRadius:6,tooltipXOffset:10,tooltipTemplate:"<%if (label){%><%=label%>: <%}%><%= value %>",multiTooltipTemplate:"<%= value %>",multiTooltipKeyBackground:"#fff",onAnimationProgress:function(){},onAnimationComplete:function(){}}},i.types={};var n=i.helpers={},s=n.each=function(t,e,i){var n=Array.prototype.slice.call(arguments,3);if(t)if(t.length===+t.length){var s;for(s=0;s<t.length;s++)e.apply(i,[t[s],s].concat(n))}else for(var a in t)e.apply(i,[t[a],a].concat(n))},a=n.clone=function(t){var e={};return s(t,function(i,n){t.hasOwnProperty(n)&&(e[n]=i)}),e},o=n.extend=function(t){return s(Array.prototype.slice.call(arguments,1),function(e){s(e,function(i,n){e.hasOwnProperty(n)&&(t[n]=i)})}),t},r=n.merge=function(t,e){var i=Array.prototype.slice.call(arguments,0);return i.unshift({}),o.apply(null,i)},l=n.indexOf=function(t,e){if(Array.prototype.indexOf)return t.indexOf(e);for(var i=0;i<t.length;i++)if(t[i]===e)return i;return-1},h=(n.where=function(t,e){var i=[];return n.each(t,function(t){e(t)&&i.push(t)}),i},n.findNextWhere=function(t,e,i){i||(i=-1);for(var n=i+1;n<t.length;n++){var s=t[n];if(e(s))return s}},n.findPreviousWhere=function(t,e,i){i||(i=t.length);for(var n=i-1;n>=0;n--){var s=t[n];if(e(s))return s}},n.inherits=function(t){var e=this,i=t&&t.hasOwnProperty("constructor")?t.constructor:function(){return e.apply(this,arguments)},n=function(){this.constructor=i};return n.prototype=e.prototype,i.prototype=new n,i.extend=h,t&&o(i.prototype,t),i.__super__=e.prototype,i}),c=n.noop=function(){},u=n.uid=function(){var t=0;return function(){return"chart-"+t++}}(),d=n.warn=function(t){window.console&&"function"==typeof window.console.warn&&console.warn(t)},f=n.amd="function"==typeof define&&define.amd,p=n.isNumber=function(t){return!isNaN(parseFloat(t))&&isFinite(t)},g=n.max=function(t){return Math.max.apply(Math,t)},v=n.min=function(t){return Math.min.apply(Math,t)},m=(n.cap=function(t,e,i){if(p(e)){if(t>e)return e}else if(p(i)&&i>t)return i;return t},n.getDecimalPlaces=function(t){return t%1!==0&&p(t)?t.toString().split(".")[1].length:0}),C=n.radians=function(t){return t*(Math.PI/180)},y=(n.getAngleFromPoint=function(t,e){var i=e.x-t.x,n=e.y-t.y,s=Math.sqrt(i*i+n*n),a=2*Math.PI+Math.atan2(n,i);return 0>i&&0>n&&(a+=2*Math.PI),{angle:a,distance:s}},n.aliasPixel=function(t){return t%2===0?0:.5}),b=(n.splineCurve=function(t,e,i,n){var s=Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2)),a=Math.sqrt(Math.pow(i.x-e.x,2)+Math.pow(i.y-e.y,2)),o=n*s/(s+a),r=n*a/(s+a);return{inner:{x:e.x-o*(i.x-t.x),y:e.y-o*(i.y-t.y)},outer:{x:e.x+r*(i.x-t.x),y:e.y+r*(i.y-t.y)}}},n.calculateOrderOfMagnitude=function(t){return Math.floor(Math.log(t)/Math.LN10)}),w=(n.calculateScaleRange=function(t,e,i,n,s){var a=2,o=Math.floor(e/(1.5*i)),r=a>=o,l=g(t),h=v(t);l===h&&(l+=.5,h>=.5&&!n?h-=.5:l+=.5);for(var c=Math.abs(l-h),u=b(c),d=Math.ceil(l/(1*Math.pow(10,u)))*Math.pow(10,u),f=n?0:Math.floor(h/(1*Math.pow(10,u)))*Math.pow(10,u),p=d-f,m=Math.pow(10,u),C=Math.round(p/m);(C>o||o>2*C)&&!r;)if(C>o)m*=2,C=Math.round(p/m),C%1!==0&&(r=!0);else if(s&&u>=0){if(m/2%1!==0)break;m/=2,C=Math.round(p/m)}else m/=2,C=Math.round(p/m);return r&&(C=a,m=p/C),{steps:C,stepValue:m,min:f,max:f+C*m}},n.template=function(t,e){function i(t,e){var i=/\W/.test(t)?new Function("obj","var p=[],print=function(){p.push.apply(p,arguments);};with(obj){p.push('"+t.replace(/[\r\t\n]/g," ").split("<%").join("	").replace(/((^|%>)[^\t]*)'/g,"$1\r").replace(/\t=(.*?)%>/g,"',$1,'").split("	").join("');").split("%>").join("p.push('").split("\r").join("\\'")+"');}return p.join('');"):n[t]=n[t];return e?i(e):i}if(t instanceof Function)return t(e);var n={};return i(t,e)}),x=(n.generateLabels=function(t,e,i,n){var a=new Array(e);return labelTemplateString&&s(a,function(e,s){a[s]=w(t,{value:i+n*(s+1)})}),a},n.easingEffects={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-1*t*(t-2)},easeInOutQuad:function(t){return(t/=.5)<1?.5*t*t:-0.5*(--t*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return 1*((t=t/1-1)*t*t+1)},easeInOutCubic:function(t){return(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-1*((t=t/1-1)*t*t*t-1)},easeInOutQuart:function(t){return(t/=.5)<1?.5*t*t*t*t:-0.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return 1*(t/=1)*t*t*t*t},easeOutQuint:function(t){return 1*((t=t/1-1)*t*t*t*t+1)},easeInOutQuint:function(t){return(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return-1*Math.cos(t/1*(Math.PI/2))+1},easeOutSine:function(t){return 1*Math.sin(t/1*(Math.PI/2))},easeInOutSine:function(t){return-0.5*(Math.cos(Math.PI*t/1)-1)},easeInExpo:function(t){return 0===t?1:1*Math.pow(2,10*(t/1-1))},easeOutExpo:function(t){return 1===t?1:1*(-Math.pow(2,-10*t/1)+1)},easeInOutExpo:function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(-Math.pow(2,-10*--t)+2)},easeInCirc:function(t){return t>=1?t:-1*(Math.sqrt(1-(t/=1)*t)-1)},easeOutCirc:function(t){return 1*Math.sqrt(1-(t=t/1-1)*t)},easeInOutCirc:function(t){return(t/=.5)<1?-0.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var e=1.70158,i=0,n=1;return 0===t?0:1==(t/=1)?1:(i||(i=.3),n<Math.abs(1)?(n=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/n),-(n*Math.pow(2,10*(t-=1))*Math.sin((1*t-e)*(2*Math.PI)/i)))},easeOutElastic:function(t){var e=1.70158,i=0,n=1;return 0===t?0:1==(t/=1)?1:(i||(i=.3),n<Math.abs(1)?(n=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/n),n*Math.pow(2,-10*t)*Math.sin((1*t-e)*(2*Math.PI)/i)+1)},easeInOutElastic:function(t){var e=1.70158,i=0,n=1;return 0===t?0:2==(t/=.5)?1:(i||(i=1*(.3*1.5)),n<Math.abs(1)?(n=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/n),1>t?-.5*(n*Math.pow(2,10*(t-=1))*Math.sin((1*t-e)*(2*Math.PI)/i)):n*Math.pow(2,-10*(t-=1))*Math.sin((1*t-e)*(2*Math.PI)/i)*.5+1)},easeInBack:function(t){var e=1.70158;return 1*(t/=1)*t*((e+1)*t-e)},easeOutBack:function(t){var e=1.70158;return 1*((t=t/1-1)*t*((e+1)*t+e)+1)},easeInOutBack:function(t){var e=1.70158;return(t/=.5)<1?.5*(t*t*(((e*=1.525)+1)*t-e)):.5*((t-=2)*t*(((e*=1.525)+1)*t+e)+2)},easeInBounce:function(t){return 1-x.easeOutBounce(1-t)},easeOutBounce:function(t){return(t/=1)<1/2.75?1*(7.5625*t*t):2/2.75>t?1*(7.5625*(t-=1.5/2.75)*t+.75):2.5/2.75>t?1*(7.5625*(t-=2.25/2.75)*t+.9375):1*(7.5625*(t-=2.625/2.75)*t+.984375)},easeInOutBounce:function(t){return.5>t?.5*x.easeInBounce(2*t):.5*x.easeOutBounce(2*t-1)+.5}}),S=n.requestAnimFrame=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){return window.setTimeout(t,1e3/60)}}(),P=n.cancelAnimFrame=function(){return window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(t){return window.clearTimeout(t,1e3/60)}}(),k=(n.animationLoop=function(t,e,i,n,s,a){var o=0,r=x[i]||x.linear,l=function(){o++;var i=o/e,h=r(i);t.call(a,h,i,o),n.call(a,h,i),e>o?a.animationFrame=S(l):s.apply(a)};S(l)},n.getRelativePosition=function(t){var e,i,n=t.originalEvent||t,s=t.currentTarget||t.srcElement,a=s.getBoundingClientRect();return n.touches?(e=n.touches[0].clientX-a.left,i=n.touches[0].clientY-a.top):(e=n.clientX-a.left,i=n.clientY-a.top),{x:e,y:i}},n.addEvent=function(t,e,i){t.addEventListener?t.addEventListener(e,i):t.attachEvent?t.attachEvent("on"+e,i):t["on"+e]=i}),A=n.removeEvent=function(t,e,i){t.removeEventListener?t.removeEventListener(e,i,!1):t.detachEvent?t.detachEvent("on"+e,i):t["on"+e]=c},L=(n.bindEvents=function(t,e,i){t.events||(t.events={}),s(e,function(e){t.events[e]=function(){i.apply(t,arguments)},k(t.chart.canvas,e,t.events[e])})},n.unbindEvents=function(t,e){s(e,function(e,i){A(t.chart.canvas,i,e)})}),$=n.getMaximumWidth=function(t){var e=t.parentNode;return e.clientWidth},F=n.getMaximumHeight=function(t){var e=t.parentNode;return e.clientHeight},T=(n.getMaximumSize=n.getMaximumWidth,n.retinaScale=function(t){var e=t.ctx,i=t.canvas.width,n=t.canvas.height;window.devicePixelRatio&&(e.canvas.style.width=i+"px",e.canvas.style.height=n+"px",e.canvas.height=n*window.devicePixelRatio,e.canvas.width=i*window.devicePixelRatio,e.scale(window.devicePixelRatio,window.devicePixelRatio))}),R=n.clear=function(t){t.ctx.clearRect(0,0,t.width,t.height)},D=n.fontString=function(t,e,i){return e+" "+t+"px "+i},M=n.longestText=function(t,e,i){t.font=e;var n=0;return s(i,function(e){var i=t.measureText(e).width;n=i>n?i:n}),n},O=n.drawRoundedRectangle=function(t,e,i,n,s,a){t.beginPath(),t.moveTo(e+a,i),t.lineTo(e+n-a,i),t.quadraticCurveTo(e+n,i,e+n,i+a),t.lineTo(e+n,i+s-a),t.quadraticCurveTo(e+n,i+s,e+n-a,i+s),t.lineTo(e+a,i+s),t.quadraticCurveTo(e,i+s,e,i+s-a),t.lineTo(e,i+a),t.quadraticCurveTo(e,i,e+a,i),t.closePath()};i.instances={},i.Type=function(t,e,n){this.options=e,this.chart=n,this.id=u(),i.instances[this.id]=this,e.responsive&&this.resize(),this.initialize.call(this,t)},o(i.Type.prototype,{initialize:function(){return this},clear:function(){return R(this.chart),this},stop:function(){return P(this.animationFrame),this},resize:function(t){this.stop();var e=this.chart.canvas,i=$(this.chart.canvas),n=this.options.maintainAspectRatio?i/this.chart.aspectRatio:F(this.chart.canvas);return e.width=this.chart.width=i,e.height=this.chart.height=n,T(this.chart),"function"==typeof t&&t.apply(this,Array.prototype.slice.call(arguments,1)),this},reflow:c,render:function(t){return t&&this.reflow(),this.options.animation&&!t?n.animationLoop(this.draw,this.options.animationSteps,this.options.animationEasing,this.options.onAnimationProgress,this.options.onAnimationComplete,this):(this.draw(),this.options.onAnimationComplete.call(this)),this},generateLegend:function(){return w(this.options.legendTemplate,this)},destroy:function(){this.clear(),L(this,this.events);var t=this.chart.canvas;t.width=this.chart.width,t.height=this.chart.height,t.style.removeProperty?(t.style.removeProperty("width"),t.style.removeProperty("height")):(t.style.removeAttribute("width"),t.style.removeAttribute("height")),delete i.instances[this.id]},showTooltip:function(t,e){"undefined"==typeof this.activeElements&&(this.activeElements=[]);var a=function(t){var e=!1;return t.length!==this.activeElements.length?e=!0:(s(t,function(t,i){t!==this.activeElements[i]&&(e=!0)},this),e)}.call(this,t);if(a||e){if(this.activeElements=t,this.draw(),this.options.customTooltips&&this.options.customTooltips(!1),t.length>0)if(this.datasets&&this.datasets.length>1){for(var o,r,h=this.datasets.length-1;h>=0&&(o=this.datasets[h].points||this.datasets[h].bars||this.datasets[h].segments,r=l(o,t[0]),-1===r);h--);var c=[],u=[],d=function(t){var e,i,s,a,o,l=[],h=[],d=[];return n.each(this.datasets,function(t){e=t.points||t.bars||t.segments,e[r]&&e[r].hasValue()&&l.push(e[r])}),n.each(l,function(t){h.push(t.x),d.push(t.y),c.push(n.template(this.options.multiTooltipTemplate,t)),u.push({fill:t._saved.fillColor||t.fillColor,stroke:t._saved.strokeColor||t.strokeColor})},this),o=v(d),s=g(d),a=v(h),i=g(h),{x:a>this.chart.width/2?a:i,y:(o+s)/2}}.call(this,r);new i.MultiTooltip({x:d.x,y:d.y,xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,xOffset:this.options.tooltipXOffset,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,titleTextColor:this.options.tooltipTitleFontColor,titleFontFamily:this.options.tooltipTitleFontFamily,titleFontStyle:this.options.tooltipTitleFontStyle,titleFontSize:this.options.tooltipTitleFontSize,cornerRadius:this.options.tooltipCornerRadius,labels:c,legendColors:u,legendColorBackground:this.options.multiTooltipKeyBackground,title:t[0].label,chart:this.chart,ctx:this.chart.ctx,custom:this.options.customTooltips}).draw()}else s(t,function(t){var e=t.tooltipPosition();new i.Tooltip({x:Math.round(e.x),y:Math.round(e.y),xPadding:this.options.tooltipXPadding,yPadding:this.options.tooltipYPadding,fillColor:this.options.tooltipFillColor,textColor:this.options.tooltipFontColor,fontFamily:this.options.tooltipFontFamily,fontStyle:this.options.tooltipFontStyle,fontSize:this.options.tooltipFontSize,caretHeight:this.options.tooltipCaretSize,cornerRadius:this.options.tooltipCornerRadius,text:w(this.options.tooltipTemplate,t),chart:this.chart,custom:this.options.customTooltips}).draw()},this);return this}},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments)}}),i.Type.extend=function(t){var e=this,n=function(){return e.apply(this,arguments)};if(n.prototype=a(e.prototype),o(n.prototype,t),n.extend=i.Type.extend,t.name||e.prototype.name){var s=t.name||e.prototype.name,l=i.defaults[e.prototype.name]?a(i.defaults[e.prototype.name]):{};i.defaults[s]=o(l,t.defaults),i.types[s]=n,i.prototype[s]=function(t,e){var a=r(i.defaults.global,i.defaults[s],e||{});return new n(t,a,this)}}else d("Name not provided for this chart, so it hasn't been registered");return e},i.Element=function(t){o(this,t),this.initialize.apply(this,arguments),this.save()},o(i.Element.prototype,{initialize:function(){},restore:function(t){return t?s(t,function(t){this[t]=this._saved[t]},this):o(this,this._saved),this},save:function(){return this._saved=a(this),delete this._saved._saved,this},update:function(t){return s(t,function(t,e){this._saved[e]=this[e],this[e]=t},this),this},transition:function(t,e){return s(t,function(t,i){this[i]=(t-this._saved[i])*e+this._saved[i]},this),this},tooltipPosition:function(){return{x:this.x,y:this.y}},hasValue:function(){return p(this.value)}}),i.Element.extend=h,i.Point=i.Element.extend({display:!0,inRange:function(t,e){var i=this.hitDetectionRadius+this.radius;return Math.pow(t-this.x,2)+Math.pow(e-this.y,2)<Math.pow(i,2)},draw:function(){if(this.display){var t=this.ctx;t.beginPath(),t.arc(this.x,this.y,this.radius,0,2*Math.PI),t.closePath(),t.strokeStyle=this.strokeColor,t.lineWidth=this.strokeWidth,t.fillStyle=this.fillColor,t.fill(),t.stroke()}}}),i.Arc=i.Element.extend({inRange:function(t,e){var i=n.getAngleFromPoint(this,{x:t,y:e}),s=i.angle>=this.startAngle&&i.angle<=this.endAngle,a=i.distance>=this.innerRadius&&i.distance<=this.outerRadius;return s&&a},tooltipPosition:function(){var t=this.startAngle+(this.endAngle-this.startAngle)/2,e=(this.outerRadius-this.innerRadius)/2+this.innerRadius;return{x:this.x+Math.cos(t)*e,y:this.y+Math.sin(t)*e}},draw:function(t){var e=this.ctx;e.beginPath(),e.arc(this.x,this.y,this.outerRadius,this.startAngle,this.endAngle),e.arc(this.x,this.y,this.innerRadius,this.endAngle,this.startAngle,!0),e.closePath(),e.strokeStyle=this.strokeColor,e.lineWidth=this.strokeWidth,e.fillStyle=this.fillColor,e.fill(),e.lineJoin="bevel",this.showStroke&&e.stroke()}}),i.Rectangle=i.Element.extend({draw:function(){var t=this.ctx,e=this.width/2,i=this.x-e,n=this.x+e,s=this.base-(this.base-this.y),a=this.strokeWidth/2;this.showStroke&&(i+=a,n-=a,s+=a),t.beginPath(),t.fillStyle=this.fillColor,t.strokeStyle=this.strokeColor,t.lineWidth=this.strokeWidth,t.moveTo(i,this.base),t.lineTo(i,s),t.lineTo(n,s),t.lineTo(n,this.base),t.fill(),this.showStroke&&t.stroke()},height:function(){return this.base-this.y},inRange:function(t,e){return t>=this.x-this.width/2&&t<=this.x+this.width/2&&e>=this.y&&e<=this.base}}),i.Tooltip=i.Element.extend({draw:function(){var t=this.chart.ctx;t.font=D(this.fontSize,this.fontStyle,this.fontFamily),this.xAlign="center",this.yAlign="above";var e=this.caretPadding=2,i=t.measureText(this.text).width+2*this.xPadding,n=this.fontSize+2*this.yPadding,s=n+this.caretHeight+e;this.x+i/2>this.chart.width?this.xAlign="left":this.x-i/2<0&&(this.xAlign="right"),this.y-s<0&&(this.yAlign="below");var a=this.x-i/2,o=this.y-s;if(t.fillStyle=this.fillColor,this.custom)this.custom(this);else{switch(this.yAlign){case"above":t.beginPath(),t.moveTo(this.x,this.y-e),t.lineTo(this.x+this.caretHeight,this.y-(e+this.caretHeight)),t.lineTo(this.x-this.caretHeight,this.y-(e+this.caretHeight)),t.closePath(),t.fill();break;case"below":o=this.y+e+this.caretHeight,t.beginPath(),t.moveTo(this.x,this.y+e),t.lineTo(this.x+this.caretHeight,this.y+e+this.caretHeight),t.lineTo(this.x-this.caretHeight,this.y+e+this.caretHeight),t.closePath(),t.fill()}switch(this.xAlign){case"left":a=this.x-i+(this.cornerRadius+this.caretHeight);break;case"right":a=this.x-(this.cornerRadius+this.caretHeight)}O(t,a,o,i,n,this.cornerRadius),t.fill(),t.fillStyle=this.textColor,t.textAlign="center",t.textBaseline="middle",t.fillText(this.text,a+i/2,o+n/2)}}}),i.MultiTooltip=i.Element.extend({initialize:function(){this.font=D(this.fontSize,this.fontStyle,this.fontFamily),this.titleFont=D(this.titleFontSize,this.titleFontStyle,this.titleFontFamily),this.height=this.labels.length*this.fontSize+(this.labels.length-1)*(this.fontSize/2)+2*this.yPadding+1.5*this.titleFontSize,this.ctx.font=this.titleFont;var t=this.ctx.measureText(this.title).width,e=M(this.ctx,this.font,this.labels)+this.fontSize+3,i=g([e,t]);this.width=i+2*this.xPadding;var n=this.height/2;this.y-n<0?this.y=n:this.y+n>this.chart.height&&(this.y=this.chart.height-n),this.x>this.chart.width/2?this.x-=this.xOffset+this.width:this.x+=this.xOffset},getLineHeight:function(t){var e=this.y-this.height/2+this.yPadding,i=t-1;return 0===t?e+this.titleFontSize/2:e+(1.5*this.fontSize*i+this.fontSize/2)+1.5*this.titleFontSize},draw:function(){if(this.custom)this.custom(this);else{O(this.ctx,this.x,this.y-this.height/2,this.width,this.height,this.cornerRadius);var t=this.ctx;t.fillStyle=this.fillColor,t.fill(),t.closePath(),t.textAlign="left",t.textBaseline="middle",t.fillStyle=this.titleTextColor,t.font=this.titleFont,t.fillText(this.title,this.x+this.xPadding,this.getLineHeight(0)),t.font=this.font,n.each(this.labels,function(e,i){t.fillStyle=this.textColor,t.fillText(e,this.x+this.xPadding+this.fontSize+3,this.getLineHeight(i+1)),t.fillStyle=this.legendColorBackground,t.fillRect(this.x+this.xPadding,this.getLineHeight(i+1)-this.fontSize/2,this.fontSize,this.fontSize),t.fillStyle=this.legendColors[i].fill,t.fillRect(this.x+this.xPadding,this.getLineHeight(i+1)-this.fontSize/2,this.fontSize,this.fontSize)},this)}}}),i.Scale=i.Element.extend({initialize:function(){this.fit()},buildYLabels:function(){this.yLabels=[];for(var t=m(this.stepValue),e=0;e<=this.steps;e++)this.yLabels.push(w(this.templateString,{value:(this.min+e*this.stepValue).toFixed(t)}));this.yLabelWidth=this.display&&this.showLabels?M(this.ctx,this.font,this.yLabels):0},addXLabel:function(t){this.xLabels.push(t),this.valuesCount++,this.fit()},removeXLabel:function(){this.xLabels.shift(),this.valuesCount--,this.fit()},fit:function(){this.startPoint=this.display?this.fontSize:0,this.endPoint=this.display?this.height-1.5*this.fontSize-5:this.height,this.startPoint+=this.padding,this.endPoint-=this.padding;var t,e=this.endPoint-this.startPoint;for(this.calculateYRange(e),this.buildYLabels(),this.calculateXLabelRotation();e>this.endPoint-this.startPoint;)e=this.endPoint-this.startPoint,t=this.yLabelWidth,this.calculateYRange(e),this.buildYLabels(),t<this.yLabelWidth&&this.calculateXLabelRotation()},calculateXLabelRotation:function(){this.ctx.font=this.font;var t,e,i=this.ctx.measureText(this.xLabels[0]).width,n=this.ctx.measureText(this.xLabels[this.xLabels.length-1]).width;if(this.xScalePaddingRight=n/2+3,this.xScalePaddingLeft=i/2>this.yLabelWidth+10?i/2:this.yLabelWidth+10,this.xLabelRotation=0,this.display){var s,a=M(this.ctx,this.font,this.xLabels);this.xLabelWidth=a;for(var o=Math.floor(this.calculateX(1)-this.calculateX(0))-6;this.xLabelWidth>o&&0===this.xLabelRotation||this.xLabelWidth>o&&this.xLabelRotation<=90&&this.xLabelRotation>0;)s=Math.cos(C(this.xLabelRotation)),t=s*i,e=s*n,t+this.fontSize/2>this.yLabelWidth+8&&(this.xScalePaddingLeft=t+this.fontSize/2),this.xScalePaddingRight=this.fontSize/2,this.xLabelRotation++,this.xLabelWidth=s*a;this.xLabelRotation>0&&(this.endPoint-=Math.sin(C(this.xLabelRotation))*a+3)}else this.xLabelWidth=0,this.xScalePaddingRight=this.padding,this.xScalePaddingLeft=this.padding},calculateYRange:c,drawingArea:function(){return this.startPoint-this.endPoint},calculateY:function(t){var e=this.drawingArea()/(this.min-this.max);return this.endPoint-e*(t-this.min)},calculateX:function(t){var e=(this.xLabelRotation>0,this.width-(this.xScalePaddingLeft+this.xScalePaddingRight)),i=e/Math.max(this.valuesCount-(this.offsetGridLines?0:1),1),n=i*t+this.xScalePaddingLeft;return this.offsetGridLines&&(n+=i/2),Math.round(n)},update:function(t){n.extend(this,t),this.fit()},draw:function(){var t=this.ctx,e=(this.endPoint-this.startPoint)/this.steps,i=Math.round(this.xScalePaddingLeft);this.display&&(t.fillStyle=this.textColor,t.font=this.font,s(this.yLabels,function(s,a){var o=this.endPoint-e*a,r=Math.round(o),l=this.showHorizontalLines;t.textAlign="right",t.textBaseline="middle",this.showLabels&&t.fillText(s,i-10,o),0!==a||l||(l=!0),l&&t.beginPath(),a>0?(t.lineWidth=this.gridLineWidth,t.strokeStyle=this.gridLineColor):(t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor),r+=n.aliasPixel(t.lineWidth),l&&(t.moveTo(i,r),t.lineTo(this.width,r),t.stroke(),t.closePath()),t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor,t.beginPath(),t.moveTo(i-5,r),t.lineTo(i,r),t.stroke(),t.closePath()},this),s(this.xLabels,function(e,i){var n=this.calculateX(i)+y(this.lineWidth),s=this.calculateX(i-(this.offsetGridLines?.5:0))+y(this.lineWidth),a=this.xLabelRotation>0,o=this.showVerticalLines;0!==i||o||(o=!0),o&&t.beginPath(),i>0?(t.lineWidth=this.gridLineWidth,t.strokeStyle=this.gridLineColor):(t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor),o&&(t.moveTo(s,this.endPoint),t.lineTo(s,this.startPoint-3),t.stroke(),t.closePath()),t.lineWidth=this.lineWidth,t.strokeStyle=this.lineColor,t.beginPath(),t.moveTo(s,this.endPoint),t.lineTo(s,this.endPoint+5),t.stroke(),t.closePath(),t.save(),t.translate(n,a?this.endPoint+12:this.endPoint+8),t.rotate(-1*C(this.xLabelRotation)),t.font=this.font,t.textAlign=a?"right":"center",t.textBaseline=a?"middle":"top",t.fillText(e,0,0),t.restore()},this))}}),i.RadialScale=i.Element.extend({initialize:function(){this.size=v([this.height,this.width]),this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2},calculateCenterOffset:function(t){var e=this.drawingArea/(this.max-this.min);return(t-this.min)*e},update:function(){this.lineArc?this.drawingArea=this.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2:this.setScaleSize(),this.buildYLabels()},buildYLabels:function(){this.yLabels=[];for(var t=m(this.stepValue),e=0;e<=this.steps;e++)this.yLabels.push(w(this.templateString,{value:(this.min+e*this.stepValue).toFixed(t)}))},getCircumference:function(){return 2*Math.PI/this.valuesCount},setScaleSize:function(){var t,e,i,n,s,a,o,r,l,h,c,u,d=v([this.height/2-this.pointLabelFontSize-5,this.width/2]),f=this.width,g=0;for(this.ctx.font=D(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily),e=0;e<this.valuesCount;e++)t=this.getPointPosition(e,d),i=this.ctx.measureText(w(this.templateString,{value:this.labels[e]})).width+5,0===e||e===this.valuesCount/2?(n=i/2,t.x+n>f&&(f=t.x+n,s=e),t.x-n<g&&(g=t.x-n,o=e)):e<this.valuesCount/2?t.x+i>f&&(f=t.x+i,s=e):e>this.valuesCount/2&&t.x-i<g&&(g=t.x-i,o=e);l=g,h=Math.ceil(f-this.width),a=this.getIndexAngle(s),r=this.getIndexAngle(o),c=h/Math.sin(a+Math.PI/2),u=l/Math.sin(r+Math.PI/2),c=p(c)?c:0,u=p(u)?u:0,this.drawingArea=d-(u+c)/2,this.setCenterPoint(u,c)},setCenterPoint:function(t,e){var i=this.width-e-this.drawingArea,n=t+this.drawingArea;this.xCenter=(n+i)/2,this.yCenter=this.height/2},getIndexAngle:function(t){var e=2*Math.PI/this.valuesCount;return t*e-Math.PI/2},getPointPosition:function(t,e){var i=this.getIndexAngle(t);return{x:Math.cos(i)*e+this.xCenter,y:Math.sin(i)*e+this.yCenter}},draw:function(){if(this.display){var t=this.ctx;if(s(this.yLabels,function(e,i){if(i>0){var n,s=i*(this.drawingArea/this.steps),a=this.yCenter-s;if(this.lineWidth>0)if(t.strokeStyle=this.lineColor,t.lineWidth=this.lineWidth,this.lineArc)t.beginPath(),t.arc(this.xCenter,this.yCenter,s,0,2*Math.PI),t.closePath(),t.stroke();else{t.beginPath();for(var o=0;o<this.valuesCount;o++)n=this.getPointPosition(o,this.calculateCenterOffset(this.min+i*this.stepValue)),0===o?t.moveTo(n.x,n.y):t.lineTo(n.x,n.y);t.closePath(),t.stroke()}if(this.showLabels){if(t.font=D(this.fontSize,this.fontStyle,this.fontFamily),this.showLabelBackdrop){var r=t.measureText(e).width;t.fillStyle=this.backdropColor,t.fillRect(this.xCenter-r/2-this.backdropPaddingX,a-this.fontSize/2-this.backdropPaddingY,r+2*this.backdropPaddingX,this.fontSize+2*this.backdropPaddingY)}t.textAlign="center",t.textBaseline="middle",t.fillStyle=this.fontColor,t.fillText(e,this.xCenter,a)}}},this),!this.lineArc){t.lineWidth=this.angleLineWidth,t.strokeStyle=this.angleLineColor;for(var e=this.valuesCount-1;e>=0;e--){if(this.angleLineWidth>0){var i=this.getPointPosition(e,this.calculateCenterOffset(this.max));t.beginPath(),t.moveTo(this.xCenter,this.yCenter),t.lineTo(i.x,i.y),t.stroke(),t.closePath()}var n=this.getPointPosition(e,this.calculateCenterOffset(this.max)+5);t.font=D(this.pointLabelFontSize,this.pointLabelFontStyle,this.pointLabelFontFamily),t.fillStyle=this.pointLabelFontColor;var a=this.labels.length,o=this.labels.length/2,r=o/2,l=r>e||e>a-r,h=e===r||e===a-r;0===e?t.textAlign="center":e===o?t.textAlign="center":o>e?t.textAlign="left":t.textAlign="right",h?t.textBaseline="middle":l?t.textBaseline="bottom":t.textBaseline="top",t.fillText(this.labels[e],n.x,n.y)}}}}}),n.addEvent(window,"resize",function(){var t;return function(){clearTimeout(t),t=setTimeout(function(){s(i.instances,function(t){t.options.responsive&&t.resize(t.render,!0)})},50)}}()),f?define(function(){return i}):"object"==typeof module&&module.exports&&(module.exports=i),t.Chart=i,i.noConflict=function(){return t.Chart=e,i}}).call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,n={scaleBeginAtZero:!0,scaleShowGridLines:!0,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:!0,scaleShowVerticalLines:!0,barShowStroke:!0,barStrokeWidth:2,barValueSpacing:5,barDatasetSpacing:1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].fillColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>'};e.Type.extend({name:"Bar",defaults:n,initialize:function(t){var n=this.options;this.ScaleClass=e.Scale.extend({offsetGridLines:!0,calculateBarX:function(t,e,i){var s=this.calculateBaseWidth(),a=this.calculateX(i)-s/2,o=this.calculateBarWidth(t);return a+o*e+e*n.barDatasetSpacing+o/2},calculateBaseWidth:function(){return this.calculateX(1)-this.calculateX(0)-2*n.barValueSpacing},calculateBarWidth:function(t){var e=this.calculateBaseWidth()-(t-1)*n.barDatasetSpacing;return e/t}}),this.datasets=[],this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getBarsAtEvent(t):[];this.eachBars(function(t){t.restore(["fillColor","strokeColor"])}),i.each(e,function(t){t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke}),this.showTooltip(e)}),this.BarClass=e.Rectangle.extend({strokeWidth:this.options.barStrokeWidth,showStroke:this.options.barShowStroke,ctx:this.chart.ctx}),i.each(t.datasets,function(e,n){var s={label:e.label||null,fillColor:e.fillColor,strokeColor:e.strokeColor,bars:[]};this.datasets.push(s),i.each(e.data,function(i,n){s.bars.push(new this.BarClass({value:i,label:t.labels[n],datasetLabel:e.label,strokeColor:e.strokeColor,fillColor:e.fillColor,highlightFill:e.highlightFill||e.fillColor,highlightStroke:e.highlightStroke||e.strokeColor}))},this)},this),this.buildScale(t.labels),this.BarClass.prototype.base=this.scale.endPoint,this.eachBars(function(t,e,n){i.extend(t,{width:this.scale.calculateBarWidth(this.datasets.length),x:this.scale.calculateBarX(this.datasets.length,n,e),y:this.scale.endPoint}),t.save()},this),this.render()},update:function(){this.scale.update(),i.each(this.activeElements,function(t){t.restore(["fillColor","strokeColor"])}),this.eachBars(function(t){t.save()}),this.render()},eachBars:function(t){i.each(this.datasets,function(e,n){i.each(e.bars,t,this,n)},this)},getBarsAtEvent:function(t){for(var e,n=[],s=i.getRelativePosition(t),a=function(t){n.push(t.bars[e])},o=0;o<this.datasets.length;o++)for(e=0;e<this.datasets[o].bars.length;e++)if(this.datasets[o].bars[e].inRange(s.x,s.y))return i.each(this.datasets,a),n;return n},buildScale:function(t){var e=this,n=function(){var t=[];return e.eachBars(function(e){t.push(e.value)}),t},s={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:t.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(t){var e=i.calculateScaleRange(n(),t,this.fontSize,this.beginAtZero,this.integersOnly);i.extend(this,e)},xLabels:t,font:i.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:this.options.scaleShowGridLines?this.options.scaleGridLineWidth:0,gridLineColor:this.options.scaleShowGridLines?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:this.options.showScale?0:this.options.barShowStroke?this.options.barStrokeWidth:0,showLabels:this.options.scaleShowLabels,display:this.options.showScale};this.options.scaleOverride&&i.extend(s,{calculateYRange:i.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}),this.scale=new this.ScaleClass(s)},addData:function(t,e){i.each(t,function(t,i){this.datasets[i].bars.push(new this.BarClass({value:t,label:e,x:this.scale.calculateBarX(this.datasets.length,i,this.scale.valuesCount+1),y:this.scale.endPoint,width:this.scale.calculateBarWidth(this.datasets.length),
base:this.scale.endPoint,strokeColor:this.datasets[i].strokeColor,fillColor:this.datasets[i].fillColor}))},this),this.scale.addXLabel(e),this.update()},removeData:function(){this.scale.removeXLabel(),i.each(this.datasets,function(t){t.bars.shift()},this),this.update()},reflow:function(){i.extend(this.BarClass.prototype,{y:this.scale.endPoint,base:this.scale.endPoint});var t=i.extend({height:this.chart.height,width:this.chart.width});this.scale.update(t)},draw:function(t){var e=t||1;this.clear();this.chart.ctx;this.scale.draw(e),i.each(this.datasets,function(t,n){i.each(t.bars,function(t,i){t.hasValue()&&(t.base=this.scale.endPoint,t.transition({x:this.scale.calculateBarX(this.datasets.length,n,i),y:this.scale.calculateY(t.value),width:this.scale.calculateBarWidth(this.datasets.length)},e).draw())},this)},this)}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,n={segmentShowStroke:!0,segmentStrokeColor:"#fff",segmentStrokeWidth:2,percentageInnerCutout:50,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:!0,animateScale:!1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>'};e.Type.extend({name:"Doughnut",defaults:n,initialize:function(t){this.segments=[],this.outerRadius=(i.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2,this.SegmentArc=e.Arc.extend({ctx:this.chart.ctx,x:this.chart.width/2,y:this.chart.height/2}),this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getSegmentsAtEvent(t):[];i.each(this.segments,function(t){t.restore(["fillColor"])}),i.each(e,function(t){t.fillColor=t.highlightColor}),this.showTooltip(e)}),this.calculateTotal(t),i.each(t,function(t,e){this.addData(t,e,!0)},this),this.render()},getSegmentsAtEvent:function(t){var e=[],n=i.getRelativePosition(t);return i.each(this.segments,function(t){t.inRange(n.x,n.y)&&e.push(t)},this),e},addData:function(t,e,i){var n=e||this.segments.length;this.segments.splice(n,0,new this.SegmentArc({value:t.value,outerRadius:this.options.animateScale?0:this.outerRadius,innerRadius:this.options.animateScale?0:this.outerRadius/100*this.options.percentageInnerCutout,fillColor:t.color,highlightColor:t.highlight||t.color,showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,startAngle:1.5*Math.PI,circumference:this.options.animateRotate?0:this.calculateCircumference(t.value),label:t.label})),i||(this.reflow(),this.update())},calculateCircumference:function(t){return 2*Math.PI*(Math.abs(t)/this.total)},calculateTotal:function(t){this.total=0,i.each(t,function(t){this.total+=Math.abs(t.value)},this)},update:function(){this.calculateTotal(this.segments),i.each(this.activeElements,function(t){t.restore(["fillColor"])}),i.each(this.segments,function(t){t.save()}),this.render()},removeData:function(t){var e=i.isNumber(t)?t:this.segments.length-1;this.segments.splice(e,1),this.reflow(),this.update()},reflow:function(){i.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2}),this.outerRadius=(i.min([this.chart.width,this.chart.height])-this.options.segmentStrokeWidth/2)/2,i.each(this.segments,function(t){t.update({outerRadius:this.outerRadius,innerRadius:this.outerRadius/100*this.options.percentageInnerCutout})},this)},draw:function(t){var e=t?t:1;this.clear(),i.each(this.segments,function(t,i){t.transition({circumference:this.calculateCircumference(t.value),outerRadius:this.outerRadius,innerRadius:this.outerRadius/100*this.options.percentageInnerCutout},e),t.endAngle=t.startAngle+t.circumference,t.draw(),0===i&&(t.startAngle=1.5*Math.PI),i<this.segments.length-1&&(this.segments[i+1].startAngle=t.endAngle)},this)}}),e.types.Doughnut.extend({name:"Pie",defaults:i.merge(n,{percentageInnerCutout:0})})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,n={scaleShowGridLines:!0,scaleGridLineColor:"rgba(0,0,0,.05)",scaleGridLineWidth:1,scaleShowHorizontalLines:!0,scaleShowVerticalLines:!0,bezierCurve:!0,bezierCurveTension:.4,pointDot:!0,pointDotRadius:4,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:!0,datasetStrokeWidth:2,datasetFill:!0,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].strokeColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>'};e.Type.extend({name:"Line",defaults:n,initialize:function(t){this.PointClass=e.Point.extend({strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx,inRange:function(t){return Math.pow(t-this.x,2)<Math.pow(this.radius+this.hitDetectionRadius,2)}}),this.datasets=[],this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getPointsAtEvent(t):[];this.eachPoints(function(t){t.restore(["fillColor","strokeColor"])}),i.each(e,function(t){t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke}),this.showTooltip(e)}),i.each(t.datasets,function(e){var n={label:e.label||null,fillColor:e.fillColor,strokeColor:e.strokeColor,pointColor:e.pointColor,pointStrokeColor:e.pointStrokeColor,points:[]};this.datasets.push(n),i.each(e.data,function(i,s){n.points.push(new this.PointClass({value:i,label:t.labels[s],datasetLabel:e.label,strokeColor:e.pointStrokeColor,fillColor:e.pointColor,highlightFill:e.pointHighlightFill||e.pointColor,highlightStroke:e.pointHighlightStroke||e.pointStrokeColor}))},this),this.buildScale(t.labels),this.eachPoints(function(t,e){i.extend(t,{x:this.scale.calculateX(e),y:this.scale.endPoint}),t.save()},this)},this),this.render()},update:function(){this.scale.update(),i.each(this.activeElements,function(t){t.restore(["fillColor","strokeColor"])}),this.eachPoints(function(t){t.save()}),this.render()},eachPoints:function(t){i.each(this.datasets,function(e){i.each(e.points,t,this)},this)},getPointsAtEvent:function(t){var e=[],n=i.getRelativePosition(t);return i.each(this.datasets,function(t){i.each(t.points,function(t){t.inRange(n.x,n.y)&&e.push(t)})},this),e},buildScale:function(t){var n=this,s=function(){var t=[];return n.eachPoints(function(e){t.push(e.value)}),t},a={templateString:this.options.scaleLabel,height:this.chart.height,width:this.chart.width,ctx:this.chart.ctx,textColor:this.options.scaleFontColor,fontSize:this.options.scaleFontSize,fontStyle:this.options.scaleFontStyle,fontFamily:this.options.scaleFontFamily,valuesCount:t.length,beginAtZero:this.options.scaleBeginAtZero,integersOnly:this.options.scaleIntegersOnly,calculateYRange:function(t){var e=i.calculateScaleRange(s(),t,this.fontSize,this.beginAtZero,this.integersOnly);i.extend(this,e)},xLabels:t,font:i.fontString(this.options.scaleFontSize,this.options.scaleFontStyle,this.options.scaleFontFamily),lineWidth:this.options.scaleLineWidth,lineColor:this.options.scaleLineColor,showHorizontalLines:this.options.scaleShowHorizontalLines,showVerticalLines:this.options.scaleShowVerticalLines,gridLineWidth:this.options.scaleShowGridLines?this.options.scaleGridLineWidth:0,gridLineColor:this.options.scaleShowGridLines?this.options.scaleGridLineColor:"rgba(0,0,0,0)",padding:this.options.showScale?0:this.options.pointDotRadius+this.options.pointDotStrokeWidth,showLabels:this.options.scaleShowLabels,display:this.options.showScale};this.options.scaleOverride&&i.extend(a,{calculateYRange:i.noop,steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}),this.scale=new e.Scale(a)},addData:function(t,e){i.each(t,function(t,i){this.datasets[i].points.push(new this.PointClass({value:t,label:e,x:this.scale.calculateX(this.scale.valuesCount+1),y:this.scale.endPoint,strokeColor:this.datasets[i].pointStrokeColor,fillColor:this.datasets[i].pointColor}))},this),this.scale.addXLabel(e),this.update()},removeData:function(){this.scale.removeXLabel(),i.each(this.datasets,function(t){t.points.shift()},this),this.update()},reflow:function(){var t=i.extend({height:this.chart.height,width:this.chart.width});this.scale.update(t)},draw:function(t){var e=t||1;this.clear();var n=this.chart.ctx,s=function(t){return null!==t.value},a=function(t,e,n){return i.findNextWhere(e,s,n)||t},o=function(t,e,n){return i.findPreviousWhere(e,s,n)||t};this.scale.draw(e),i.each(this.datasets,function(t){var r=i.where(t.points,s);i.each(t.points,function(t,i){t.hasValue()&&t.transition({y:this.scale.calculateY(t.value),x:this.scale.calculateX(i)},e)},this),this.options.bezierCurve&&i.each(r,function(t,e){var n=e>0&&e<r.length-1?this.options.bezierCurveTension:0;t.controlPoints=i.splineCurve(o(t,r,e),t,a(t,r,e),n),t.controlPoints.outer.y>this.scale.endPoint?t.controlPoints.outer.y=this.scale.endPoint:t.controlPoints.outer.y<this.scale.startPoint&&(t.controlPoints.outer.y=this.scale.startPoint),t.controlPoints.inner.y>this.scale.endPoint?t.controlPoints.inner.y=this.scale.endPoint:t.controlPoints.inner.y<this.scale.startPoint&&(t.controlPoints.inner.y=this.scale.startPoint)},this),n.lineWidth=this.options.datasetStrokeWidth,n.strokeStyle=t.strokeColor,n.beginPath(),i.each(r,function(t,e){if(0===e)n.moveTo(t.x,t.y);else if(this.options.bezierCurve){var i=o(t,r,e);n.bezierCurveTo(i.controlPoints.outer.x,i.controlPoints.outer.y,t.controlPoints.inner.x,t.controlPoints.inner.y,t.x,t.y)}else n.lineTo(t.x,t.y)},this),n.stroke(),this.options.datasetFill&&r.length>0&&(n.lineTo(r[r.length-1].x,this.scale.endPoint),n.lineTo(r[0].x,this.scale.endPoint),n.fillStyle=t.fillColor,n.closePath(),n.fill()),i.each(r,function(t){t.draw()})},this)}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,n={scaleShowLabelBackdrop:!0,scaleBackdropColor:"rgba(255,255,255,0.75)",scaleBeginAtZero:!0,scaleBackdropPaddingY:2,scaleBackdropPaddingX:2,scaleShowLine:!0,segmentShowStroke:!0,segmentStrokeColor:"#fff",segmentStrokeWidth:2,animationSteps:100,animationEasing:"easeOutBounce",animateRotate:!0,animateScale:!1,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>'};e.Type.extend({name:"PolarArea",defaults:n,initialize:function(t){this.segments=[],this.SegmentArc=e.Arc.extend({showStroke:this.options.segmentShowStroke,strokeWidth:this.options.segmentStrokeWidth,strokeColor:this.options.segmentStrokeColor,ctx:this.chart.ctx,innerRadius:0,x:this.chart.width/2,y:this.chart.height/2}),this.scale=new e.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:this.options.scaleShowLine?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,lineArc:!0,width:this.chart.width,height:this.chart.height,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,valuesCount:t.length}),this.updateScaleRange(t),this.scale.update(),i.each(t,function(t,e){this.addData(t,e,!0)},this),this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getSegmentsAtEvent(t):[];i.each(this.segments,function(t){t.restore(["fillColor"])}),i.each(e,function(t){t.fillColor=t.highlightColor}),this.showTooltip(e)}),this.render()},getSegmentsAtEvent:function(t){var e=[],n=i.getRelativePosition(t);return i.each(this.segments,function(t){t.inRange(n.x,n.y)&&e.push(t)},this),e},addData:function(t,e,i){var n=e||this.segments.length;this.segments.splice(n,0,new this.SegmentArc({fillColor:t.color,highlightColor:t.highlight||t.color,label:t.label,value:t.value,outerRadius:this.options.animateScale?0:this.scale.calculateCenterOffset(t.value),circumference:this.options.animateRotate?0:this.scale.getCircumference(),startAngle:1.5*Math.PI})),i||(this.reflow(),this.update())},removeData:function(t){var e=i.isNumber(t)?t:this.segments.length-1;this.segments.splice(e,1),this.reflow(),this.update()},calculateTotal:function(t){this.total=0,i.each(t,function(t){this.total+=t.value},this),this.scale.valuesCount=this.segments.length},updateScaleRange:function(t){var e=[];i.each(t,function(t){e.push(t.value)});var n=this.options.scaleOverride?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}:i.calculateScaleRange(e,i.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);i.extend(this.scale,n,{size:i.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2})},update:function(){this.calculateTotal(this.segments),i.each(this.segments,function(t){t.save()}),this.reflow(),this.render()},reflow:function(){i.extend(this.SegmentArc.prototype,{x:this.chart.width/2,y:this.chart.height/2}),this.updateScaleRange(this.segments),this.scale.update(),i.extend(this.scale,{xCenter:this.chart.width/2,yCenter:this.chart.height/2}),i.each(this.segments,function(t){t.update({outerRadius:this.scale.calculateCenterOffset(t.value)})},this)},draw:function(t){var e=t||1;this.clear(),i.each(this.segments,function(t,i){t.transition({circumference:this.scale.getCircumference(),outerRadius:this.scale.calculateCenterOffset(t.value)},e),t.endAngle=t.startAngle+t.circumference,0===i&&(t.startAngle=1.5*Math.PI),i<this.segments.length-1&&(this.segments[i+1].startAngle=t.endAngle),t.draw()},this),this.scale.draw()}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.Type.extend({name:"Radar",defaults:{scaleShowLine:!0,angleShowLineOut:!0,scaleShowLabels:!1,scaleBeginAtZero:!0,angleLineColor:"rgba(0,0,0,.1)",angleLineWidth:1,pointLabelFontFamily:"'Arial'",pointLabelFontStyle:"normal",pointLabelFontSize:10,pointLabelFontColor:"#666",pointDot:!0,pointDotRadius:3,pointDotStrokeWidth:1,pointHitDetectionRadius:20,datasetStroke:!0,datasetStrokeWidth:2,datasetFill:!0,legendTemplate:'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].strokeColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>'},initialize:function(t){this.PointClass=e.Point.extend({strokeWidth:this.options.pointDotStrokeWidth,radius:this.options.pointDotRadius,display:this.options.pointDot,hitDetectionRadius:this.options.pointHitDetectionRadius,ctx:this.chart.ctx}),this.datasets=[],this.buildScale(t),this.options.showTooltips&&i.bindEvents(this,this.options.tooltipEvents,function(t){var e="mouseout"!==t.type?this.getPointsAtEvent(t):[];this.eachPoints(function(t){t.restore(["fillColor","strokeColor"])}),i.each(e,function(t){t.fillColor=t.highlightFill,t.strokeColor=t.highlightStroke}),this.showTooltip(e)}),i.each(t.datasets,function(e){var n={label:e.label||null,fillColor:e.fillColor,strokeColor:e.strokeColor,pointColor:e.pointColor,pointStrokeColor:e.pointStrokeColor,points:[]};this.datasets.push(n),i.each(e.data,function(i,s){var a;this.scale.animation||(a=this.scale.getPointPosition(s,this.scale.calculateCenterOffset(i))),n.points.push(new this.PointClass({value:i,label:t.labels[s],datasetLabel:e.label,x:this.options.animation?this.scale.xCenter:a.x,y:this.options.animation?this.scale.yCenter:a.y,strokeColor:e.pointStrokeColor,fillColor:e.pointColor,highlightFill:e.pointHighlightFill||e.pointColor,highlightStroke:e.pointHighlightStroke||e.pointStrokeColor}))},this)},this),this.render()},eachPoints:function(t){i.each(this.datasets,function(e){i.each(e.points,t,this)},this)},getPointsAtEvent:function(t){var e=i.getRelativePosition(t),n=i.getAngleFromPoint({x:this.scale.xCenter,y:this.scale.yCenter},e),s=2*Math.PI/this.scale.valuesCount,a=Math.round((n.angle-1.5*Math.PI)/s),o=[];return(a>=this.scale.valuesCount||0>a)&&(a=0),n.distance<=this.scale.drawingArea&&i.each(this.datasets,function(t){o.push(t.points[a])}),o},buildScale:function(t){this.scale=new e.RadialScale({display:this.options.showScale,fontStyle:this.options.scaleFontStyle,fontSize:this.options.scaleFontSize,fontFamily:this.options.scaleFontFamily,fontColor:this.options.scaleFontColor,showLabels:this.options.scaleShowLabels,showLabelBackdrop:this.options.scaleShowLabelBackdrop,backdropColor:this.options.scaleBackdropColor,backdropPaddingY:this.options.scaleBackdropPaddingY,backdropPaddingX:this.options.scaleBackdropPaddingX,lineWidth:this.options.scaleShowLine?this.options.scaleLineWidth:0,lineColor:this.options.scaleLineColor,angleLineColor:this.options.angleLineColor,angleLineWidth:this.options.angleShowLineOut?this.options.angleLineWidth:0,pointLabelFontColor:this.options.pointLabelFontColor,pointLabelFontSize:this.options.pointLabelFontSize,pointLabelFontFamily:this.options.pointLabelFontFamily,pointLabelFontStyle:this.options.pointLabelFontStyle,height:this.chart.height,width:this.chart.width,xCenter:this.chart.width/2,yCenter:this.chart.height/2,ctx:this.chart.ctx,templateString:this.options.scaleLabel,labels:t.labels,valuesCount:t.datasets[0].data.length}),this.scale.setScaleSize(),this.updateScaleRange(t.datasets),this.scale.buildYLabels()},updateScaleRange:function(t){var e=function(){var e=[];return i.each(t,function(t){t.data?e=e.concat(t.data):i.each(t.points,function(t){e.push(t.value)})}),e}(),n=this.options.scaleOverride?{steps:this.options.scaleSteps,stepValue:this.options.scaleStepWidth,min:this.options.scaleStartValue,max:this.options.scaleStartValue+this.options.scaleSteps*this.options.scaleStepWidth}:i.calculateScaleRange(e,i.min([this.chart.width,this.chart.height])/2,this.options.scaleFontSize,this.options.scaleBeginAtZero,this.options.scaleIntegersOnly);i.extend(this.scale,n)},addData:function(t,e){this.scale.valuesCount++,i.each(t,function(t,i){var n=this.scale.getPointPosition(this.scale.valuesCount,this.scale.calculateCenterOffset(t));this.datasets[i].points.push(new this.PointClass({value:t,label:e,x:n.x,y:n.y,strokeColor:this.datasets[i].pointStrokeColor,fillColor:this.datasets[i].pointColor}))},this),this.scale.labels.push(e),this.reflow(),this.update()},removeData:function(){this.scale.valuesCount--,this.scale.labels.shift(),i.each(this.datasets,function(t){t.points.shift()},this),this.reflow(),this.update()},update:function(){this.eachPoints(function(t){t.save()}),this.reflow(),this.render()},reflow:function(){i.extend(this.scale,{width:this.chart.width,height:this.chart.height,size:i.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2}),this.updateScaleRange(this.datasets),this.scale.setScaleSize(),this.scale.buildYLabels()},draw:function(t){var e=t||1,n=this.chart.ctx;this.clear(),this.scale.draw(),i.each(this.datasets,function(t){i.each(t.points,function(t,i){t.hasValue()&&t.transition(this.scale.getPointPosition(i,this.scale.calculateCenterOffset(t.value)),e)},this),n.lineWidth=this.options.datasetStrokeWidth,n.strokeStyle=t.strokeColor,n.beginPath(),i.each(t.points,function(t,e){0===e?n.moveTo(t.x,t.y):n.lineTo(t.x,t.y)},this),n.closePath(),n.stroke(),n.fillStyle=t.fillColor,n.fill(),i.each(t.points,function(t){t.hasValue()&&t.draw()})},this)}})}.call(this),function(t){"use strict";"object"==typeof exports?module.exports=t("undefined"!=typeof angular?angular:require("angular"),"undefined"!=typeof Chart?Chart:require("chart.js")):"function"==typeof define&&define.amd?define(["angular","chart"],t):t(angular,Chart)}(function(t,e){"use strict";function i(){var i={},n={Chart:e,getOptions:function(e){var n=e&&i[e]||{};return t.extend({},i,n)}};this.setOptions=function(e,n){return n?void(i[e]=t.extend(i[e]||{},n)):(n=e,void(i=t.extend(i,n)))},this.$get=function(){return n}}function n(i,n){function a(t,e){return t&&e&&t.length&&e.length?Array.isArray(t[0])?t.length===e.length&&t.every(function(t,i){return t.length===e[i].length}):e.reduce(o,0)>0?t.length===e.length:!1:!1}function o(t,e){return t+e}function r(e,i,n,s){var a=null;return function(o){var r=i.getPointsAtEvent||i.getBarsAtEvent||i.getSegmentsAtEvent;if(r){var l=r.call(i,o);(s===!1||t.equals(a,l)===!1)&&(a=l,e[n](l,o),e.$apply())}}}function l(n,s){for(var a=t.copy(s.colours||i.getOptions(n).colours||e.defaults.global.colours);a.length<s.data.length;)a.push(s.getColour());return a.map(h)}function h(t){return"object"==typeof t&&null!==t?t:"string"==typeof t&&"#"===t[0]?u(p(t.substr(1))):c()}function c(){var t=[d(0,255),d(0,255),d(0,255)];return u(t)}function u(t){return{fillColor:f(t,.2),strokeColor:f(t,1),pointColor:f(t,1),pointStrokeColor:"#fff",pointHighlightFill:"#fff",pointHighlightStroke:f(t,.8)}}function d(t,e){return Math.floor(Math.random()*(e-t+1))+t}function f(t,e){return s?"rgb("+t.join(",")+")":"rgba("+t.concat(e).join(",")+")"}function p(t){var e=parseInt(t,16),i=e>>16&255,n=e>>8&255,s=255&e;return[i,n,s]}function g(e,i,n,s){return{labels:e,datasets:i.map(function(e,i){return t.extend({},s[i],{label:n[i],data:e})})}}function v(e,i,n){return e.map(function(e,s){return t.extend({},n[s],{label:e,value:i[s],color:n[s].strokeColor,highlight:n[s].pointHighlightStroke})})}function m(t,e){var i=t.parent(),n=i.find("chart-legend"),s="<chart-legend>"+e.generateLegend()+"</chart-legend>";n.length?n.replaceWith(s):i.append(s)}function C(t,e,i,n){Array.isArray(i.data[0])?t.datasets.forEach(function(t,i){(t.points||t.bars).forEach(function(t,n){t.value=e[i][n]})}):t.segments.forEach(function(t,i){t.value=e[i]}),t.update(),i.$emit("update",t),i.legend&&"false"!==i.legend&&m(n,t)}function y(t){return!t||Array.isArray(t)&&!t.length||"object"==typeof t&&!Object.keys(t).length}function b(n,s){var a=t.extend({},e.defaults.global,i.getOptions(n),s.options);return a.responsive}return function(e){return{restrict:"CA",scope:{data:"=?",labels:"=?",options:"=?",series:"=?",colours:"=?",getColour:"=?",chartType:"=",legend:"@",click:"=?",hover:"=?",chartData:"=?",chartLabels:"=?",chartOptions:"=?",chartSeries:"=?",chartColours:"=?",chartLegend:"@",chartClick:"=?",chartHover:"=?"},link:function(o,h){function u(t,e){o.$watch(t,function(t){"undefined"!=typeof t&&(o[e]=t)})}function d(i,n){if(!y(i)&&!t.equals(i,n)){var s=e||o.chartType;s&&(w&&w.destroy(),f(s))}}function f(e){if(b(e,o)&&0===h[0].clientHeight&&0===x.clientHeight)return n(function(){f(e)},50,!1);if(o.data&&o.data.length){o.getColour="function"==typeof o.getColour?o.getColour:c,o.colours=l(e,o);var s=h[0],a=s.getContext("2d"),u=Array.isArray(o.data[0])?g(o.labels,o.data,o.series||[],o.colours):v(o.labels,o.data,o.colours),d=t.extend({},i.getOptions(e),o.options);w=new i.Chart(a)[e](u,d),o.$emit("create",w),s.onclick=o.click?r(o,w,"click",!1):t.noop,s.onmousemove=o.hover?r(o,w,"hover",!0):t.noop,o.legend&&"false"!==o.legend&&m(h,w)}}function p(t){if("undefined"!=typeof console&&"test"!==i.getOptions().env){var e="function"==typeof console.warn?console.warn:console.log;o[t]&&e.call(console,'"%s" is deprecated and will be removed in a future version. Please use "chart-%s" instead.',t,t)}}var w,x=document.createElement("div");x.className="chart-container",h.replaceWith(x),x.appendChild(h[0]),s&&window.G_vmlCanvasManager.initElement(h[0]),["data","labels","options","series","colours","legend","click","hover"].forEach(p),u("chartData","data"),u("chartLabels","labels"),u("chartOptions","options"),u("chartSeries","series"),u("chartColours","colours"),u("chartLegend","legend"),u("chartClick","click"),u("chartHover","hover"),o.$watch("data",function(t,i){if(t&&t.length&&(!Array.isArray(t[0])||t[0].length)){var n=e||o.chartType;if(n){if(w){if(a(t,i))return C(w,t,o,h);w.destroy()}f(n)}}},!0),o.$watch("series",d,!0),o.$watch("labels",d,!0),o.$watch("options",d,!0),o.$watch("colours",d,!0),o.$watch("chartType",function(e,i){y(e)||t.equals(e,i)||(w&&w.destroy(),f(e))}),o.$on("$destroy",function(){w&&w.destroy()})}}}}e.defaults.global.responsive=!0,e.defaults.global.multiTooltipTemplate="<%if (datasetLabel){%><%=datasetLabel%>: <%}%><%= value %>",e.defaults.global.colours=["#97BBCD","#DCDCDC","#F7464A","#46BFBD","#FDB45C","#949FB1","#4D5360"];var s="object"==typeof window.G_vmlCanvasManager&&null!==window.G_vmlCanvasManager&&"function"==typeof window.G_vmlCanvasManager.initElement;return s&&(e.defaults.global.animation=!1),t.module("chart.js",[]).provider("ChartJs",i).factory("ChartJsFactory",["ChartJs","$timeout",n]).directive("chartBase",["ChartJsFactory",function(t){return new t}]).directive("chartLine",["ChartJsFactory",function(t){return new t("Line")}]).directive("chartBar",["ChartJsFactory",function(t){return new t("Bar")}]).directive("chartRadar",["ChartJsFactory",function(t){return new t("Radar")}]).directive("chartDoughnut",["ChartJsFactory",function(t){return new t("Doughnut")}]).directive("chartPie",["ChartJsFactory",function(t){return new t("Pie")}]).directive("chartPolarArea",["ChartJsFactory",function(t){return new t("PolarArea")}])}),function(t,e,i){"use strict";function n(t,e,i){if(!t)throw gt("areq","Argument '{0}' is {1}",e||"?",i||"required");return t}function s(t,e){return t||e?t?e?(X(t)&&(t=t.join(" ")),X(e)&&(e=e.join(" ")),t+" "+e):t:e:""}function a(t){var e={};return t&&(t.to||t.from)&&(e.to=t.to,e.from=t.from),e}function o(t,e,i){var n="";return t=X(t)?t:t&&V(t)&&t.length?t.split(/\s+/):[],q(t,function(t,s){t&&t.length>0&&(n+=s>0?" ":"",n+=i?e+t:t+e)}),n}function r(t,e){var i=t.indexOf(e);e>=0&&t.splice(i,1)}function l(t){if(t instanceof j)switch(t.length){case 0:return[];case 1:if(t[0].nodeType===J)return t;break;default:return j(h(t))}return t.nodeType===J?j(t):void 0}function h(t){if(!t[0])return t;for(var e=0;e<t.length;e++){var i=t[e];if(i.nodeType==J)return i}}function c(t,e,i){q(e,function(e){t.addClass(e,i)})}function u(t,e,i){q(e,function(e){t.removeClass(e,i)})}function d(t){return function(e,i){i.addClass&&(c(t,e,i.addClass),i.addClass=null),i.removeClass&&(u(t,e,i.removeClass),i.removeClass=null)}}function f(t){if(t=t||{},!t.$$prepared){var e=t.domOperation||B;t.domOperation=function(){t.$$domOperationFired=!0,e(),e=B},t.$$prepared=!0}return t}function p(t,e){g(t,e),v(t,e)}function g(t,e){e.from&&(t.css(e.from),e.from=null)}function v(t,e){e.to&&(t.css(e.to),e.to=null)}function m(t,e,i){var n=(e.addClass||"")+" "+(i.addClass||""),s=(e.removeClass||"")+" "+(i.removeClass||""),a=C(t.attr("class"),n,s);i.preparationClasses&&(e.preparationClasses=k(i.preparationClasses,e.preparationClasses),delete i.preparationClasses);var o=e.domOperation!==B?e.domOperation:null;return H(e,i),o&&(e.domOperation=o),a.addClass?e.addClass=a.addClass:e.addClass=null,a.removeClass?e.removeClass=a.removeClass:e.removeClass=null,e}function C(t,e,i){function n(t){V(t)&&(t=t.split(" "));var e={};return q(t,function(t){t.length&&(e[t]=!0)}),e}var s=1,a=-1,o={};t=n(t),e=n(e),q(e,function(t,e){o[e]=s}),i=n(i),q(i,function(t,e){o[e]=o[e]===s?null:a});var r={addClass:"",removeClass:""};return q(o,function(e,i){var n,o;e===s?(n="addClass",o=!t[i]):e===a&&(n="removeClass",o=t[i]),o&&(r[n].length&&(r[n]+=" "),r[n]+=i)}),r}function y(t){return t instanceof e.element?t[0]:t}function b(t,e,i){var n="";e&&(n=o(e,K,!0)),i.addClass&&(n=k(n,o(i.addClass,Q))),i.removeClass&&(n=k(n,o(i.removeClass,Z))),n.length&&(i.preparationClasses=n,t.addClass(n))}function w(t,e){e.preparationClasses&&(t.removeClass(e.preparationClasses),e.preparationClasses=null),e.activeClasses&&(t.removeClass(e.activeClasses),e.activeClasses=null)}function x(t,e){var i=e?"-"+e+"s":"";return P(t,[ft,i]),[ft,i]}function S(t,e){var i=e?"paused":"",n=z+ht;return P(t,[n,i]),[n,i]}function P(t,e){var i=e[0],n=e[1];t.style[i]=n}function k(t,e){return t?e?t+" "+e:t:e}function A(t){return[dt,t+"s"]}function L(t,e){var i=e?ut:ft;return[i,t+"s"]}function $(t,e,i){var n=Object.create(null),s=t.getComputedStyle(e)||{};return q(i,function(t,e){var i=s[t];if(i){var a=i.charAt(0);("-"===a||"+"===a||a>=0)&&(i=F(i)),0===i&&(i=null),n[e]=i}}),n}function F(t){var e=0,i=t.split(/\s*,\s*/);return q(i,function(t){"s"==t.charAt(t.length-1)&&(t=t.substring(0,t.length-1)),t=parseFloat(t)||0,e=e?Math.max(t,e):t}),e}function T(t){return 0===t||null!=t}function R(t,e){var i=O,n=t+"s";return e?i+=st:n+=" linear all",[i,n]}function D(){var t=Object.create(null);return{flush:function(){t=Object.create(null)},count:function(e){var i=t[e];return i?i.total:0},get:function(e){var i=t[e];return i&&i.value},put:function(e,i){t[e]?t[e].total++:t[e]={total:1,value:i}}}}function M(t,e,i){q(i,function(i){t[i]=Y(t[i])?t[i]:e.style.getPropertyValue(i)})}var O,W,z,E,B=e.noop,I=e.copy,H=e.extend,j=e.element,q=e.forEach,X=e.isArray,V=e.isString,G=e.isObject,N=e.isUndefined,Y=e.isDefined,U=e.isFunction,_=e.isElement,J=1,Q="-add",Z="-remove",K="ng-",tt="-active",et="ng-animate",it="$$ngAnimateChildren",nt="";N(t.ontransitionend)&&Y(t.onwebkittransitionend)?(nt="-webkit-",O="WebkitTransition",W="webkitTransitionEnd transitionend"):(O="transition",W="transitionend"),N(t.onanimationend)&&Y(t.onwebkitanimationend)?(nt="-webkit-",z="WebkitAnimation",E="webkitAnimationEnd animationend"):(z="animation",E="animationend");var st="Duration",at="Property",ot="Delay",rt="TimingFunction",lt="IterationCount",ht="PlayState",ct=9999,ut=z+ot,dt=z+st,ft=O+ot,pt=O+st,gt=e.$$minErr("ng"),vt=["$$rAF",function(t){function e(t){n=n.concat(t),i()}function i(){if(n.length){for(var e=n.shift(),a=0;a<e.length;a++)e[a]();s||t(function(){s||i()})}}var n,s;return n=e.queue=[],e.waitUntilQuiet=function(e){s&&s(),s=t(function(){s=null,e(),i()})},e}],mt=[function(){return function(t,i,n){var s=n.ngAnimateChildren;e.isString(s)&&0===s.length?i.data(it,!0):n.$observe("ngAnimateChildren",function(t){t="on"===t||"true"===t,i.data(it,t)})}}],Ct="$$animateCss",yt=1e3,bt=3,wt=1.5,xt={transitionDuration:pt,transitionDelay:ft,transitionProperty:O+at,animationDuration:dt,animationDelay:ut,animationIterationCount:z+lt},St={transitionDuration:pt,transitionDelay:ft,animationDuration:dt,animationDelay:ut},Pt=["$animateProvider",function(t){var e=D(),i=D();this.$get=["$window","$$jqLite","$$AnimateRunner","$timeout","$$forceReflow","$sniffer","$$rAFScheduler","$$animateQueue",function(t,n,s,l,h,c,u,m){function C(t,e){var i="$$ngAnimateParentKey",n=t.parentNode,s=n[i]||(n[i]=++H);return s+"-"+t.getAttribute("class")+"-"+e}function b(i,n,s,a){var o=e.get(s);return o||(o=$(t,i,a),"infinite"===o.animationIterationCount&&(o.animationIterationCount=1)),e.put(s,o),o}function w(s,a,r,l){var h;if(e.count(r)>0&&(h=i.get(r),!h)){var c=o(a,"-stagger");n.addClass(s,c),h=$(t,s,l),h.animationDuration=Math.max(h.animationDuration,0),h.transitionDuration=Math.max(h.transitionDuration,0),n.removeClass(s,c),i.put(r,h)}return h||{}}function k(t){j.push(t),u.waitUntilQuiet(function(){e.flush(),i.flush();for(var t=h(),n=0;n<j.length;n++)j[n](t);j.length=0})}function F(t,e,i){var n=b(t,e,i,xt),s=n.animationDelay,a=n.transitionDelay;return n.maxDelay=s&&a?Math.max(s,a):s||a,n.maxDuration=Math.max(n.animationDuration*n.animationIterationCount,n.transitionDuration),n}var D=d(n),H=0,j=[];return function(t,i){function h(){d()}function u(){d(!0)}function d(e){Y||_&&U||(Y=!0,U=!1,V.$$skipPreparationClasses||n.removeClass(t,xt),n.removeClass(t,kt),S(N,!1),x(N,!1),q(ht,function(t){N.style[t[0]]=""}),D(t,V),p(t,V),Object.keys(G).length&&q(G,function(t,e){
t?N.style.setProperty(e,t):N.style.removeProperty(e)}),V.onDone&&V.onDone(),ft&&ft.length&&t.off(ft.join(" "),H),J&&J.complete(!e))}function b(t){It.blockTransition&&x(N,t),It.blockKeyframeAnimation&&S(N,!!t)}function $(){return J=new s({end:h,cancel:u}),k(B),d(),{$$willAnimate:!1,start:function(){return J},end:h}}function H(t){t.stopPropagation();var e=t.originalEvent||t,i=e.$manualTimeStamp||Date.now(),n=parseFloat(e.elapsedTime.toFixed(bt));Math.max(i-lt,0)>=nt&&n>=st&&(_=!0,d())}function j(){function e(){if(!Y){if(b(!1),q(ht,function(t){var e=t[0],i=t[1];N.style[e]=i}),D(t,V),n.addClass(t,kt),It.recalculateTimingStyles){if(Pt=N.className+" "+xt,$t=C(N,Pt),Et=F(N,Pt,$t),Bt=Et.maxDelay,it=Math.max(Bt,0),st=Et.maxDuration,0===st)return void d();It.hasTransitions=Et.transitionDuration>0,It.hasAnimations=Et.animationDuration>0}if(It.applyAnimationDelay&&(Bt="boolean"!=typeof V.delay&&T(V.delay)?parseFloat(V.delay):Bt,it=Math.max(Bt,0),Et.animationDelay=Bt,Ht=L(Bt,!0),ht.push(Ht),N.style[Ht[0]]=Ht[1]),nt=it*yt,ot=st*yt,V.easing){var e,s=V.easing;It.hasTransitions&&(e=O+rt,ht.push([e,s]),N.style[e]=s),It.hasAnimations&&(e=z+rt,ht.push([e,s]),N.style[e]=s)}Et.transitionDuration&&ft.push(W),Et.animationDuration&&ft.push(E),lt=Date.now();var a=nt+wt*ot,o=lt+a,r=t.data(Ct)||[],h=!0;if(r.length){var c=r[0];h=o>c.expectedEndTime,h?l.cancel(c.timer):r.push(d)}if(h){var u=l(i,a,!1);r[0]={timer:u,expectedEndTime:o},r.push(d),t.data(Ct,r)}ft.length&&t.on(ft.join(" "),H),V.to&&(V.cleanupStyles&&M(G,N,Object.keys(V.to)),v(t,V))}}function i(){var e=t.data(Ct);if(e){for(var i=1;i<e.length;i++)e[i]();t.removeData(Ct)}}if(!Y){if(!N.parentNode)return void d();var s=function(t){if(_)U&&t&&(U=!1,d());else if(U=!t,Et.animationDuration){var e=S(N,U);U?ht.push(e):r(ht,e)}},a=Wt>0&&(Et.transitionDuration&&0===Ft.transitionDuration||Et.animationDuration&&0===Ft.animationDuration)&&Math.max(Ft.animationDelay,Ft.transitionDelay);a?l(e,Math.floor(a*Wt*yt),!1):e(),et.resume=function(){s(!0)},et.pause=function(){s(!1)}}}var V=i||{};V.$$prepared||(V=f(I(V)));var G={},N=y(t);if(!N||!N.parentNode||!m.enabled())return $();var Y,U,_,J,et,it,nt,st,ot,lt,ht=[],ut=t.attr("class"),dt=a(V),ft=[];if(0===V.duration||!c.animations&&!c.transitions)return $();var pt=V.event&&X(V.event)?V.event.join(" "):V.event,gt=pt&&V.structural,vt="",mt="";gt?vt=o(pt,K,!0):pt&&(vt=pt),V.addClass&&(mt+=o(V.addClass,Q)),V.removeClass&&(mt.length&&(mt+=" "),mt+=o(V.removeClass,Z)),V.applyClassesEarly&&mt.length&&D(t,V);var xt=[vt,mt].join(" ").trim(),Pt=ut+" "+xt,kt=o(xt,tt),At=dt.to&&Object.keys(dt.to).length>0,Lt=(V.keyframeStyle||"").length>0;if(!Lt&&!At&&!xt)return $();var $t,Ft;if(V.stagger>0){var Tt=parseFloat(V.stagger);Ft={transitionDelay:Tt,animationDelay:Tt,transitionDuration:0,animationDuration:0}}else $t=C(N,Pt),Ft=w(N,xt,$t,St);V.$$skipPreparationClasses||n.addClass(t,xt);var Rt;if(V.transitionStyle){var Dt=[O,V.transitionStyle];P(N,Dt),ht.push(Dt)}if(V.duration>=0){Rt=N.style[O].length>0;var Mt=R(V.duration,Rt);P(N,Mt),ht.push(Mt)}if(V.keyframeStyle){var Ot=[z,V.keyframeStyle];P(N,Ot),ht.push(Ot)}var Wt=Ft?V.staggerIndex>=0?V.staggerIndex:e.count($t):0,zt=0===Wt;zt&&!V.skipBlocking&&x(N,ct);var Et=F(N,Pt,$t),Bt=Et.maxDelay;it=Math.max(Bt,0),st=Et.maxDuration;var It={};if(It.hasTransitions=Et.transitionDuration>0,It.hasAnimations=Et.animationDuration>0,It.hasTransitionAll=It.hasTransitions&&"all"==Et.transitionProperty,It.applyTransitionDuration=At&&(It.hasTransitions&&!It.hasTransitionAll||It.hasAnimations&&!It.hasTransitions),It.applyAnimationDuration=V.duration&&It.hasAnimations,It.applyTransitionDelay=T(V.delay)&&(It.applyTransitionDuration||It.hasTransitions),It.applyAnimationDelay=T(V.delay)&&It.hasAnimations,It.recalculateTimingStyles=mt.length>0,(It.applyTransitionDuration||It.applyAnimationDuration)&&(st=V.duration?parseFloat(V.duration):st,It.applyTransitionDuration&&(It.hasTransitions=!0,Et.transitionDuration=st,Rt=N.style[O+at].length>0,ht.push(R(st,Rt))),It.applyAnimationDuration&&(It.hasAnimations=!0,Et.animationDuration=st,ht.push(A(st)))),0===st&&!It.recalculateTimingStyles)return $();if(null!=V.delay){var Ht;"boolean"!=typeof V.delay&&(Ht=parseFloat(V.delay),it=Math.max(Ht,0)),It.applyTransitionDelay&&ht.push(L(Ht)),It.applyAnimationDelay&&ht.push(L(Ht,!0))}return null==V.duration&&Et.transitionDuration>0&&(It.recalculateTimingStyles=It.recalculateTimingStyles||zt),nt=it*yt,ot=st*yt,V.skipBlocking||(It.blockTransition=Et.transitionDuration>0,It.blockKeyframeAnimation=Et.animationDuration>0&&Ft.animationDelay>0&&0===Ft.animationDuration),V.from&&(V.cleanupStyles&&M(G,N,Object.keys(V.from)),g(t,V)),It.blockTransition||It.blockKeyframeAnimation?b(st):V.skipBlocking||x(N,!1),{$$willAnimate:!0,end:h,start:function(){return Y?void 0:(et={end:h,cancel:u,resume:null,pause:null},J=new s(et),k(j),J)}}}}]}],kt=["$$animationProvider",function(t){function e(t){return t.parentNode&&11===t.parentNode.nodeType}t.drivers.push("$$animateCssDriver");var i="ng-animate-shim",n="ng-anchor",s="ng-anchor-out",a="ng-anchor-in";this.$get=["$animateCss","$rootScope","$$AnimateRunner","$rootElement","$sniffer","$$jqLite","$document",function(t,o,r,l,h,c,u){function f(t){return t.replace(/\bng-\S+\b/g,"")}function p(t,e){return V(t)&&(t=t.split(" ")),V(e)&&(e=e.split(" ")),t.filter(function(t){return-1===e.indexOf(t)}).join(" ")}function g(e,o,l){function h(t){var e={},i=y(t).getBoundingClientRect();return q(["width","height","top","left"],function(t){var n=i[t];switch(t){case"top":n+=C.scrollTop;break;case"left":n+=C.scrollLeft}e[t]=Math.floor(n)+"px"}),e}function c(){var e=t(v,{addClass:s,delay:!0,from:h(o)});return e.$$willAnimate?e:null}function u(t){return t.attr("class")||""}function d(){var e=f(u(l)),i=p(e,m),n=p(m,e),o=t(v,{to:h(l),addClass:a+" "+i,removeClass:s+" "+n,delay:!0});return o.$$willAnimate?o:null}function g(){v.remove(),o.removeClass(i),l.removeClass(i)}var v=j(y(o).cloneNode(!0)),m=f(u(v));o.addClass(i),l.addClass(i),v.addClass(n),w.append(v);var b,x=c();if(!x&&(b=d(),!b))return g();var S=x||b;return{start:function(){function t(){i&&i.end()}var e,i=S.start();return i.done(function(){return i=null,!b&&(b=d())?(i=b.start(),i.done(function(){i=null,g(),e.complete()}),i):(g(),void e.complete())}),e=new r({end:t,cancel:t})}}}function v(t,e,i,n){var s=m(t,B),a=m(e,B),o=[];return q(n,function(t){var e=t.out,n=t["in"],s=g(i,e,n);s&&o.push(s)}),s||a||0!==o.length?{start:function(){function t(){q(e,function(t){t.end()})}var e=[];s&&e.push(s.start()),a&&e.push(a.start()),q(o,function(t){e.push(t.start())});var i=new r({end:t,cancel:t});return r.all(e,function(t){i.complete(t)}),i}}:void 0}function m(e){var i=e.element,n=e.options||{};e.structural&&(n.event=e.event,n.structural=!0,n.applyClassesEarly=!0,"leave"===e.event&&(n.onDone=n.domOperation)),n.preparationClasses&&(n.event=k(n.event,n.preparationClasses));var s=t(i,n);return s.$$willAnimate?s:null}if(!h.animations&&!h.transitions)return B;var C=u[0].body,b=y(l),w=j(e(b)||C.contains(b)?b:C);d(c);return function(t){return t.from&&t.to?v(t.from,t.to,t.classes,t.anchors):m(t)}}]}],At=["$animateProvider",function(t){this.$get=["$injector","$$AnimateRunner","$$jqLite",function(e,i,n){function s(i){i=X(i)?i:i.split(" ");for(var n=[],s={},a=0;a<i.length;a++){var o=i[a],r=t.$$registeredAnimations[o];r&&!s[o]&&(n.push(e.get(r)),s[o]=!0)}return n}var a=d(n);return function(t,e,n,o){function r(){o.domOperation(),a(t,o)}function l(){d=!0,r(),p(t,o)}function h(t,e,n,s,a){var o;switch(n){case"animate":o=[e,s.from,s.to,a];break;case"setClass":o=[e,m,C,a];break;case"addClass":o=[e,m,a];break;case"removeClass":o=[e,C,a];break;default:o=[e,a]}o.push(s);var r=t.apply(t,o);if(r)if(U(r.start)&&(r=r.start()),r instanceof i)r.done(a);else if(U(r))return r;return B}function c(t,e,n,s,a){var o=[];return q(s,function(s){var r=s[a];r&&o.push(function(){var s,a,o=!1,l=function(t){o||(o=!0,(a||B)(t),s.complete(!t))};return s=new i({end:function(){l()},cancel:function(){l(!0)}}),a=h(r,t,e,n,function(t){var e=t===!1;l(e)}),s})}),o}function u(t,e,n,s,a){var o=c(t,e,n,s,a);if(0===o.length){var r,l;"beforeSetClass"===a?(r=c(t,"removeClass",n,s,"beforeRemoveClass"),l=c(t,"addClass",n,s,"beforeAddClass")):"setClass"===a&&(r=c(t,"removeClass",n,s,"removeClass"),l=c(t,"addClass",n,s,"addClass")),r&&(o=o.concat(r)),l&&(o=o.concat(l))}if(0!==o.length)return function(t){var e=[];return o.length&&q(o,function(t){e.push(t())}),e.length?i.all(e,t):t(),function(t){q(e,function(e){t?e.cancel():e.end()})}}}var d=!1;3===arguments.length&&G(n)&&(o=n,n=null),o=f(o),n||(n=t.attr("class")||"",o.addClass&&(n+=" "+o.addClass),o.removeClass&&(n+=" "+o.removeClass));var g,v,m=o.addClass,C=o.removeClass,y=s(n);if(y.length){var b,w;"leave"==e?(w="leave",b="afterLeave"):(w="before"+e.charAt(0).toUpperCase()+e.substr(1),b=e),"enter"!==e&&"move"!==e&&(g=u(t,e,o,y,w)),v=u(t,e,o,y,b)}if(g||v){var x;return{$$willAnimate:!0,end:function(){return x?x.end():(l(),x=new i,x.complete(!0)),x},start:function(){function t(t){l(t),x.complete(t)}function e(e){d||((n||B)(e),t(e))}if(x)return x;x=new i;var n,s=[];return g&&s.push(function(t){n=g(t)}),s.length?s.push(function(t){r(),t(!0)}):r(),v&&s.push(function(t){n=v(t)}),x.setHost({end:function(){e()},cancel:function(){e(!0)}}),i.chain(s,t),x}}}}}]}],Lt=["$$animationProvider",function(t){t.drivers.push("$$animateJsDriver"),this.$get=["$$animateJs","$$AnimateRunner",function(t,e){function i(e){var i=e.element,n=e.event,s=e.options,a=e.classes;return t(i,n,a,s)}return function(t){if(t.from&&t.to){var n=i(t.from),s=i(t.to);if(!n&&!s)return;return{start:function(){function t(){return function(){q(a,function(t){t.end()})}}function i(t){o.complete(t)}var a=[];n&&a.push(n.start()),s&&a.push(s.start()),e.all(a,i);var o=new e({end:t(),cancel:t()});return o}}}return i(t)}}]}],$t="data-ng-animate",Ft="$ngAnimatePin",Tt=["$animateProvider",function(t){function e(t){if(!t)return null;var e=t.split(c),i=Object.create(null);return q(e,function(t){i[t]=!0}),i}function i(t,i){if(t&&i){var n=e(i);return t.split(c).some(function(t){return n[t]})}}function s(t,e,i,n){return u[t].some(function(t){return t(e,i,n)})}function a(t,e){t=t||{};var i=(t.addClass||"").length>0,n=(t.removeClass||"").length>0;return e?i&&n:i||n}var o=1,r=2,c=" ",u=this.rules={skip:[],cancel:[],join:[]};u.join.push(function(t,e,i){return!e.structural&&a(e.options)}),u.skip.push(function(t,e,i){return!e.structural&&!a(e.options)}),u.skip.push(function(t,e,i){return"leave"==i.event&&e.structural}),u.skip.push(function(t,e,i){return i.structural&&i.state===r&&!e.structural}),u.cancel.push(function(t,e,i){return i.structural&&e.structural}),u.cancel.push(function(t,e,i){return i.state===r&&e.structural}),u.cancel.push(function(t,e,n){var s=e.options.addClass,a=e.options.removeClass,o=n.options.addClass,r=n.options.removeClass;return N(s)&&N(a)||N(o)&&N(r)?!1:i(s,r)||i(a,o)}),this.$get=["$$rAF","$rootScope","$rootElement","$document","$$HashMap","$$animation","$$AnimateRunner","$templateRequest","$$jqLite","$$forceReflow",function(e,i,c,u,g,v,C,x,S,P){function k(){var t=!1;return function(e){t?e():i.$$postDigest(function(){t=!0,e()})}}function A(t,e){return m(t,e,{})}function L(t,e,i){var n=y(e),s=y(t),a=[],o=B[i];return o&&q(o,function(t){K.call(t.node,n)?a.push(t.callback):"leave"===i&&K.call(t.node,s)&&a.push(t.callback)}),a}function $(t,n,h){function c(i,n,s,a){$(function(){var i=L(x,t,n);i.length&&e(function(){q(i,function(e){e(t,s,a)})})}),i.progress(n,s,a)}function d(e){w(t,S),Z(t,S),p(t,S),S.domOperation(),P.complete(!e)}var g,x,S=I(h);t=l(t),t&&(g=y(t),x=t.parent()),S=f(S);var P=new C,$=k();if(X(S.addClass)&&(S.addClass=S.addClass.join(" ")),S.addClass&&!V(S.addClass)&&(S.addClass=null),X(S.removeClass)&&(S.removeClass=S.removeClass.join(" ")),S.removeClass&&!V(S.removeClass)&&(S.removeClass=null),S.from&&!G(S.from)&&(S.from=null),S.to&&!G(S.to)&&(S.to=null),!g)return d(),P;var R=[g.className,S.addClass,S.removeClass].join(" ");if(!Q(R))return d(),P;var E=["enter","move","leave"].indexOf(n)>=0,B=!z||u[0].hidden||W.get(g),H=!B&&O.get(g)||{},j=!!H.state;if(B||j&&H.state==o||(B=!D(t,x,n)),B)return d(),P;E&&F(t);var N={structural:E,element:t,event:n,close:d,options:S,runner:P};if(j){var Y=s("skip",t,N,H);if(Y)return H.state===r?(d(),P):(m(t,H.options,S),H.runner);var U=s("cancel",t,N,H);if(U)if(H.state===r)H.runner.end();else{if(!H.structural)return m(t,H.options,N.options),H.runner;H.close()}else{var _=s("join",t,N,H);if(_){if(H.state!==r)return b(t,E?n:null,S),n=N.event=H.event,S=m(t,H.options,N.options),H.runner;A(t,S)}}}else A(t,S);var J=N.structural;if(J||(J="animate"===N.event&&Object.keys(N.options.to||{}).length>0||a(N.options)),!J)return d(),T(t),P;var K=(H.counter||0)+1;return N.counter=K,M(t,o,N),i.$$postDigest(function(){var e=O.get(g),i=!e;e=e||{};var s=t.parent()||[],o=s.length>0&&("animate"===e.event||e.structural||a(e.options));if(i||e.counter!==K||!o)return i&&(Z(t,S),p(t,S)),(i||E&&e.event!==n)&&(S.domOperation(),P.end()),void(o||T(t));n=!e.structural&&a(e.options,!0)?"setClass":e.event,M(t,r);var l=v(t,n,e.options);l.done(function(e){d(!e);var i=O.get(g);i&&i.counter===K&&T(y(t)),c(P,n,"close",{})}),P.setHost(l),c(P,n,"start",{})}),P}function F(t){var e=y(t),i=e.querySelectorAll("["+$t+"]");q(i,function(t){var e=parseInt(t.getAttribute($t)),i=O.get(t);if(i)switch(e){case r:i.runner.end();case o:O.remove(t)}})}function T(t){var e=y(t);e.removeAttribute($t),O.remove(e)}function R(t,e){return y(t)===y(e)}function D(t,e,i){var n,s=j(u[0].body),a=R(t,s)||"HTML"===t[0].nodeName,o=R(t,c),r=!1,l=W.get(y(t)),h=t.data(Ft);for(h&&(e=h);e&&e.length;){o||(o=R(e,c));var d=e[0];if(d.nodeType!==J)break;var f=O.get(d)||{};if(!r){var p=W.get(d);if(p===!0&&l!==!1){l=!0;break}p===!1&&(l=!1),r=f.structural}if(N(n)||n===!0){var g=e.data(it);Y(g)&&(n=g)}if(r&&n===!1)break;if(a||(a=R(e,s)),a&&o)break;e=o||!(h=e.data(Ft))?e.parent():h}var v=(!r||n)&&l!==!0;return v&&o&&a}function M(t,e,i){i=i||{},i.state=e;var n=y(t);n.setAttribute($t,e);var s=O.get(n),a=s?H(s,i):i;O.put(n,a)}var O=new g,W=new g,z=null,E=i.$watch(function(){return 0===x.totalPendingRequests},function(t){t&&(E(),i.$$postDigest(function(){i.$$postDigest(function(){null===z&&(z=!0)})}))}),B={},U=t.classNameFilter(),Q=U?function(t){return U.test(t)}:function(){return!0},Z=d(S),K=Node.prototype.contains||function(t){return this===t||!!(16&this.compareDocumentPosition(t))};return{on:function(t,e,i){var n=h(e);B[t]=B[t]||[],B[t].push({node:n,callback:i})},off:function(t,e,i){function n(t,e,i){var n=h(e);return t.filter(function(t){var e=t.node===n&&(!i||t.callback===i);return!e})}var s=B[t];s&&(B[t]=1===arguments.length?null:n(s,e,i))},pin:function(t,e){n(_(t),"element","not an element"),n(_(e),"parentElement","not an element"),t.data(Ft,e)},push:function(t,e,i,n){return i=i||{},i.domOperation=n,$(t,e,i)},enabled:function(t,e){var i=arguments.length;if(0===i)e=!!z;else{var n=_(t);if(n){var s=y(t),a=W.get(s);1===i?e=!a:W.put(s,!e)}else e=z=!!t}return e}}}]}],Rt=["$animateProvider",function(t){function e(t,e){t.data(r,e)}function i(t){t.removeData(r)}function n(t){return t.data(r)}var a="ng-animate-ref",o=this.drivers=[],r="$$animationRunner";this.$get=["$$jqLite","$rootScope","$injector","$$AnimateRunner","$$HashMap","$$rAFScheduler",function(t,r,l,h,c,u){function g(t){function e(t){if(t.processed)return t;t.processed=!0;var i=t.domNode,n=i.parentNode;a.put(i,t);for(var o;n;){if(o=a.get(n)){o.processed||(o=e(o));break}n=n.parentNode}return(o||s).children.push(t),t}function i(t){var e,i=[],n=[];for(e=0;e<t.children.length;e++)n.push(t.children[e]);var s=n.length,a=0,o=[];for(e=0;e<n.length;e++){var r=n[e];0>=s&&(s=a,a=0,i.push(o),o=[]),o.push(r.fn),r.children.forEach(function(t){a++,n.push(t)}),s--}return o.length&&i.push(o),i}var n,s={children:[]},a=new c;for(n=0;n<t.length;n++){var o=t[n];a.put(o.domNode,t[n]={domNode:o.domNode,fn:o.fn,children:[]})}for(n=0;n<t.length;n++)e(t[n]);return i(s)}var v=[],m=d(t);return function(c,d,C){function b(t){var e="["+a+"]",i=t.hasAttribute(a)?[t]:t.querySelectorAll(e),n=[];return q(i,function(t){var e=t.getAttribute(a);e&&e.length&&n.push(t)}),n}function w(t){var e=[],i={};q(t,function(t,n){var s=t.element,o=y(s),r=t.event,l=["enter","move"].indexOf(r)>=0,h=t.structural?b(o):[];if(h.length){var c=l?"to":"from";q(h,function(t){var e=t.getAttribute(a);i[e]=i[e]||{},i[e][c]={animationID:n,element:j(t)}})}else e.push(t)});var n={},s={};return q(i,function(i,a){var o=i.from,r=i.to;if(!o||!r){var l=o?o.animationID:r.animationID,h=l.toString();return void(n[h]||(n[h]=!0,e.push(t[l])))}var c=t[o.animationID],u=t[r.animationID],d=o.animationID.toString();if(!s[d]){var f=s[d]={structural:!0,beforeStart:function(){c.beforeStart(),u.beforeStart()},close:function(){c.close(),u.close()},classes:x(c.classes,u.classes),from:c,to:u,anchors:[]};f.classes.length?e.push(f):(e.push(c),e.push(u))}s[d].anchors.push({out:o.element,"in":r.element})}),e}function x(t,e){t=t.split(" "),e=e.split(" ");for(var i=[],n=0;n<t.length;n++){var s=t[n];if("ng-"!==s.substring(0,3))for(var a=0;a<e.length;a++)if(s===e[a]){i.push(s);break}}return i.join(" ")}function S(t){for(var e=o.length-1;e>=0;e--){var i=o[e];if(l.has(i)){var n=l.get(i),s=n(t);if(s)return s}}}function P(){c.addClass(et),R&&t.addClass(c,R)}function k(t,e){function i(t){n(t).setHost(e)}t.from&&t.to?(i(t.from.element),i(t.to.element)):i(t.element)}function A(){var t=n(c);!t||"leave"===d&&C.$$domOperationFired||t.end()}function L(e){c.off("$destroy",A),i(c),m(c,C),p(c,C),C.domOperation(),R&&t.removeClass(c,R),c.removeClass(et),F.complete(!e)}C=f(C);var $=["enter","move","leave"].indexOf(d)>=0,F=new h({end:function(){L()},cancel:function(){L(!0)}});if(!o.length)return L(),F;e(c,F);var T=s(c.attr("class"),s(C.addClass,C.removeClass)),R=C.tempClasses;return R&&(T+=" "+R,C.tempClasses=null),v.push({element:c,classes:T,event:d,structural:$,options:C,beforeStart:P,close:L}),c.on("$destroy",A),v.length>1?F:(r.$$postDigest(function(){var t=[];q(v,function(e){n(e.element)?t.push(e):e.close()}),v.length=0;var e=w(t),i=[];q(e,function(t){i.push({domNode:y(t.from?t.from.element:t.element),fn:function(){t.beforeStart();var e,i=t.close,s=t.anchors?t.from.element||t.to.element:t.element;if(n(s)){var a=S(t);a&&(e=a.start)}if(e){var o=e();o.done(function(t){i(!t)}),k(t,o)}else i()}})}),u(g(i))}),F)}}]}];e.module("ngAnimate",[]).directive("ngAnimateChildren",mt).factory("$$rAFScheduler",vt).provider("$$animateQueue",Tt).provider("$$animation",Rt).provider("$animateCss",Pt).provider("$$animateCssDriver",kt).provider("$$animateJs",At).provider("$$animateJsDriver",Lt)}(window,window.angular),angular.module("ui.bootstrap.accordion",["ui.bootstrap.collapse"]).constant("uibAccordionConfig",{closeOthers:!0}).controller("UibAccordionController",["$scope","$attrs","uibAccordionConfig",function(t,e,i){this.groups=[],this.closeOthers=function(n){var s=angular.isDefined(e.closeOthers)?t.$eval(e.closeOthers):i.closeOthers;s&&angular.forEach(this.groups,function(t){t!==n&&(t.isOpen=!1)})},this.addGroup=function(t){var e=this;this.groups.push(t),t.$on("$destroy",function(i){e.removeGroup(t)})},this.removeGroup=function(t){var e=this.groups.indexOf(t);-1!==e&&this.groups.splice(e,1)}}]).directive("uibAccordion",function(){return{controller:"UibAccordionController",controllerAs:"accordion",transclude:!0,templateUrl:function(t,e){return e.templateUrl||"template/accordion/accordion.html"}}}).directive("uibAccordionGroup",function(){return{require:"^uibAccordion",transclude:!0,replace:!0,templateUrl:function(t,e){return e.templateUrl||"template/accordion/accordion-group.html"},scope:{heading:"@",isOpen:"=?",isDisabled:"=?"},controller:function(){this.setHeading=function(t){this.heading=t}},link:function(t,e,i,n){n.addGroup(t),t.openClass=i.openClass||"panel-open",t.panelClass=i.panelClass,t.$watch("isOpen",function(i){e.toggleClass(t.openClass,!!i),i&&n.closeOthers(t)}),t.toggleOpen=function(e){t.isDisabled||e&&32!==e.which||(t.isOpen=!t.isOpen)}}}}).directive("uibAccordionHeading",function(){return{transclude:!0,template:"",replace:!0,require:"^uibAccordionGroup",link:function(t,e,i,n,s){n.setHeading(s(t,angular.noop))}}}).directive("uibAccordionTransclude",function(){return{require:["?^uibAccordionGroup","?^accordionGroup"],link:function(t,e,i,n){n=n[0]?n[0]:n[1],t.$watch(function(){return n[i.uibAccordionTransclude]},function(t){t&&(e.find("span").html(""),e.find("span").append(t))})}}}),angular.module("ui.bootstrap.accordion").value("$accordionSuppressWarning",!1).controller("AccordionController",["$scope","$attrs","$controller","$log","$accordionSuppressWarning",function(t,e,i,n,s){s||n.warn("AccordionController is now deprecated. Use UibAccordionController instead."),angular.extend(this,i("UibAccordionController",{$scope:t,$attrs:e}))}]).directive("accordion",["$log","$accordionSuppressWarning",function(t,e){return{restrict:"EA",controller:"AccordionController",controllerAs:"accordion",transclude:!0,replace:!1,templateUrl:function(t,e){return e.templateUrl||"template/accordion/accordion.html"},link:function(){e||t.warn("accordion is now deprecated. Use uib-accordion instead.")}}}]).directive("accordionGroup",["$log","$accordionSuppressWarning",function(t,e){return{require:"^accordion",restrict:"EA",transclude:!0,replace:!0,templateUrl:function(t,e){return e.templateUrl||"template/accordion/accordion-group.html"},scope:{heading:"@",isOpen:"=?",isDisabled:"=?"},controller:function(){this.setHeading=function(t){this.heading=t}},link:function(i,n,s,a){e||t.warn("accordion-group is now deprecated. Use uib-accordion-group instead."),a.addGroup(i),i.openClass=s.openClass||"panel-open",i.panelClass=s.panelClass,i.$watch("isOpen",function(t){n.toggleClass(i.openClass,!!t),t&&a.closeOthers(i)}),i.toggleOpen=function(t){i.isDisabled||t&&32!==t.which||(i.isOpen=!i.isOpen)}}}}]).directive("accordionHeading",["$log","$accordionSuppressWarning",function(t,e){return{restrict:"EA",transclude:!0,template:"",replace:!0,require:"^accordionGroup",link:function(i,n,s,a,o){e||t.warn("accordion-heading is now deprecated. Use uib-accordion-heading instead."),a.setHeading(o(i,angular.noop))}}}]).directive("accordionTransclude",["$log","$accordionSuppressWarning",function(t,e){return{require:"^accordionGroup",link:function(i,n,s,a){e||t.warn("accordion-transclude is now deprecated. Use uib-accordion-transclude instead."),i.$watch(function(){return a[s.accordionTransclude]},function(t){t&&(n.find("span").html(""),n.find("span").append(t))})}}}]),angular.module("ui.bootstrap.collapse",[]).directive("uibCollapse",["$animate","$injector",function(t,e){var i=e.has("$animateCss")?e.get("$animateCss"):null;return{link:function(e,n,s){function a(){n.removeClass("collapse").addClass("collapsing").attr("aria-expanded",!0).attr("aria-hidden",!1),i?i(n,{addClass:"in",easing:"ease",to:{height:n[0].scrollHeight+"px"}}).start()["finally"](o):t.addClass(n,"in",{to:{height:n[0].scrollHeight+"px"}}).then(o)}function o(){n.removeClass("collapsing").addClass("collapse").css({height:"auto"})}function r(){return n.hasClass("collapse")||n.hasClass("in")?(n.css({height:n[0].scrollHeight+"px"}).removeClass("collapse").addClass("collapsing").attr("aria-expanded",!1).attr("aria-hidden",!0),void(i?i(n,{removeClass:"in",to:{height:"0"}}).start()["finally"](l):t.removeClass(n,"in",{to:{height:"0"}}).then(l))):l()}function l(){n.css({height:"0"}),n.removeClass("collapsing").addClass("collapse")}e.$watch(s.uibCollapse,function(t){t?r():a()})}}}]),angular.module("ui.bootstrap.collapse").value("$collapseSuppressWarning",!1).directive("collapse",["$animate","$injector","$log","$collapseSuppressWarning",function(t,e,i,n){var s=e.has("$animateCss")?e.get("$animateCss"):null;return{link:function(e,a,o){function r(){a.removeClass("collapse").addClass("collapsing").attr("aria-expanded",!0).attr("aria-hidden",!1),s?s(a,{easing:"ease",to:{height:a[0].scrollHeight+"px"}}).start().done(l):t.animate(a,{},{height:a[0].scrollHeight+"px"}).then(l)}function l(){a.removeClass("collapsing").addClass("collapse in").css({height:"auto"})}function h(){return a.hasClass("collapse")||a.hasClass("in")?(a.css({height:a[0].scrollHeight+"px"}).removeClass("collapse in").addClass("collapsing").attr("aria-expanded",!1).attr("aria-hidden",!0),void(s?s(a,{to:{height:"0"}}).start().done(c):t.animate(a,{},{height:"0"}).then(c))):c()}function c(){a.css({height:"0"}),a.removeClass("collapsing").addClass("collapse")}n||i.warn("collapse is now deprecated. Use uib-collapse instead."),e.$watch(o.collapse,function(t){t?h():r()})}}}]);