# Security Policies

XOS provides hooks for specifying security policies. These policies
answer the question: *Who can do what?* The *who* in this case
generally refers to a user (represented by a *User* model), but it can
also refer to an API context. The
*what* refers to two things: (1) the piece of information being accessed (a
model, an object, or a field within that object), and (2) the access type
(whether it is a read, a write, or a privilege update).

The mechanism for expressing these policies is provided by xproto’s policy
extensions. The policies are enforced at the API boundary. When an API call is
made, the appropriate policy is executed to determine whether or not access
should be granted, and an audit trail is left behind. The policy enforcers are
auto-generated by the generative toolchain as part of the model generation
process.

> **Note:** Auditing is still todo.

Policies are generic logic expressions and can operate on any model or on the
environment, but they frequently use the *Privilege* model.  Specifically, when
a policy cannot be expressed as a general principle (e.g., “a user can do
whatever they want to a slice if he or she is its creator”) and instead depends
on dynamic conditions, then it is encoded with the help of Privilege objects.
For example, a Privilege object may be created to indicate that a user who is
not a slice’s creator has admin privileges on it.

The set of security policies is being bootstrapped into the following state:

* Privilege objects are automatically created for Slices. Most access control
  (e.g., to Networks and Instances) is via Slice, so this privilege covers the
  bulk of the access control.

* Privileges for other models need to be created manually via the API (e.g.,
  Sites, Services).

* Any principal that has access to object *X* is also granted access to object
  *ControllerX*.

* There are three types of access permissions: *Read*, *Write*, and *Grant*.
  Grant arbitrates access to Privilege objects (e.g., a slice admin could grant
  slice admin privileges to a user).

The current policies are defined in
[core.xproto](https://github.com/opencord/xos/blob/master/xos/core/models/core.xproto).

For example, the following `site_policy` controls access to instances of the
`Site` model:

```python
// Everyone has read access
// For write access, you have to be a site_admin
policy site_policy <
         ctx.user.is_admin
         | (ctx.write_access -> exists Privilege:
     Privilege.object_type = "Site" & Privilege.object_id = obj.id
     & Privilege.accessor_id = ctx.user.id & Privilege.permission
     = "role:admin") >
```

For more information about security policy definitions, read about
[xproto and xosgenx](dev/xproto.md).

