//Autogenerated, do not edit!!!
'use strict';

angular.module('xos.mcordTopology', ['ngResource', 'ngCookies', 'ngLodash', 'ui.router', 'xos.helpers']).config(["$stateProvider", function ($stateProvider) {
  $stateProvider.state('topology', {
    url: '/',
    template: '<m-cord-topology></m-cord-topology>'
  });
}]).config(["$httpProvider", function ($httpProvider) {
  $httpProvider.interceptors.push('NoHyperlinks');
}]).directive('mCordTopology', function () {
  return {
    restrict: 'E',
    scope: {},
    bindToController: true,
    controllerAs: 'vm',
    template: '',
    controller: ["$element", "$interval", "XosApi", "lodash", "TopologyElements", "NodeDrawer", function controller($element, $interval, XosApi, lodash, TopologyElements, NodeDrawer) {

      var el = $element[0];

      var nodes = [];
      var links = [];

      var filterBBU = function filterBBU(instances) {
        return lodash.filter(instances, function (i) {
          return i.name.indexOf('BBU') >= 0;
        });
      };

      var filterOthers = function filterOthers(instances) {
        return lodash.filter(instances, function (i) {
          return i.name.indexOf('MME') >= 0 || i.name.indexOf('SGW') >= 0 || i.name.indexOf('PGW') >= 0;
        });
      };

      // retrieving instances list
      var getData = function getData() {

        nodes = TopologyElements.nodes;
        links = TopologyElements.links;

        XosApi.Instance_List_GET().then(function (instances) {
          addBbuNodes(filterBBU(instances));
          addOtherNodes(filterOthers(instances));

          draw(svg, nodes, links);
        })['catch'](function (e) {
          throw new Error(e);
        });
      };

      var force = d3.layout.force();

      // create svg elements
      var svg = d3.select(el).append('svg').style('width', el.clientWidth + 'px').style('height', el.clientHeight + 'px');

      var linkContainer = svg.append('g').attr({
        'class': 'link-container'
      });

      var nodeContainer = svg.append('g').attr({
        'class': 'node-container'
      });

      // replace human readable ids with d3 ids
      // NOTE now ids are not manatined on update...
      var buildLinks = function buildLinks(links, nodes) {
        return links.map(function (l) {

          var source = lodash.findIndex(nodes, { id: l.source });
          var target = lodash.findIndex(nodes, { id: l.target });
          // console.log(`link-${source}-${target}`, source, target);
          return {
            source: source,
            target: target,
            value: 1,
            id: 'link-' + source + '-' + target,
            type: l.source.indexOf('fabric') >= 0 ? 'big' : 'small'
          };
        });
      };

      // find fabric nodes and center horizontally
      var positionFabricNodes = function positionFabricNodes(nodes) {
        return lodash.map(nodes, function (n) {
          if (n.type !== 'fabric') {
            return n;
          }

          n.x = n.x * hStep;
          n.y = n.y * vStep;

          return n;
        });
      };

      var addBbuNodes = function addBbuNodes(instances) {

        // calculate bbu hStep
        var bbuHStep = el.clientWidth / 2 / (instances.length + 1);

        // create nodes
        var bbuNodes = instances.map(function (n, i) {
          return {
            type: 'bbu',
            name: n.name,
            id: 'bbu-' + n.id,
            fixed: true,
            y: vStep * 3,
            x: bbuHStep * (i + 1)
          };
        });

        // create links
        var bbuLinks = bbuNodes.map(function (n) {
          return {
            source: n.id,
            target: 'fabric2'
          };
        });

        // fake RRU nodes and links
        instances.forEach(function (n, i) {
          bbuNodes.push({
            type: 'rru',
            name: 'rru',
            id: 'rru-' + n.id,
            fixed: true,
            y: vStep * 4,
            x: bbuHStep * (i + 1)
          });

          bbuLinks.push({
            source: 'rru-' + n.id,
            target: 'bbu-' + n.id
          });
        });

        nodes = nodes.concat(bbuNodes);

        links = links.concat(bbuLinks);
      };

      // add MME, PGW, SGW nodes
      var addOtherNodes = function addOtherNodes(instances) {
        var hStep = el.clientWidth / 2 / (instances.length + 1);

        // create nodes
        var otherNodes = instances.map(function (n, i) {
          return {
            type: n.name.substring(0, 3),
            name: n.name,
            id: n.name.substring(0, 3) + '-' + n.id,
            fixed: true,
            y: vStep * 3,
            x: el.clientWidth / 2 + hStep * (i + 1)
          };
        });

        // create links
        var otherLinks = otherNodes.map(function (n) {
          return {
            source: n.id,
            target: 'fabric4'
          };
        });

        nodes = nodes.concat(otherNodes);
        links = links.concat(otherLinks);
      };

      var hStep = undefined,
          vStep = undefined;

      hStep = el.clientWidth / 3;
      vStep = el.clientHeight / 5;

      var draw = function draw(svg, nodes, links) {

        hStep = el.clientWidth / 3;
        vStep = el.clientHeight / 5;

        links = buildLinks(links, nodes);

        nodes = positionFabricNodes(nodes);

        // start force layout
        force.nodes(nodes).links(links).size([el.clientWidth, el.clientHeight]).charge(-20).chargeDistance(200).linkDistance(80).linkStrength(0.1).start();

        var linkContainer = d3.select('.link-container');
        var nodeContainer = d3.select('.node-container');

        NodeDrawer.drawFabricBox(nodeContainer, hStep, vStep);

        // draw links
        var link = linkContainer.selectAll('.link').data(links, function (d) {
          return d.id;
        });

        link.enter().append('line').attr({
          // class: 'link',
          id: function id(d) {
            return d.id;
          },
          opacity: 0,
          'class': function _class(d) {
            return 'link ' + d.type;
          }
        }).transition().duration(1000)
        // .delay((d, i) => 50 * i)
        .attr({
          opacity: 1
        });

        link.exit().remove();

        //draw nodes
        var node = nodeContainer.selectAll('.node').data(nodes, function (d) {
          return d.id;
        });

        // append a group for any new node
        var enter = node.enter().append('g', function (d) {
          return d.interfaceCfgIdentifier;
        }).attr({
          'class': function _class(d) {
            return d.type + ' node';
          },
          transform: function transform(d) {
            return 'translate(' + d.x + ', ' + d.y + ')';
          }
        });

        // draw nodes
        NodeDrawer.drawBbus(enter.filter('.bbu'));
        NodeDrawer.drawRrus(enter.filter('.rru'));
        NodeDrawer.drawFabric(enter.filter('.fabric'));
        NodeDrawer.drawOthers(enter.filter(function (d) {
          return d.type === 'MME' || d.type === 'SGW' || d.type === 'PGW';
        }));

        // remove nodes
        var exit = node.exit();

        NodeDrawer.removeElements(exit);

        force.on('tick', function () {
          link.attr('x1', function (d) {
            return d.source.x;
          }).attr('y1', function (d) {
            return d.source.y;
          }).attr('x2', function (d) {
            return d.target.x;
          }).attr('y2', function (d) {
            return d.target.y;
          });

          node.attr('transform', function (d) {
            return 'translate(' + d.x + ',' + d.y + ')';
          });
        });
      };

      $interval(function () {
        getData();
      }, 5000);
      getData();
    }]
  };
});
'use strict';

angular.module('xos.mcordTopology').constant('TopologyElements', {
  nodes: [{
    id: 'fabric1',
    type: 'fabric',
    name: 'fabric1',
    fixed: true,
    x: 1,
    y: 1
  }, {
    id: 'fabric2',
    type: 'fabric',
    name: 'fabric2',
    fixed: true,
    x: 1,
    y: 2
  }, {
    id: 'fabric3',
    type: 'fabric',
    name: 'fabric3',
    fixed: true,
    x: 2,
    y: 1
  }, {
    id: 'fabric4',
    type: 'fabric',
    name: 'fabric4',
    fixed: true,
    x: 2,
    y: 2
  }],
  links: [{
    source: 'fabric1',
    target: 'fabric2'
  }, {
    source: 'fabric1',
    target: 'fabric4'
  }, {
    source: 'fabric3',
    target: 'fabric4'
  }, {
    source: 'fabric3',
    target: 'fabric2'
  }],
  icons: {
    bbu: 'M15,100a5,5,0,0,1-5-5v-65a5,5,0,0,1,5-5h80a5,5,0,0,1,5,5v65a5,5,0,0,1-5,5zM14,22.5l11-11a10,3,0,0,1,10-2h40a10,3,0,0,1,10,2l11,11zM16,35a5,5,0,0,1,10,0a5,5,0,0,1-10,0z',
    'switch': 'M10,20a10,10,0,0,1,10-10h70a10,10,0,0,1,10,10v70a10,10,\n            0,0,1-10,10h-70a10,10,0,0,1-10-10zM60,26l12,0,0-8,18,13-18,13,0\n            -8-12,0zM60,60l12,0,0-8,18,13-18,13,0-8-12,0zM50,40l-12,0,0-8\n            -18,13,18,13,0-8,12,0zM50,74l-12,0,0-8-18,13,18,13,0-8,12,0z',
    rru: 'M85,71.2c-8.9,10.5-29.6,8.7-45.3-3.5C23.9,55.4,19.8,37,28.6,26.5C29.9,38.6,71.5,69.9,85,71.2z M92.7,76.2M16.2,15 M69.5,100.7v-4c0-1.4-1.2-2.2-2.6-2.2H19.3c-1.4,0-2.8,0.7-2.8,2.2v3.9c0,0.7,0.8,1,1.5,1h50.3C69,101.5,69.5,101.3,69.5,100.7z M77.3,7.5l0,3.7c9,0.1,16.3,7.1,16.2,15.7l3.9,0C97.5,16.3,88.5,7.6,77.3,7.5z M77.6,14.7l0,2.5c5.3,0,9.7,4.2,9.6,9.3l2.6,0C89.9,20,84.4,14.7,77.6,14.7z M82.3,22.2c-1.3-1.2-2.9-1.9-4.7-1.9l0,1.2c1.4,0,2.8,0.6,3.8,1.5c1,1,1.6,2.3,1.6,3.7l1.3,0C84.3,25.1,83.6,23.4,82.3,22.2z M38.9,69.5l-5.1,23h16.5l-2.5-17.2C44.1,73.3,38.9,69.5,38.9,69.5zM58.1,54.1c13.7,10.1,26.5,16.8,29.2,13.7c2.7-3.1-5.6-13-19.3-24.4 M62.9,34.2 M62,37.9C47.7,27.3,33.7,20,31,23.1c-2.7,3.2,7,14.2,20.6,26 M73.9,25.7c-2.9,0.1-5.2,2.3-5.1,4.8c0,0.7,0.2,1.4,0.6,2l0,0L53.8,49.7l3.3,2.5L72.7,35l-0.4-0.3c0.6,0.2,1.3,0.3,1.9,0.3c2.9-0.1,5.2-2.3,5.1-4.9C79.3,27.6,76.8,25.6,73.9,25.7z'
  }
});
'use strict';

angular.module('xos.mcordTopology').service('NodeDrawer', ["TopologyElements", function (TopologyElements) {

  var duration = 500;

  var isFabricDrawed = false;

  this.drawFabricBox = function (svg, hStep, vStep) {

    if (isFabricDrawed) {
      return;
    }

    var fabric = svg.append('g').attr({
      transform: 'translate(' + (hStep - 25) + ', ' + (vStep - 25) + ')'
    });

    fabric.append('rect').attr({
      width: hStep + 50,
      height: vStep + 50,
      'class': 'fabric-container'
    });

    fabric.append('text').text('Fabric').attr({
      'text-anchor': 'middle',
      x: (hStep + 50) / 2,
      y: -10
    });

    isFabricDrawed = true;
  };

  this.drawBbus = function (nodes) {

    // nodes.append('circle')
    //   .attr({
    //     class: d => d.type,
    //     r: 0,
    //     opacity: 0
    //   })
    //   .transition()
    //   .duration(duration)
    //   // .delay((d, i) => i * (duration / 2))
    //   .attr({
    //     r: 15,
    //     opacity: 1
    //   });
    nodes.append('path').attr({
      'class': function _class(d) {
        return d.type + ' antenna';
      },
      opacity: 0,
      d: function d() {
        return TopologyElements.icons.bbu;
      },
      transform: 'translate(-22, -22), scale(0.4)'
    }).transition().duration(duration).attr({
      opacity: 1
    });

    nodes.append('text').attr({
      'text-anchor': 'start',
      y: 13,
      x: -14,
      opacity: 0
    }).text(function (d) {
      return 'BBU ' + d.name.substr(d.name.length - 1, 1);
    }).transition().duration(duration * 2).attr({
      opacity: 1
    });
  };

  this.drawRrus = function (nodes) {

    nodes.append('circle').attr({
      'class': function _class(d) {
        return d.type + '-shadow';
      },
      r: 0,
      opacity: 0
    }).transition().duration(duration * 2)
    // .delay((d, i) => i * (duration / 2))
    .attr({
      r: 40,
      opacity: 1
    });

    nodes.append('path').attr({
      'class': function _class(d) {
        return d.type + ' antenna';
      },
      opacity: 0,
      d: function d() {
        return TopologyElements.icons.rru;
      },
      transform: 'translate(-22, -22), scale(0.4)'
    }).transition().duration(duration).attr({
      opacity: 1
    });

    // nodes.append('circle')
    //   .attr({
    //     class: d => d.type,
    //     r: 0,
    //     opacity: 0
    //   })
    //   .transition()
    //   .duration(duration)
    //   // .delay((d, i) => i * (duration / 2))
    //   .attr({
    //     r: 10,
    //     opacity: 1
    //   });
  };

  this.drawFabric = function (nodes) {
    nodes.append('rect').attr({
      width: 30,
      height: 30,
      x: -15,
      y: -15
    });

    nodes.append('path').attr({
      'class': function _class(d) {
        return d.type;
      },
      opacity: 0,
      d: function d() {
        return TopologyElements.icons['switch'];
      },
      transform: 'translate(-22, -22), scale(0.4)'
    }).transition().duration(duration)
    // .delay((d, i) => i * (duration / 2))
    .attr({
      opacity: 1
    });
  };

  this.drawOthers = function (nodes) {
    // nodes.append('circle')
    //   .attr({
    //     class: d => d.type,
    //     r: 0,
    //     opacity: 0
    //   })
    //   .transition()
    //   .duration(duration)
    //   // .delay((d, i) => i * (duration / 2))
    //   .attr({
    //     r: 15,
    //     opacity: 1
    //   });
    nodes.append('path').attr({
      'class': function _class(d) {
        return d.type + ' antenna';
      },
      opacity: 0,
      d: function d() {
        return TopologyElements.icons.bbu;
      },
      transform: 'translate(-22, -22), scale(0.4)'
    }).transition().duration(duration).attr({
      opacity: 1
    });

    nodes.append('text').attr({
      'text-anchor': 'start',
      y: 13,
      x: -12,
      opacity: 0
    }).text(function (d) {
      return d.type;
    }).transition().duration(duration * 2).attr({
      opacity: 1
    });
  };

  this.removeElements = function (nodes) {
    nodes.transition().duration(duration).attr({
      opacity: 0
    }).remove();
  };
}]);
angular.module('xos.mcordTopology').run(function($location){$location.path('/')});
angular.bootstrap(angular.element('#xosMcordTopology'), ['xos.mcordTopology']);