/* This is an example that uses xoslib + datatables to display the developer

   view.


   For an example that uses xoslib + marionette, see xosDeveloper.js

*/


function updateSliceTable(data) {

    $('#developerView').html( '<table cellpadding="0" cellspacing="0" border="0" class="display" id="dynamicusersliceinfo"></table>' );
    var actualEntries = [];

    for (rowkey in data.models) {
        row = data.models[rowkey];
        slicename = row.get("name");
        sliceid = row.get("id");
        role = row.get("sliceInfo").roles[0] || "";
        slivercount = row.get("sliceInfo").sliverCount;
        sitecount = row.get("sliceInfo").siteCount;
        backendHtml = row.get("backendHtml")

        //if (! role) {
        //    continue;
        //}

        if (! row.get("current_user_can_see") ) {
            continue;
        }

        actualEntries.push([backendHtml + ' <a href="/admin/core/slice/' + sliceid + '">' + slicename + '</a>',
                            role, slivercount, sitecount]);
    }
    oTable = $('#dynamicusersliceinfo').dataTable( {
        "bJQueryUI": true,
        "aaData":  actualEntries ,
        "bStateSave": true,
        "aoColumns": [
            { "sTitle": "Slice" },
            { "sTitle": "Privilege" , sClass: "alignCenter"},
            { "sTitle": "Number of Slivers" , sClass: "alignCenter"},
            { "sTitle": "Number of Sites" , sClass: "alignCenter"},
        ]
    } );
}

$(document).ready(function(){
    xos.slicesPlus.on("change", function() { /*console.log("change");*/ updateSliceTable(xos.slicesPlus); });
    xos.slicesPlus.on("remove", function() { /*console.log("sort");*/ updateSliceTable(xos.slicesPlus); });
    xos.slicesPlus.on("sort", function() { /*console.log("sort");*/ updateSliceTable(xos.slicesPlus); });

    xos.slicesPlus.startPolling();
});

