# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2019-03-07 17:27
from __future__ import unicode_literals

import core.models.xosbase_header
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0006_auto_20190304_2346'),
    ]

    operations = [
        migrations.AlterField(
            model_name='addresspool_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='cidr',
            field=models.CharField(help_text=b'Subnet for this AddressPool', max_length=32),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='gateway_ip',
            field=models.CharField(help_text=b'Gateway IP address for this AddressPool', max_length=32),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='gateway_mac',
            field=models.CharField(help_text=b'Gateway MAC address for this AddressPool', max_length=32),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='flavor_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='flavor_decl',
            name='flavor',
            field=core.models.xosbase_header.StrippedCharField(help_text=b'flavor string used to configure deployments', max_length=32),
        ),
        migrations.AlterField(
            model_name='flavor_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='flavor_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='image_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='image_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='image_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='interfacetype_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='interfacetype_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='interfacetype_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='network_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='network_decl',
            name='end_ip',
            field=models.CharField(blank=True, max_length=32, null=True),
        ),
        migrations.AlterField(
            model_name='network_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='network_decl',
            name='start_ip',
            field=models.CharField(blank=True, max_length=32, null=True),
        ),
        migrations.AlterField(
            model_name='network_decl',
            name='subnet',
            field=models.CharField(blank=True, max_length=32, null=True),
        ),
        migrations.AlterField(
            model_name='network_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='networkparameter_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkparameter_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkparameter_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='networkparametertype_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkparametertype_decl',
            name='description',
            field=models.CharField(blank=True, max_length=1024, null=True),
        ),
        migrations.AlterField(
            model_name='networkparametertype_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkparametertype_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='networkslice_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkslice_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkslice_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='networktemplate_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networktemplate_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networktemplate_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='node_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='node_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='node_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='nodelabel_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='nodelabel_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='nodelabel_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='port_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='port_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='port_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='principal_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='principal_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='principal_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='privilege_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='privilege_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='privilege_decl',
            name='permission',
            field=models.CharField(default=b'all', max_length=1024),
        ),
        migrations.AlterField(
            model_name='privilege_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='role_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='role_decl',
            name='description',
            field=core.models.xosbase_header.StrippedCharField(blank=True, max_length=120, null=True),
        ),
        migrations.AlterField(
            model_name='role_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='role_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='service_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='service_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='service_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceattribute_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceattribute_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceattribute_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='servicedependency_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicedependency_decl',
            name='connect_method',
            field=models.CharField(choices=[(b'none', b'None'), (b'private', b'Private'), (b'public', b'Public')], default=b'none', help_text=b'method to connect the two services', max_length=30),
        ),
        migrations.AlterField(
            model_name='servicedependency_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicedependency_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='servicegraphconstraint_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicegraphconstraint_decl',
            name='constraints',
            field=core.models.xosbase_header.StrippedCharField(help_text=b'A composite array defining positions, eg [volt, vsg, [address_manager, vrouter]]', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicegraphconstraint_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicegraphconstraint_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceinstance_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstance_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstance_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceinstanceattribute_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstanceattribute_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstanceattribute_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceinstancelink_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstancelink_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstancelink_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceinterface_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinterface_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinterface_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceport_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceport_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceport_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='site_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='site_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='site_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='slice_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='slice_decl',
            name='description',
            field=models.CharField(blank=True, help_text=b'High level description of the slice and expected activities', max_length=1024, null=True),
        ),
        migrations.AlterField(
            model_name='slice_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='slice_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='tag_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='tag_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='tag_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='trustdomain_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='trustdomain_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='trustdomain_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='xoscore_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='xoscore_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='xoscore_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='xosguiextension_decl',
            name='backend_status',
            field=models.CharField(default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='xosguiextension_decl',
            name='leaf_model_name',
            field=models.CharField(help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='xosguiextension_decl',
            name='updated',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
    ]
