# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# -*- coding: utf-8 -*-
# Generated by Django 1.11.11 on 2019-03-04 18:58
from __future__ import unicode_literals

import core.models.xosbase_header
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0002_initial_data'),
    ]

    operations = [
        migrations.AlterField(
            model_name='addresspool_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='cidr',
            field=models.CharField(blank=True, help_text=b'Subnet for this AddressPool', max_length=32),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='gateway_ip',
            field=models.CharField(blank=True, help_text=b'Gateway IP address for this AddressPool', max_length=32),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='gateway_mac',
            field=models.CharField(blank=True, help_text=b'Gateway MAC address for this AddressPool', max_length=32),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='addresspool_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='controller_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controller_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controller_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='controllerimages_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllerimages_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllerimages_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='controllernetwork_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllernetwork_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllernetwork_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='controllerrole_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllerrole_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllerrole_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='controllersite_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllersite_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllersite_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='controllersiteprivilege_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllersiteprivilege_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllersiteprivilege_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='controllerslice_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllerslice_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllerslice_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='controllersliceprivilege_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllersliceprivilege_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controllersliceprivilege_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='controlleruser_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controlleruser_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='controlleruser_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='deployment_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='deployment_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='deployment_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='flavor_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='flavor_decl',
            name='flavor',
            field=core.models.xosbase_header.StrippedCharField(blank=True, help_text=b'flavor string used to configure deployments', max_length=32),
        ),
        migrations.AlterField(
            model_name='flavor_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='flavor_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='image_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='image_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='image_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='imagedeployments_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='imagedeployments_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='imagedeployments_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='instance_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='instance_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='instance_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='interfacetype_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='interfacetype_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='interfacetype_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='network_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='network_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='network_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='networkparameter_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkparameter_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkparameter_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='networkparametertype_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkparametertype_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkparametertype_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='networkslice_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkslice_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networkslice_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='networktemplate_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networktemplate_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='networktemplate_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='node_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='node_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='node_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='nodelabel_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='nodelabel_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='nodelabel_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='port_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='port_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='port_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='principal_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='principal_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='principal_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='privilege_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='privilege_decl',
            name='expires',
            field=models.DateTimeField(blank=True, max_length=1024, null=True),
        ),
        migrations.AlterField(
            model_name='privilege_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='privilege_decl',
            name='permission',
            field=models.CharField(blank=True, default=b'all', max_length=1024),
        ),
        migrations.AlterField(
            model_name='privilege_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='role_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='role_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='role_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='service_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='service_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='service_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceattribute_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceattribute_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceattribute_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='servicedependency_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicedependency_decl',
            name='connect_method',
            field=models.CharField(blank=True, choices=[(b'none', b'None'), (b'private', b'Private'), (b'public', b'Public')], default=b'none', help_text=b'method to connect the two services', max_length=30),
        ),
        migrations.AlterField(
            model_name='servicedependency_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicedependency_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='servicegraphconstraint_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicegraphconstraint_decl',
            name='constraints',
            field=core.models.xosbase_header.StrippedCharField(blank=True, help_text=b'A composite array defining positions, eg [volt, vsg, [address_manager, vrouter]]', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicegraphconstraint_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='servicegraphconstraint_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceinstance_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstance_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstance_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceinstanceattribute_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstanceattribute_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstanceattribute_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceinstancelink_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstancelink_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinstancelink_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceinterface_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinterface_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceinterface_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='serviceport_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceport_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='serviceport_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='site_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='site_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='site_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='sitedeployment_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='sitedeployment_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='sitedeployment_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='siteprivilege_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='siteprivilege_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='siteprivilege_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='siterole_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='siterole_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='siterole_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='slice_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='slice_decl',
            name='controller_replica_count',
            field=models.IntegerField(blank=True, default=0, help_text=b'Replica count, controller-dependent', null=True),
        ),
        migrations.AlterField(
            model_name='slice_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='slice_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='sliceprivilege_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='sliceprivilege_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='sliceprivilege_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='slicerole_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='slicerole_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='slicerole_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='tag_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='tag_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='tag_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='trustdomain_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='trustdomain_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='trustdomain_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='xoscore_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='xoscore_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='xoscore_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
        migrations.AlterField(
            model_name='xosguiextension_decl',
            name='backend_status',
            field=models.CharField(blank=True, default=b'Provisioning in progress', max_length=1024),
        ),
        migrations.AlterField(
            model_name='xosguiextension_decl',
            name='leaf_model_name',
            field=models.CharField(blank=True, help_text=b'The most specialized model in this chain of inheritance, often defined by a service developer', max_length=1024),
        ),
        migrations.AlterField(
            model_name='xosguiextension_decl',
            name='updated',
            field=models.DateTimeField(blank=True, default=django.utils.timezone.now, help_text=b'Time this model was changed by a non-synchronizer'),
        ),
    ]
