# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.


import logging
import requests
import urllib2
from time import sleep
from django.utils.translation import ugettext_lazy as _

from horizon import exceptions
from horizon import messages
from horizon import tabs

from xos_metering.api import ceilometer
from xos_metering.api import keystone

from xos_metering.dashboards.xosadmin.xosmonitoring import \
    tables as metering_tables

from xos_metering.utils import metering

LOG = logging.getLogger(__name__)

class GlobalStatsTab(tabs.TableTab):
    name = _("Stats")
    slug = "stats"
    template_name = "xosadmin/xosmonitoring/stats.html"
    preload = False
    table_classes = (metering_tables.UsageTable,)

    def get_context_data(self, request):
        meters = ceilometer.Meters(request)
        if not meters._ceilometer_meter_list:
            msg = _("There are no meters defined yet.")
            messages.warning(request, msg)

        context = {
            'nova_meters': meters.list_nova(),
            'neutron_meters': meters.list_neutron(),
#            'glance_meters': meters.list_glance(),
#            'cinder_meters': meters.list_cinder(),
#            'swift_meters': meters.list_swift(),
#            'kwapi_meters': meters.list_kwapi(),
#            'ipmi_meters': meters.list_ipmi(),
            'vcpe_meters': meters.list_vcpe(),
            'sdn_meters': meters.list_sdn(),
        }

        return context

def acquire_xos_monitoring_channel():
    url = "http://ctl:9999/xoslib/monitoringchannel/"
    admin_auth=("padmin@vicci.org", "letmein")   # use your XOS username and password
    monitoring_channels = requests.get(url, auth=admin_auth).json()
    LOG.info('SRIKANTH: XOS REST response monitoring channels=%(mchannels)s'%{'mchannels':monitoring_channels})
    ceilometer_url = None
    if not monitoring_channels:
        monitoring_channel = requests.post(url, auth=admin_auth).json()
    else:
        monitoring_channel = monitoring_channels[0]
    while not monitoring_channel['ceilometer_url']:
         LOG.info('SRIKANTH: Waiting for monitoring channel create')
         sleep(0.5)
         monitoring_channel = requests.get(url, auth=admin_auth).json()[0]
    #TODO: Wait until URL is completely UP
    while True:
        LOG.info('SRIKANTH: Waiting for ceilometer proxy URL %(url)s is available' % {'url':monitoring_channel['ceilometer_url']})
        try:
            response = urllib2.urlopen(monitoring_channel['ceilometer_url'],timeout=1)
            break
        except urllib2.HTTPError, e:
            LOG.info('SRIKANTH: HTTP error %(reason)s' % {'reason':e.reason})
            break
        except urllib2.URLError, e:
            LOG.info('SRIKANTH: URL error %(reason)s' % {'reason':e.reason})
            pass
    return monitoring_channel

class UsageReportTab(tabs.TableTab):
    name = _("Usage Report")
    slug = "usage_report"
    template_name = "horizon/common/_detail_table.html"
    table_classes = (metering_tables.ReportTable,)

    def get_report_table_data(self):
        monitoring_channel = acquire_xos_monitoring_channel()
        ceilometer_url = monitoring_channel['ceilometer_url']
        allowed_tenant_ids = monitoring_channel['tenant_list_str'].replace(' ','').split(',')
        LOG.info('SRIKANTH: XOS ceilometer URL =%(url)s allowed_tenants=%(atts)s'%{'url':ceilometer_url,'atts':allowed_tenant_ids})
        meters = ceilometer.Meters(self.request, ceilometer_url=ceilometer_url)
        services = {
            _('Nova'): meters.list_nova(),
            _('Neutron'): meters.list_neutron(),
#            _('Glance'): meters.list_glance(),
#            _('Cinder'): meters.list_cinder(),
#            _('Swift_meters'): meters.list_swift(),
#            _('Kwapi'): meters.list_kwapi(),
#            _('IPMI'): meters.list_ipmi(),
            _('VCPE'): meters.list_vcpe(),
            _('SDN'): meters.list_sdn(),
        }
        report_rows = []

        date_options = self.request.session.get('period', 1)
        date_from = self.request.session.get('date_from', '')
        date_to = self.request.session.get('date_to', '')

        try:
            date_from, date_to = metering.calc_date_args(date_from,
                                                         date_to,
                                                         date_options)
        except Exception:
            exceptions.handle(self.request, _('Dates cannot be recognized.'))
        try:
            project_aggregates = metering.ProjectAggregatesQuery(self.request,
                                                                 date_from,
                                                                 date_to,
                                                                 3600 * 24,
                                                                 ceilometer_url=ceilometer_url,
                                                                 tenant_ids=allowed_tenant_ids)
        except Exception:
            exceptions.handle(self.request,
                              _('Unable to retrieve project list.'))
        for meter in meters._cached_meters.values():
            service = None
            for name, m_list in services.items():
                if meter in m_list:
                    service = name
                    break
            if not service:
                continue
            res, unit = project_aggregates.query(meter.name)

            for re in res:
                values = re.get_meter(meter.name.replace(".", "_"))
                if values:
                    for value in values:
                        row = {"name": 'none',
                               "project": re.id,
                               "meter": meter.name,
                               "description": meter.description,
                               "service": service,
                               "time": value._apiresource.period_end,
                               "value": value._apiresource.avg,
                               "unit": meter.unit}
                        report_rows.append(row)
        return report_rows


class CeilometerOverviewTabs(tabs.TabGroup):
    slug = "ceilometer_overview"
    tabs = (UsageReportTab, GlobalStatsTab,)
    sticky = True
