
# Copyright 2017-present Open Networking Foundation
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


#! /bin/bash

# Helper script for running chameleon tests from inside prod vm

PUB_IP=`dig +short myip.opendns.com @resolver1.opendns.com`
PW=`cat /opt/cord/build/platform-install/credentials/xosadmin@opencord.org`

CONTAINER_NAME=rcord_xos_core_1

echo "HOSTNAME=$PUB_IP" > testconfig-chameleon.sh
echo "USERNAME=xosadmin@opencord.org" >> testconfig-chameleon.sh
echo "PASSWORD=$PW" >> testconfig-chameleon.sh

# chameleon_list_test.sh is autogenerated inside of the core api container,
# so we have to run the test from inside the container.

docker cp testconfig-chameleon.sh $CONTAINER_NAME:/opt/xos/coreapi/tests/
docker exec -it $CONTAINER_NAME bash /opt/xos/coreapi/tests/chameleon_list_test.sh
docker exec -it $CONTAINER_NAME bash /opt/xos/coreapi/tests/cham_slice_crud.sh
