/*
 * Copyright 2015 Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function () {
  'use strict';

  angular.module('mCord')
    .directive('cordLogin', function ($log, $location, User) {

      return {
        restrict: 'E',
        templateUrl: 'app/view/login/login.html',
        controllerAs: 'vm',
        controller: function(){

          this.loading = false;

          this.login = () => {
            if (this.email && this.password) {
              this.loading = true;
              User.login(this.email, this.password)
              .then(() => {
                $location.url('/');
              })
              .catch(() => {
                this.error = true;
              })
              .finally(() => {
                this.loading = false;
              });
            }
          };

          $log.debug('Cord Login Ctrl has been created.');
        }
      }

    });
}());
