/**
 * © OpenCORD
 *
 * Visit http://guide.xosproject.org/devguide/addview/ for more information
 *
 * Created by teone on 6/13/16.
 */

(function () {
  'use strict';
  angular.module('mCord')
    .directive('imsiList', function ($uibModal) {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/imsi-list/imsi-list.tpl.html',
        controller: function ($log, Imsi) {

          Imsi.query().$promise
            .then((imsi) => {
              console.log(imsi);
              this.imsi = imsi;
            });

          this.tableConfig = {
            order: true,
            filter: 'field',
            columns: [
              {
                label: '#',
                prop: 'IMSI',
                link: item => `#/imsi/${item.IMSI}`
              },
              {
                label: 'Enodeb',
                prop: 'Enodeb'
              },
              {
                label: 'DlMeasBitRate',
                prop: 'DlMeasBitRate'
              },
              {
                label: 'UlMeasBitRate',
                prop: 'UlMeasBitRate'
              },
              {
                label: 'Status',
                prop: 'UeStatus',
                type: 'boolean'
              }
            ],
            actions: [
              {
                label: 'delete',
                icon: 'remove',
                cb: (item) => {
                  item.$delete()
                  .then(() => {
                    _.remove(this.imsi, item);
                  })
                  .catch(e => {
                    console.log(e);
                  })
                },
                color: 'red'
              }
            ]
          };

          this.addImsi = () => {
            this.modalInstance = $uibModal.open({
              animation: true,
              templateUrl: 'addEnode',
              controllerAs: 'vm',
              controller: function($uibModalInstance){
                this.modal = $uibModalInstance;
              }
            });
          }
        }
      }
    });
})();

