/*
 * Copyright 2015 Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

angular.module('mCord')
  .directive('relatedStats', function () {
    return {
      restrict: 'E',
      templateUrl: 'app/components/related-stats/related-stats.tpl.html',
      scope: {
        model: '=',
        type: '@'
      },
      bindToController: true,
      controllerAs: 'vm',
      controller: function($scope, $filter, _){
        $scope.$watch(() => this.model, enode => {
          if(enode){
            loadStats();
          }
        });

        const loadStats = () => {
          this.model.getStats()
          .then((stats) => {
            this.selectedStats = 'download_data';
            if(angular.isDefined(stats.ProfileArray)){
              this.stats = formatStats(stats.ProfileArray);
            }
          });
        };

        const formatStats = stats => {
          let series = _.reduce(stats, (list, s) => {
            return list.concat([s.Profile]);
          }, []);
          let labels = _.reduce(stats[0].StatsArray, (list, s) => {
            return list.concat([$filter('date')(new Date(s.Time * 1000), 'shortTime')]);
          }, []);
          const download_data = _.reduce(stats, (list, stat) => {
            let bitrate = _.reduce(stat.StatsArray, (data, s) => {
              return data.concat([s.DlBitrate]);
            }, []);
            list.push(bitrate);
            return list;
          }, []);
          const upload_data = _.reduce(stats, (list, stat) => {
            let bitrate = _.reduce(stat.StatsArray, (data, s) => {
              return data.concat([s.UlBitrate]);
            }, []);
            list.push(bitrate);
            return list;
          }, []);
          return {
            labels: labels,
            series: series,
            data: download_data,
            upload_data: upload_data,
            download_data: download_data
          };
        };

        this.setChart = type => {
          if(!this.stats){
            return;
          }
          this.selectedStats = type;
          this.stats.data = this.stats[type];
        }
      }
    };
  });
