/*
 * Copyright 2015 Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

angular.module('mCord')
  .directive('addProfileToItem', function () {
    return {
      restrict: 'E',
      templateUrl: 'app/components/add-profile-to-item/add-profile-to-item.html',
      scope: {
        modal: '=',
        cb: '=',
        item: '='
      },
      bindToController: true,
      controllerAs: 'vm',
      controller: function(Profile){

        Profile.query().$promise
        .then((profiles) => {
          profiles = _.filter(profiles, p => {
            console.log(p.Name, p.Name.indexOf('Default'), p.Name.indexOf('Default') === -1);
            return p.Name.indexOf('Default') === -1
          });
          console.log(profiles);
          this.profiles = profiles;
          return this.item.getProfiles();
        })
        .then((itemProfiles) => {
          console.log(this.profiles, itemProfiles);
          this.profiles = _.differenceBy(this.profiles, itemProfiles, 'Name');
        });

        this.config = {
          columns: [
            {
              label: 'Name',
              prop: 'Name'
            },
            {
              label: 'DlAllocRBRate',
              prop: 'DlAllocRBRate'
            },
            {
              label: 'UlAllocRBRate',
              prop: 'UlAllocRBRate'
            },
            {
              label: 'Start',
              prop: 'Start'
            },
            {
              label: 'End',
              prop: 'End'
            }
          ],
          actions: [
            {
              label: 'Add',
              icon: 'plus',
              cb: (profile) => {
                _.remove(this.profiles, p => p.Name === profile.Name);
                this.cb(profile);
              },
            }
          ],
          filter: 'field',
          order: true
        }
      }
    };
  });
