/*
 * Copyright 2015 Open Networking Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

angular.module('mCord')
  .directive('addEnodeB', function () {
    return {
      restrict: 'E',
      templateUrl: 'app/components/add-enodeb/add-enodeb.html',
      scope: {
        modal: '='
      },
      bindToController: true,
      controllerAs: 'vm',
      controller: function(Enodeb){
        this.model = {
        };
        this.config = {
          formName: 'createEnode',
          fields: {
            Description: {
              type: 'string',
              validators: {
                required: true,
                minlength: 10
              }
            },
            eNBId: {
              type: 'number',
              validators: {
                required: true
              }
            },
            IpAddr: {
              type: 'string',
              validators: {
                required: true
              }
            }
          },
          actions: [
            {
              label: 'Save',
              icon: 'ok',
              cb: (enode) => {
                // TODO validate form (wait for arpit to commit)
                Enodeb.save(enode).$promise
                .then(() => {
                  // TODO add to list
                  this.modal.close();
                })
                .catch(e => {
                  console.log(this.modal);
                })
              },
              class: 'success'
            },
            {
              label: 'Cancel',
              icon: 'remove', // refers to bootstraps glyphicon
              cb: () => { // receive the model
                this.modal.close();
              },
              class: 'warning'
            }
          ]
        };
      }
    };
  });
