(function () {
  angular.module('mCord')
    .service('Imsi', function($injector, $resource, $q, $http, baseUrl){
      const r = $resource(`${baseUrl}onos/progran/imsi/:id`, {id: '@IMSI'}, {
        save: {method: 'PUT'},
        query: {
          array: false,
          interceptor: {
            response: function(res){
              const Imsi = $injector.get('Imsi');
              return res.data.ImsiArray.map(i => new Imsi(i));
            }
          }
        },
        get: {
          array: false,
          interceptor: {
            response: function(res){
              const Imsi = $injector.get('Imsi');
              return new Imsi(res.data.ImsiArray[0]);
            }
          }
        }
      });

      // Override the default save method,
      // Name is the key, so the $resource will try to update
      r.save = function(data){
        const d = $q.defer();
        $http.post(`${baseUrl}onos/progran/imsi/`, data)
          .then(res => {
            d.resolve(res.data);
          })
          .catch(err => {
            d.reject(err)
          });
        return {$promise: d.promise};
      };

      r.prototype.getProfiles = function(){
        const d = $q.defer();

        $http.get(`${baseUrl}onos/progran/imsi/${this.IMSI}/profile`)
          .then(res => {
            d.resolve(res.data.ProfileArray);
          })
          .catch(err => {
            d.reject(err)
          });

        return d.promise;
      };

      // this is under profile
      r.prototype.addProfile = function(data){
        const d = $q.defer();
        let body = {'IMSIRuleArray': [this.IMSI]};
        $http.post(`${baseUrl}onos/progran/profile/${data.Name}/imsi`, body)
          .then(res => {
            d.resolve(res.data);
          })
          .catch(err => {
            d.reject(err)
          });

        return d.promise;
      };

      r.prototype.deleteProfile = function(id){
        const d = $q.defer();
        $http.delete(`${baseUrl}onos/progran/imsi/${this.IMSI}/profile/${id}`)
          .then(res => {
            d.resolve(res.data);
          })
          .catch(err => {
            d.reject(err)
          });

        return d.promise;
      };

      return r;
    })
})();