(function () {
  'use strict';

  angular.module('mCord')
    .directive('imsiDetails', function () {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/imsi-details/imsi-details.tpl.html',
        controller: function($stateParams, _, Imsi){

          Imsi.get({id: $stateParams.id}).$promise
          .then((imsi) => {
            this.imsi = imsi;
            return imsi.getProfiles()
          })
          .then(profiles => {
            this.data = _.reduce(profiles, (list, p) => {
              list.push([p.DlAllocRBRate, p.UlAllocRBRate]);
              return list;
            }, [])
          });

          this.config = {
            exclude: ['UeStatus'],
            formName: 'updateEnode',
            actions: [
              {
                label: 'Update',
                icon: 'ok',
                cb: (enode) => {
                  enode.$save();
                },
                class: 'primary-border'
              }
            ]
          };
          
        }
      }
    });
}());