/*
 * Copyright 2015 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

angular.module('mCord')
  .directive('relatedProfiles', function () {
    return {
      restrict: 'E',
      templateUrl: 'app/components/related-profiles/related-profiles.tpl.html',
      scope: {
        model: '=',
        config: '='
      },
      bindToController: true,
      controllerAs: 'vm',
      controller: function($scope, _){
        $scope.$watch(() => this.model, enode => {
          if(enode){
            loadProfiles();
          }
        });

        const loadProfiles = () => {
          this.model.getProfiles()
          .then((profiles) => {
            this.profiles = profiles;
          });
        };

        this.deleteProfile = (id) => {
          this.model.deleteProfile(id)
          .then(() => {
            _.remove(this.profiles, p => p.Name === id);
          });
        }
      }
    };
  });
