/*
 * Copyright 2015 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function () {
  'use strict';

  angular.module('mCord')
    .directive('header', function ($location, User) {
      return {
        restrict: 'E',
        templateUrl: 'app/components/header/header.html',
        controllerAs: 'vm',
        controller: function() {

          this.user = User.isLoggedIn();

          this.logout = () => {
            User.logout()
            .then(function(){
              $location.path('/login');
            });
          };
        }
      };
    })
  .directive('closeOnRouteChange', function(){
    return {
      restrict: 'A',
      link: function(scope, elem){
        scope.$on('$routeChangeStart', function() {
          elem.removeClass('in');
        });
      }
    }
  })
  .directive('activeClass', function($location) {
    return {
      restrict: 'A',
      link: function($rootScope, $element, $attrs) {
        const links = angular.element($element[0]).find('a');
        let urlMap = {};
        let activeClass = $attrs.activeClass || 'active';
        for (let i = links.length - 1; i >= 0; i--) {
          let link = angular.element(links[i]);
          let url = link.attr('href');

          if (url.substring(0, 1) === '#') {
            urlMap[url.substring(1)] = link;
          } else {
            urlMap[url] = link;
          }
        }

        const activateItem = () => {
          var path = urlMap[$location.path()];
          links.parent('li').removeClass(activeClass);
          if (path) {
            path.parent('li').addClass(activeClass);
          }
        }
        activateItem();
        $rootScope.$on('$stateChangeStart', activateItem);
      }
    }
  });
}());
