/**
 * © OpenCORD
 *
 * Visit http://guide.xosproject.org/devguide/addview/ for more information
 *
 * Created by teone on 6/13/16.
 */

(function () {
  'use strict';
  angular.module('mCord')
    .directive('profileDetails', function ($uibModal, $q) {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/profiles-details/profiles-details.tpl.html',
        controller: function ($uibModal, $stateParams, Profile, _) {
          Profile.get({id: $stateParams.id}).$promise
          .then((profile) => {
            this.profile = profile;
            return $q.all([
              profile.getImsis(),
              profile.getEnodes()
            ]);
          })
          .then(res => {
            const [imsis, enodes] = res;
            this.imsis = imsis;
            this.enodes = enodes;
          })
          .catch(e => console.log(e));

          this.formConfig = {
            exclude: ['IMSIRuleArray'],
            formName: 'updateProfiles',
            actions: [
              {
                label: 'Update',
                icon: 'ok',
                cb: (imsi) => {
                  imsi.$save();
                },
                class: 'primary-border'
              }
            ]
          };

          this.imsiTableCfg = {
            order: true,
            filter: 'field',
            columns: [
              {
                label: '#',
                prop: 'IMSI',
                link: item => `#/imsi/${item.IMSI}`
              },
              {
                label: 'Enodeb',
                prop: 'Enodeb'
              },
              {
                label: 'DlMeasBitRate',
                prop: 'DlMeasBitRate'
              },
              {
                label: 'UlMeasBitRate',
                prop: 'UlMeasBitRate'
              },
              {
                label: 'Status',
                prop: 'UeStatus',
                type: 'boolean'
              }
            ],
            actions: [
              {
                label: 'Delete',
                icon: 'remove',
                color: 'red',
                cb: (imsi) => {
                  this.profile.deleteImsi(imsi.IMSI)
                  .then(() => {
                    _.remove(this.imsis, i =>i.IMSI === imsi.IMSI);
                  });
                }
              }
            ]
          };

          this.enodeTableCfg = {
            order: true,
            filter: 'field',
            columns: [
              {
                label: '#',
                prop: 'eNBId',
                link: item => `#/enode/${item.eNBId}`
              },
              {
                label: 'Ip Address',
                prop: 'IpAddr'
              },
              {
                label: 'Description',
                prop: 'Description'
              },
              {
                label: 'Status',
                prop: 'Status',
                type: 'boolean'
              }
            ],
            actions: [
              {
                label: 'Delete',
                icon: 'remove',
                color: 'red',
                cb: (enode) => {
                  this.profile.deleteImsi(enode.eNBId)
                  .then(() => {
                    _.remove(this.enodes, i =>i.eNBId === enode.eNBId);
                  });
                }
              }
            ]
          };

          this.deleteAllImsi = () => {
            this.profile.deleteImsis()
            .then(() => {
              this.imsis = [];
            });
          };

          this.addImsi = () => {
            const _this = this;
            this.modalInstance = $uibModal.open({
              animation: true,
              templateUrl: 'addImsiToProfile',
              controllerAs: 'vm',
              controller: function ($uibModalInstance) {
                this.modal    = $uibModalInstance;
                this.callback = (imsi) => {
                  _this.imsis.push(imsi);
                };
                this.profile = _this.profile;
              }
            });
          };

          this.addEnode = () => {
            const _this = this;
            this.modalInstance = $uibModal.open({
              animation: true,
              templateUrl: 'addEnodeToProfile',
              controllerAs: 'vm',
              controller: function ($uibModalInstance) {
                this.modal    = $uibModalInstance;
                this.callback = (enode) => {
                  _this.enodes.push(enode);
                };
                this.profile = _this.profile;
              }
            });
          };

          this.deleteAllEnodes = () => {
            this.profile.deleteEnodes()
            .then(() => {
              this.enodes = [];
            });
          };
        }
      }
    });
})();

