(function () {
  angular.module('mCord')
    .service('Imsi', function($resource, $q, $http, baseUrl){
      const r = $resource(`${baseUrl}api/imsi/:id`, {id: '@IMSI'}, {
        save: {method: 'PUT'}
      });

      r.prototype.getProfiles = function(){
        const d = $q.defer();

        $http.get(`${baseUrl}api/imsi/${this.IMSI}/profile`)
          .then(res => {
            d.resolve(res.data);
          })
          .catch(err => {
            d.reject(err)
          });

        return d.promise;
      };

      r.prototype.deleteProfile = function(id){
        const d = $q.defer();
        $http.delete(`${baseUrl}api/imsi/${this.IMSI}/profile/${id}`)
          .then(res => {
            d.resolve(res.data);
          })
          .catch(err => {
            d.reject(err)
          });

        return d.promise;
      };

      return r;
    })
})();