(function () {
  'use strict';

  angular.module('mCord')
    .directive('eNodeDetails', function () {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/enode-details/e-node-details.tpl.html',
        controller: function($stateParams, Enodeb){
          Enodeb.get({id: $stateParams.id}).$promise
          .then((enode) => {
            this.enode = enode;
          });

          this.config = {
            exclude: ['ProfileArray', 'Status'],
            formName: 'updateEnode',
            actions: [
              {
                label: 'Save',
                icon: 'ok', // refers to bootstraps glyphicon
                cb: (enode) => { // receive the model
                  enode.$save();
                },
                class: 'success'
              }
            ]
          };
          
        }
      }
    });
}());