(function () {
  'use strict';

  angular.module('mCord')
    .directive('eNodeList', function () {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/enode-list/e-node-list.tpl.html',
        controller: function($uibModal, Enodeb){

          Enodeb.query().$promise
          .then((enodes) => {
            this.enodes = enodes;
          })

          this.tableConfig = {
            order: true,
            filter: 'field',
            columns: [
              {
                label: '#',
                prop: 'eNBId',
                link: item => `#/enode/${item.eNBId}`
              },
              {
                label: 'Ip Address',
                prop: 'IpAddr'
              },
              {
                label: 'Description',
                prop: 'Description'
              },
              {
                label: 'Status',
                prop: 'Status',
                type: 'boolean'
              }
            ]
          };

          this.addEnode = () => {
            this.modalInstance = $uibModal.open({
              animation: true,
              templateUrl: 'addEnode',
              controllerAs: 'vm',
              controller: function($uibModalInstance){
                this.modal = $uibModalInstance;
              }
            });
          };
          
        }
      }
    });
}());