(function () {
  'use strict';

  angular.module('mCord')
    .directive('eNodeDetails', function () {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/enode-details/e-node-details.tpl.html',
        controller: function($stateParams, _, Enodeb){

          const secondsToHms = d => {
            d = Number(d);
            var h = Math.floor(d / 3600);
            var m = Math.floor(d % 3600 / 60);
            var s = Math.floor(d % 3600 % 60);
            return ((h > 0 ? h + ':' + (m < 10 ? '0' :'') :'') + m + ':' + (s < 10 ? '0' :'') + s);
          };

          Enodeb.get({id: $stateParams.id}).$promise
          .then((enode) => {
            this.enode = enode;
            return enode.getStats();
          })
          .then(stats => {
            delete stats.ProfileArray;
            stats.Uptime = moment.duration(stats.Uptime, 'seconds').format('HH[h] mm[m] ss[s]');
            this.enodeStats = stats;
            return this.enode.getProfiles()
          })
          .then(profiles => {
            console.log(profiles);
            this.data = _.reduce(profiles, (list, p) => {
              list.push([p.DlAllocRBRate, p.UlAllocRBRate]);
              return list;
            }, [])
          });

          this.labels = ['Download', 'Upload'];

          this.colors = [ '#803690', '#00ADF9', '#46BFBD', '#FDB45C', '#949FB1', '#4D5360', '#DCDCDC'];

          this.config = {
            exclude: ['ProfileArray', 'Status'],
            formName: 'updateEnode',
            actions: [
              {
                label: 'Save',
                icon: 'ok', // refers to bootstraps glyphicon
                cb: (enode) => { // receive the model
                  enode.$save();
                },
                class: 'success'
              }
            ]
          };
          
        }
      }
    })
    .directive('chartStackedBar', function (ChartJsFactory) {
      return new ChartJsFactory('StackedBar');
    });
}());