(function () {
  'use strict';

  angular.module('mCord')
    .directive('eNodeDetails', function () {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/enode-details/e-node-details.tpl.html',
        controller: function($stateParams, Enodeb){

          const secondsToHms = d => {
            d = Number(d);
            var h = Math.floor(d / 3600);
            var m = Math.floor(d % 3600 / 60);
            var s = Math.floor(d % 3600 % 60);
            return ((h > 0 ? h + ':' + (m < 10 ? '0' :'') :'') + m + ':' + (s < 10 ? '0' :'') + s);
          };

          Enodeb.get({id: $stateParams.id}).$promise
          .then((enode) => {
            this.enode = enode;
            return enode.getStats();
          })
          .then(stats => {
            delete stats.ProfileArray;
            stats.Uptime = moment.duration(stats.Uptime, 'seconds').format('HH[h] mm[m] ss[s]');
            this.enodeStats = stats;
          });

          this.config = {
            exclude: ['ProfileArray', 'Status'],
            formName: 'updateEnode',
            actions: [
              {
                label: 'Save',
                icon: 'ok', // refers to bootstraps glyphicon
                cb: (enode) => { // receive the model
                  enode.$save();
                },
                class: 'success'
              }
            ]
          };
          
        }
      }
    });
}());