(function () {
  'use strict';

  angular.module('mCord')
    .directive('imsiDetails', function () {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/imsi-details/imsi-details.tpl.html',
        controller: function($scope, $stateParams, $uibModal, _, Imsi){

          Imsi.get({id: $stateParams.id}).$promise
          .then((imsi) => {
            this.imsi = imsi;
            return imsi.getProfiles()
          })
          .then(profiles => {
            this.profiles = profiles;
          });

          this.config = {
            exclude: ['UeStatus'],
            formName: 'updateEnode',
            actions: [
              {
                label: 'Update',
                icon: 'ok',
                cb: (imsi) => {
                  imsi.$save();
                },
                class: 'primary-border'
              }
            ]
          };

          this.addProfile = () => {
            const _this = this;
            this.modalInstance = $uibModal.open({
              animation: true,
              templateUrl: 'addProfileToImsi',
              controllerAs: 'vm',
              controller: function ($uibModalInstance) {
                this.modal    = $uibModalInstance;
                this.callback = (profile) => {
                  this.imsi.addProfile(profile)
                  .then(p => {
                    _this.profiles.push(profile);
                    $scope.$broadcast('profile.add', {targetId: _this.imsi.IMSI, profile: profile});
                  });
                };
                this.imsi = _this.imsi;
              }
            });
          };
        }
      }
    });
}());