(function () {

  angular.module('mCord')
  .service('Profile', function($injector, $resource, $q, $http, baseUrl, Helpers){
    const r = $resource(`${baseUrl}onos/progran/profile/:id`, {id: '@Name'}, {
      save: {
        method: 'PUT'
      },
      $save: {
        method: 'PUT'
      },
      query: {
        array: false,
        interceptor: {
          response: function(res){
            const Profile = $injector.get('Profile');
            return res.data.ProfileArray.map(p => new Profile(p)).map(p => {
              p.jsStart = Helpers.stringToTime(p.Start);
              p.jsEnd = Helpers.stringToTime(p.End);
              return p;
            });
          }
        }
      },
      get: {
        array: false,
        interceptor: {
          response: function(res){
            const Profile = $injector.get('Profile');
            res.data.ProfileArray[0].jsStart = Helpers.stringToTime(res.data.ProfileArray[0].Start);
            res.data.ProfileArray[0].jsEnd = Helpers.stringToTime(res.data.ProfileArray[0].End);
            return new Profile(res.data.ProfileArray[0]);
          }
        }
      }
    });

    // Override the default save method,
    // Name is the key, so the $resource will try to update
    r.save = function(data){
      const d = $q.defer();
      $http.post(`${baseUrl}onos/progran/profile/`, data)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });
      return {$promise: d.promise};
    };

    r.prototype.$save = function(){
      const d = $q.defer();
      $http.put(`${baseUrl}onos/progran/profile/${this.Name}`, this)
        .then(res => {
          d.resolve(res.data);
        })
        .catch(err => {
          d.reject(err)
        });
      return {$promise: d.promise};
    };

    r.prototype.getImsis = function(){
      const d = $q.defer();

      $http.get(`${baseUrl}onos/progran/profile/${this.Name}/imsi`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    // this is under profile
    r.prototype.addImsi = function(data){
      const d = $q.defer();
      let body = {'IMSIRuleArray': [data.IMSI]};
      $http.post(`${baseUrl}onos/progran/profile/${this.Name}/imsi`, body)
        .then(res => {
          d.resolve(res.data);
        })
        .catch(err => {
          d.reject(err)
        });

      return d.promise;
    };

    r.prototype.deleteImsis = function(){
      const d = $q.defer();

      $http.delete(`${baseUrl}onos/progran/profile/${this.Name}/imsi`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteImsi = function(id){
      const d = $q.defer();

      $http.delete(`${baseUrl}onos/progran/profile/${this.Name}/imsi/${id}`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.getEnodes = function(){
      const d = $q.defer();

      $http.get(`${baseUrl}onos/progran/profile/${this.Name}/enodeb`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteEnodes = function(){
      const d = $q.defer();

      $http.delete(`${baseUrl}onos/progran/profile/${this.Name}/enodeb`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteEnode = function(id){
      const d = $q.defer();

      $http.delete(`${baseUrl}onos/progran/enodeb/${id}/profile/${this.Name}`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    return r;
  })
})();