/*
 * Copyright 2015 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function () {
  'use strict';

  angular.module('mCord')
  .service('Helpers', function(){
    this.randomDate = function(start, end) {
      return new Date(
        start.getTime() + Math.random() * (end.getTime() - start.getTime())
      );
    };

    this.stringToTime = (string) => {

      if(string.length === 0){
        return;
      }

      let jsDate;
      jsDate = new Date();

      let [date, time] = string.split(' ');

      let [day, month, year] = date.split('.');
      let [hour, minute] = time.split(':');


      jsDate.setYear(year);
      jsDate.setMonth(month);
      jsDate.setDate(day);
      jsDate.setHours(hour);
      jsDate.setMinutes(minute);

      return jsDate;
    };
  })
  .factory('_', function(){
    return window._;
  });

}());