/*global google: true */
(function () {
  'use strict';

  angular.module('mCord')
    .directive('eNodeMap', function () {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/home/e-node-map.tpl.html',
        controller: function($log, Enodeb, NgMap){

          let bounds = new google.maps.LatLngBounds();

          Enodeb.query().$promise
          .then((enodes) => {
            this.enodes = enodes;
            enodes.forEach(node => {
              const latlng = new google.maps.LatLng(node.GpsCoordinate.Latitude, node.GpsCoordinate.Longitude);
              bounds.extend(latlng);
            });
            return NgMap.getMap();
          })
          .then((map) => {
            map.setCenter(bounds.getCenter());
            map.fitBounds(bounds);
          });

          this.showEnodeDetails = (marker, enode) => {
            this.selectedEnode = enode;
          };
        }
      }
    });
}());
/*global google: false */