/**
 * © OpenCORD
 *
 * Visit http://guide.xosproject.org/devguide/addview/ for more information
 *
 * Created by teone on 6/13/16.
 */

(function () {
  'use strict';
  angular.module('mCord')
    .directive('profileDetails', function ($uibModal, $q, Helpers) {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/profiles-details/profiles-details.tpl.html',
        controller: function ($uibModal, $stateParams, Profile, _) {
          this.isNew = true;
          if($stateParams.id){
            Profile.get({id: $stateParams.id}).$promise
            .then((profile) => {
              this.profile = profile;
              this.isNew = false;
              this.formConfig.actions[0].label = 'Update';
              return $q.all([
                profile.getImsis(),
                profile.getEnodes()
              ]);
            })
            .then(res => {
              const [imsis, enodes] = res;
              this.imsis = imsis;
              this.enodes = enodes;
            })
            .catch(e => console.log(e));
          }
          else {
            this.profile = new Profile();
            this.imsis = [];
            this.enodes = [];
          }

          const UD_Types = [
            {id: 'RR', label: 'RR'},
            {id: 'PF', label: 'PF'},
            {id: 'MAXCI', label: 'MAXCI'}
          ];

          this.formConfig = {
            exclude: ['IMSIRuleArray', 'Start', 'End'],
            formName: 'updateProfiles',
            fields: {
              Name: {
                type: 'string',
                validator: {
                  required: true
                }
              },
              DlSchedType: {
                type: 'select',
                validator: {
                  required: true
                },
                options: UD_Types
              },
              DlAllocRBRate: {
                type: 'number',
                validator: {
                  required: true
                }
              },
              UlSchedType: {
                type: 'select',
                validator: {
                  required: true
                },
                options: UD_Types
              },
              UlAllocRBRate: {
                type: 'number',
                validator: {
                  required: true
                }
              },
              jsStart: {
                type: 'datetime-local',
                label: 'Start',
                validator: {
                  required: true
                }
              },
              jsEnd: {
                type: 'datetime-local',
                label: 'End',
                validator: {
                  required: true
                }
              },
              AdmControl: {
                type: 'select',
                validator: {
                  required: true
                },
                options: [
                  {id: 0, label: 'All'},
                  {id: 1, label: 'Voice Only'},
                  {id: 2, label: 'Data Only'}
                ]
              },
              CellIndividualOffset: {
                type: 'number',
                validator: {
                  required: true
                }
              },
              Handover: {
                type: 'object',
                properties: {
                  A3offset: {
                    type: 'number',
                    validator: {
                      required: true
                    }
                  },
                  A3Hysteresis: {
                    type: 'number',
                    validator: {
                      required: true
                    }
                  },
                  A3TriggerQuantity: {
                    type: 'number',
                    validator: {
                      required: true
                    }
                  },
                  A5TriggerQuantity: {
                    type: 'number',
                    validator: {
                      required: true
                    }
                  },
                  A5Thresh1Rsrp: {
                    type: 'number',
                    validator: {
                      required: true
                    }
                  },
                  A5Thresh1Rsrq: {
                    type: 'number',
                    validator: {
                      required: true
                    }
                  },
                  A5Thresh2Rsrp: {
                    type: 'number',
                    validator: {
                      required: true
                    }
                  },
                  A5Thresh2Rsrq: {
                    type: 'number',
                    validator: {
                      required: true
                    }
                  },
                  A5Hysteresis: {
                    type: 'number',
                    validator: {
                      required: true
                    }
                  },
                }
              }
            },
            actions: [
              {
                label: 'Save',
                icon: 'ok',
                cb: (profile) => {
                  profile.Start = moment(profile.jsStart).format('DD.MM.YYYY HH:mm');
                  profile.End = moment(profile.jsEnd).format('DD.MM.YYYY HH:mm');

                  delete profile.jsStart;
                  delete profile.jsEnd;

                  let p;
                  if(this.isNew){
                    p = Profile.save(profile).$promise
                  }
                  else{
                    p = profile.$save().$promise;
                  }
                  p.then(() => {
                    profile.jsStart = Helpers.stringToTime(profile.Start);
                    profile.jsEnd = Helpers.stringToTime(profile.End);

                    console.log(profile);

                    this.formConfig.feedback = {
                      show: true,
                      message: `Profile ${profile.Name} saved!`,
                      type: 'success'
                    };
                  });
                },
                class: 'primary-border'
              }
            ]
          };

          this.imsiTableCfg = {
            order: true,
            filter: 'field',
            columns: [
              {
                label: '#',
                prop: 'IMSI',
                link: item => `#/imsi/${item.IMSI}`
              },
              {
                label: 'Enodeb',
                prop: 'Enodeb'
              },
              {
                label: 'DlMeasBitRate',
                prop: 'DlMeasBitRate'
              },
              {
                label: 'UlMeasBitRate',
                prop: 'UlMeasBitRate'
              },
              {
                label: 'Status',
                prop: 'UeStatus',
                type: 'boolean'
              }
            ],
            actions: [
              {
                label: 'Delete',
                icon: 'remove',
                color: 'red',
                cb: (imsi) => {
                  this.profile.deleteImsi(imsi.IMSI)
                  .then(() => {
                    _.remove(this.imsis, i =>i.IMSI === imsi.IMSI);
                  });
                }
              }
            ]
          };

          this.enodeTableCfg = {
            order: true,
            filter: 'field',
            columns: [
              {
                label: '#',
                prop: 'eNBId',
                link: item => `#/enode/${item.eNBId}`
              },
              {
                label: 'Ip Address',
                prop: 'IpAddr'
              },
              {
                label: 'Description',
                prop: 'Description'
              },
              {
                label: 'Status',
                prop: 'Status',
                type: 'boolean'
              }
            ],
            actions: [
              {
                label: 'Delete',
                icon: 'remove',
                color: 'red',
                cb: (enode) => {
                  this.profile.deleteEnode(enode.eNBId)
                  .then(() => {
                    _.remove(this.enodes, i =>i.eNBId === enode.eNBId);
                  });
                }
              }
            ]
          };

          this.deleteAllImsi = () => {
            this.profile.deleteImsis()
            .then(() => {
              this.imsis = [];
            });
          };

          this.addImsi = () => {
            const _this = this;
            this.modalInstance = $uibModal.open({
              animation: true,
              templateUrl: 'addImsiToProfile',
              controllerAs: 'vm',
              controller: function ($uibModalInstance) {
                this.modal    = $uibModalInstance;
                this.callback = (imsi) => {
                  this.profile.addImsi(imsi)
                  .then(i => {
                    _this.imsis.push(imsi);
                  })
                };
                this.profile = _this.profile;
              }
            });
          };

          this.addEnode = () => {
            const _this = this;
            this.modalInstance = $uibModal.open({
              animation: true,
              templateUrl: 'addEnodeToProfile',
              controllerAs: 'vm',
              controller: function ($uibModalInstance) {
                this.modal    = $uibModalInstance;
                this.callback = (enode) => {
                  // TODO call BE (if !this.isNew)
                  _this.enodes.push(enode);
                };
                this.profile = _this.profile;
              }
            });
          };

          this.deleteAllEnodes = () => {
            this.profile.deleteEnodes()
            .then(() => {
              this.enodes = [];
            });
          };
        }
      }
    });
})();

