(function () {
  'use strict';

  angular.module('mCord')
    .directive('eNodeMapPanel', function () {
      return {
        restrict: 'E',
        scope: {
          eNodeB: '='
        },
        bindToController: true,
        controllerAs: 'vm',
        templateUrl: 'app/view/home/e-node-map-panel.tpl.html',
        controller: function($scope, $uibModal){
          this.close = () => {
            delete this.eNodeB;
          };

          this.addProfile = () => {
            const _this = this;
            this.modalInstance = $uibModal.open({
              animation: true,
              templateUrl: 'addProfileToImsi',
              controllerAs: 'vm',
              controller: function ($uibModalInstance) {
                this.modal    = $uibModalInstance;
                this.callback = (profile) => {
                  $scope.$broadcast('profile.add', {targetId: _this.eNodeB.eNBId, profile: profile});
                };
                this.eNodeB = _this.eNodeB;
              }
            });
          };
        }
      }
    });
}());
