(function () {
  angular.module('mCord')
  .service('Profile', function($injector, $resource, $q, $http, baseUrl){
    const r = $resource(`${baseUrl}onos/progran/profile/:id`, {id: '@Name'}, {
      save: {method: 'PUT'},
      query: {
        array: false,
        interceptor: {
          response: function(res){
            const Profile = $injector.get('Profile');
            return res.data.ProfileArray.map(p => new Profile(p));
          }
        }
      },
      get: {
        array: false,
        interceptor: {
          response: function(res){
            const Profile = $injector.get('Profile');
            return new Profile(res.data.ProfileArray[0]);
          }
        }
      }
    });

    r.prototype.getImsis = function(){
      const d = $q.defer();

      $http.get(`${baseUrl}onos/progran/profile/${this.Name}/imsi`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteImsis = function(){
      const d = $q.defer();

      $http.delete(`${baseUrl}onos/progran/profile/${this.Name}/imsi`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteImsi = function(id){
      const d = $q.defer();

      $http.delete(`${baseUrl}onos/progran/profile/${this.Name}/imsi/${id}`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.getEnodes = function(){
      const d = $q.defer();

      $http.get(`${baseUrl}onos/progran/profile/${this.Name}/enodeb`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteEnodes = function(){
      const d = $q.defer();

      $http.delete(`${baseUrl}onos/progran/profile/${this.Name}/enodeb`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteEnode = function(id){
      const d = $q.defer();

      $http.delete(`${baseUrl}onos/progran/profile/${this.Name}/enodeb/${id}`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    return r;
  })
})();