(function () {
  angular.module('mCord')
    .service('Imsi', function($injector, $resource, $q, $http, baseUrl){
      const r = $resource(`${baseUrl}onos/progran/imsi/:id`, {id: '@IMSI'}, {
        save: {method: 'PUT'},
        query: {
          array: false,
          interceptor: {
            response: function(res){
              const Imsi = $injector.get('Imsi');
              return res.data.ImsiArray.map(i => new Imsi(i));
            }
          }
        },
        get: {
          array: false,
          interceptor: {
            response: function(res){
              const Imsi = $injector.get('Imsi');
              return new Imsi(res.data.ImsiArray[0]);
            }
          }
        }
      });

      r.prototype.getProfiles = function(){
        const d = $q.defer();

        $http.get(`${baseUrl}onos/progran/imsi/${this.IMSI}/profile`)
          .then(res => {
            d.resolve(res.data);
          })
          .catch(err => {
            d.reject(err)
          });

        return d.promise;
      };

      r.prototype.deleteProfile = function(id){
        const d = $q.defer();
        $http.delete(`${baseUrl}onos/progran/imsi/${this.IMSI}/profile/${id}`)
          .then(res => {
            d.resolve(res.data);
          })
          .catch(err => {
            d.reject(err)
          });

        return d.promise;
      };

      return r;
    })
})();