/*
 * Copyright 2015 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

(function () {
  'use strict';

  var modules = [
    'ui.router',
    'ngResource',
    'ngAnimate',
    'ngCookies',
    'ngMap',
    'chart.js',
    'ngHttpCache',
    'xos.uiComponents',
    'ui.bootstrap.modal',
    'ui.bootstrap.tabs'
  ];

  angular.module('mCord', modules)
    .config(function ($stateProvider, $urlRouterProvider, $httpProvider) {

      $httpProvider.interceptors.push('SetCSRFToken');

      $urlRouterProvider.otherwise('/');

      $stateProvider
        .state('home', {
          url: '/',
          template: '<e-node-map></e-node-map>'
        })
        .state('login', {
          url: '/login',
          template: '<cord-login></cord-login>'
        })
        .state('enode', {
          url: '/enode',
          template: '<e-node-list></e-node-list>'
        })
        .state('enode-details', {
          url: '/enode/:id',
          template: '<e-node-details></e-node-details>'
        })
        .state('profile', {
          url: '/profile',
          template: '<profiles-list></profiles-list>'
        })
        .state('profile-details', {
          url: '/profile/:id',
          template: '<profile-details></profile-details>'
        })
        .state('imsi', {
          url: '/imsi',
          template: '<imsi-list></imsi-list>'
        })
        .state('imsi-details', {
          url: '/imsi/:id',
          template: '<imsi-details></imsi-details>'
        })
        .state('services', {
          url: '/services',
          controller: 'CordBundleCtrl',
          controllerAs: 'ctrl',
          templateUrl: 'app/view/services/services.html'
        });
    })
    .constant('cordConfig', {
      url: '',
      userActivity: {}, //check if really needed
      activeBundle: 1,
      bundles: [
        {
          "id": "family",
          "name": "Education Bundle",
          "desc": "Description for advanced bundle and the amazing thing it can do to managing Video Optimization.",
          "functions": [
            {
              "id": "cache",
              "name": "Cache",
              "desc": "Local content and frequently used content are served from local cache service entity. This will increase the quality of service by reduced delay and by avoiding the bottleneck of the legacy cloud based content services.",
              "params": {}
            },
            {
              "id": "firewall",
              "name": "Firewall",
              "desc": "This provides security services that control the incoming and outgoing network traffic. Enhanced features like IPS (Intrusion Prevention System), threat analysis and content filtering are also available.",
              "params": {}
            },
            {
              "id": "video",
              "name": "Video Optimization",
              "desc": "This can provide different video transcoding formats to improve video quality during congestion.Priority based badwidth resource allocation is also available",
              "params": {
                "levels": ["enabled", "disabled"]
              }
            }
          ]
        },
        {
          "id": "basic",
          "name": "Basic Bundle",
          "desc": "Description for basic bundle",
          "functions": [
            {
              "id": "cache",
              "name": "Cache",
              "desc": "Local content and frequently used content are served from local cache service entity. This will increase the quality of service by reduced delay and by avoiding the bottleneck of the legacy cloud based content services.",
              "params": {}
            },
            {
              "id": "firewall",
              "name": "Firewall",
              "desc": "This provides security services that control the incoming and outgoing network traffic. Enhanced features like IPS (Intrusion Prevention System), threat analysis and content filtering are also available.",
              "params": {}
            }
          ]
        }
      ]
    })
    .run(function($rootScope, $location, cordConfig, User, NgMap){
      cordConfig.url = 'http://' + $location.host() + ':' + $location.port();

      // basic authentication
      $rootScope.$on('$stateChangeStart', function() {
        if(!User.isLoggedIn()){
          $location.path('/login');
        }
      });
    });
}());
