/**
 * © OpenCORD
 *
 * Visit http://guide.xosproject.org/devguide/addview/ for more information
 *
 * Created by teone on 6/13/16.
 */

(function () {
  'use strict';
  angular.module('mCord')
    .directive('profilesList', function ($uibModal) {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/profiles-list/profiles-list.tpl.html',
        controller: function ($log, Profile) {
          Profile.query().$promise
            .then((profiles) => {
              this.profiles = profiles;
            });

          this.tableConfig = {
            order: true,
            filter: 'field',
            columns: [
              {
                label: '#',
                prop: 'Name',
                link: item => `#/profile/${item.Name}`
              },
              {
                label: 'DlSchedType',
                prop: 'DlSchedType'
              },
              {
                label: 'DlAllocRBRate',
                prop: 'DlAllocRBRate'
              },
              {
                label: 'UlSchedType',
                prop: 'UlSchedType'
              },
              {
                label: 'UlAllocRBRate',
                prop: 'UlAllocRBRate'
              },
              {
                label: 'Start',
                prop: 'Start'
              },
              {
                label: 'End',
                prop: 'End'
              }
            ]
          };
        }
      }
    });
})();

