/*global google: true */
(function () {
  'use strict';

  angular.module('mCord')
    .directive('eNodeMap', function ($uibModal) {
      return {
        restrict: 'E',
        scope: {},
        controllerAs: 'vm',
        templateUrl: 'app/view/home/e-node-map.tpl.html',
        controller: function($log, Enodeb, NgMap){

          let bounds;

          Enodeb.query().$promise
          .then((enodes) => {
            this.enodes = enodes;
            bounds = new google.maps.LatLngBounds();
            enodes.forEach(node => {
              if(angular.isDefined(node.GpsCoordinate.Latitude) && angular.isDefined(node.GpsCoordinate.Longitude)){
                const latlng = new google.maps.LatLng(node.GpsCoordinate.Latitude, node.GpsCoordinate.Longitude);
                bounds.extend(latlng);
              }
            });
            return NgMap.getMap();
          })
          .then((map) => {
            map.setCenter(bounds.getCenter());
            map.fitBounds(bounds);
          });

          this.showEnodeDetails = (marker, enode) => {
            this.selectedEnode = enode;
          };
          this.addEnode = () => {
            this.modalInstance = $uibModal.open({
              animation: true,
              templateUrl: 'addEnode',
              controllerAs: 'vm',
              controller: function($uibModalInstance){
                this.modal = $uibModalInstance;
              }
            });
          }
        }
      }
    });
}());
/*global google: false */