/*
 * Copyright 2015 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

angular.module('mCord')
  .directive('addImsiToItem', function () {
    return {
      restrict: 'E',
      templateUrl: 'app/components/add-imsi-to-item/add-imsi-to-item.html',
      scope: {
        modal: '=',
        cb: '=',
        item: '='
      },
      bindToController: true,
      controllerAs: 'vm',
      controller: function(Imsi){

        Imsi.query().$promise
        .then((imsis) => {
          this.imsis = imsis;
          return this.item.getImsis();
        })
        .then((itemImsi) => {
          console.log(itemImsi, this.imsis);
          this.imsis = _.differenceBy(this.imsis, itemImsi, 'IMSI');
        });

        this.config = {
          columns: [
            {
              label: '#',
              prop: 'IMSI',
              link: item => `#/imsi/${item.IMSI}`
            },
            {
              label: 'Enodeb',
              prop: 'Enodeb'
            },
            {
              label: 'DlMeasBitRate',
              prop: 'DlMeasBitRate'
            },
            {
              label: 'UlMeasBitRate',
              prop: 'UlMeasBitRate'
            },
            {
              label: 'Status',
              prop: 'UeStatus',
              type: 'boolean'
            }
          ],
          actions: [
            {
              label: 'Add',
              icon: 'plus',
              cb: (imsi) => {
                _.remove(this.imsis, p => p.IMSI === imsi.IMSI);
                this.cb(imsi);
              },
            }
          ],
          filter: 'field',
          order: true
        }
      }
    };
  });
