(function () {
  angular.module('mCord')
  .service('Enodeb', function($injector, $resource, $q, $http, baseUrl, Helpers){
    const r = $resource(`${baseUrl}onos/progran/enodeb/:id`, {id: '@eNBId'}, {
      //save: {method: 'PUT'},
      query: {
        array: false,
        interceptor: {
          response: function(res){
            const Enodeb = $injector.get('Enodeb');
            return res.data.EnodeBArray.map(n => new Enodeb(n));
          }
        }
      },
      get: {
        array: false,
        interceptor: {
          response: function(res){
            const Enodeb = $injector.get('Enodeb');
            return new Enodeb(res.data.EnodeBArray[0]);
          }
        }
      }
    });

    // Override the default save method,
    // Name is the key, so the $resource will try to update
    r.save = function(data){
      const d = $q.defer();
      $http.post(`${baseUrl}onos/progran/enodeb/`, data)
        .then(res => {
          d.resolve(res.data);
        })
        .catch(err => {
          d.reject(err)
        });
      return {$promise: d.promise};
    };

    r.prototype.getProfiles = function(){
      const d = $q.defer();

      $http.get(`${baseUrl}onos/progran/enodeb/${this.eNBId}/profile`)
      .then(res => {
        res.data = res.data.map(p => {
          p.jsStart = Helpers.stringToTime(p.Start);
          p.jsEnd = Helpers.stringToTime(p.End);
          return p;
        })
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.addProfile = function(data){
      const d = $q.defer();
      data = {'ProfileArray': [data.Name]};
      $http.post(`${baseUrl}onos/progran/enodeb/${this.eNBId}/profile`, data)
        .then(res => {
          d.resolve(res.data);
        })
        .catch(err => {
          d.reject(err)
        });

      return d.promise;
    };

    r.prototype.getStats = function(){
      const d = $q.defer();
      $http.get(`${baseUrl}onos/progran/stats/enodeb/${this.eNBId}/10`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    return r;
  })
})();