/*
 * Copyright 2015 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

angular.module('mCord')
  .directive('addEnodeToItem', function () {
    return {
      restrict: 'E',
      templateUrl: 'app/components/add-enode-to-item/add-enode-to-item.html',
      scope: {
        modal: '=',
        cb: '=',
        item: '='
      },
      bindToController: true,
      controllerAs: 'vm',
      controller: function(Enodeb){

        Enodeb.query().$promise
        .then((enodes) => {
          this.enodes = enodes;
          return this.item.getEnodes();
        })
        .then((itemEnodes) => {
          console.log(itemEnodes, this.enodes);
          this.enodes = _.differenceBy(this.enodes, itemEnodes, 'eNBId');
        });

        this.config = {
          columns: [
            {
              label: '#',
              prop: 'eNBId',
              link: item => `#/enode/${item.eNBId}`
            },
            {
              label: 'Ip Address',
              prop: 'IpAddr'
            },
            {
              label: 'Description',
              prop: 'Description'
            },
            {
              label: 'Status',
              prop: 'Status',
              type: 'boolean'
            }
          ],
          actions: [
            {
              label: 'Add',
              icon: 'plus',
              cb: (enode) => {
                _.remove(this.enodes, p => p.eNBId === enode.eNBId);
                this.cb(enode);
              },
            }
          ],
          filter: 'field',
          order: true
        }
      }
    };
  });
