/*
 * Copyright 2015 Open Networking Laboratory
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

angular.module('mCord')
  .directive('addImsi', function () {
    return {
      restrict: 'E',
      templateUrl: 'app/components/add-imsi/add-imsi.html',
      scope: {
        modal: '='
      },
      bindToController: true,
      controllerAs: 'vm',
      controller: function(Imsi, Enodeb, _){
        this.model = {
        };
        this.config = {
          formName: 'createImsi',
          fields: {
            IMSI: {
              type: 'number',
              validators: {
                required: true
              }
            }
          },
          actions: [
            {
              label: 'Save',
              icon: 'ok',
              cb: (imsi) => {
                // TODO validate form (wait for arpit to commit)
                Imsi.save(imsi).$promise
                .then(() => {
                  // TODO add to list
                  this.modal.close();
                })
                .catch(e => {
                  console.log(this.modal);
                })
              },
              class: 'success'
            },
            {
              label: 'Cancel',
              icon: 'remove',
              cb: () => {
                this.modal.close();
              },
              class: 'warning'
            }
          ]
        };
      }
    };
  });
