(function () {
  angular.module('mCord')
  .service('Profile', function($resource, $q, $http, baseUrl){
    const r = $resource(`${baseUrl}api/profile/:id`, {id: '@Name'});

    r.prototype.getImsis = function(){
      const d = $q.defer();

      $http.get(`${baseUrl}api/profile/${this.Name}/imsi`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteImsis = function(){
      const d = $q.defer();

      $http.delete(`${baseUrl}api/profile/${this.Name}/imsi`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteImsi = function(id){
      const d = $q.defer();

      $http.delete(`${baseUrl}api/profile/${this.Name}/imsi/${id}`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.getEnodes = function(){
      const d = $q.defer();

      $http.get(`${baseUrl}api/profile/${this.Name}/enodeb`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteEnodes = function(){
      const d = $q.defer();

      $http.delete(`${baseUrl}api/profile/${this.Name}/enodeb`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    r.prototype.deleteEnode = function(id){
      const d = $q.defer();

      $http.delete(`${baseUrl}api/profile/${this.Name}/enodeb/${id}`)
      .then(res => {
        d.resolve(res.data);
      })
      .catch(err => {
        d.reject(err)
      });

      return d.promise;
    };

    return r;
  })
})();