(function () {
  'use strict';

  angular.module('mCord')
    .directive('eNodeMapPanel', function () {
      return {
        restrict: 'E',
        scope: {
          eNodeB: '='
        },
        bindToController: true,
        controllerAs: 'vm',
        templateUrl: 'app/view/home/e-node-map-panel.tpl.html',
        controller: function($scope, $filter, _){
          this.close = () => {
            delete this.eNodeB;
          }

          $scope.$watch(() => this.eNodeB, enode => {
            if(enode){
              loadProfiles();
            }
          });

          const loadProfiles = () => {
            this.eNodeB.getProfiles()
            .then((profiles) => {
              this.profiles = profiles;
              return this.eNodeB.getStats();
            })
            .then((stats) => {
              this.selectedStats = 'download_data';
              this.stats = formatStats(stats);
            });
          };

          const formatStats = stats => {
            let series = _.reduce(stats, (list, s) => {
              return list.concat([s.Profile]);
            }, []);
            let labels = _.reduce(stats[0].StatsArray, (list, s) => {
              return list.concat([$filter('date')(new Date(s.Time * 1000), 'shortTime')]);
            }, []);
            const download_data = _.reduce(stats, (list, stat) => {
              let bitrate = _.reduce(stat.StatsArray, (data, s) => {
                return data.concat([s.DlBitrate]);
              }, []);
              list.push(bitrate);
              return list;
            }, []);
            const upload_data = _.reduce(stats, (list, stat) => {
              let bitrate = _.reduce(stat.StatsArray, (data, s) => {
                return data.concat([s.UlBitrate]);
              }, []);
              list.push(bitrate);
              return list;
            }, []);
            return {
              labels: labels,
              series: series,
              data: download_data,
              upload_data: upload_data,
              download_data: download_data
            };
          };

          this.setChart = type => {
            if(!this.stats){
              return;
            }
            this.selectedStats = type;
            this.stats.data = this.stats[type];
          }
        }
      }
    });
}());
